/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JFileChooser;
import weka.LocalString;

public class FileEditor
extends PropertyEditorSupport {
    protected JFileChooser m_FileChooser;

    public String getJavaInitializationString() {
        File file = (File)this.getValue();
        if (file == null) {
            return LocalString.get("null");
        }
        return LocalString.get("new File(\"") + file.getName() + "\")";
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.m_FileChooser == null) {
            File file = (File)this.getValue();
            if (file != null) {
                this.m_FileChooser = new JFileChooser();
                this.m_FileChooser.setSelectedFile(file);
            } else {
                this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
            }
            this.m_FileChooser.setApproveButtonText(LocalString.get("Select"));
            this.m_FileChooser.setApproveButtonMnemonic('S');
            this.m_FileChooser.setFileSelectionMode(2);
            this.m_FileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ApproveSelection")) {
                        File file = FileEditor.this.m_FileChooser.getSelectedFile();
                        FileEditor.this.setValue(file);
                    }
                }
            });
        }
        return this.m_FileChooser;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getHeight()) / 2;
        File file = (File)this.getValue();
        String string = LocalString.get("No file");
        if (file != null) {
            string = file.getName();
        }
        graphics.drawString(string, 2, fontMetrics.getHeight() + n);
    }
}

