/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.LocalString;
import weka.core.Utils;
import weka.estimators.Estimator;

public class PoissonEstimator
implements Estimator {
    private double m_NumValues;
    private double m_SumOfValues;
    private double m_Lambda;

    private double logFac(double d) {
        double d2 = 0.0;
        for (double d3 = 2.0; d3 <= d; d3 += 1.0) {
            d2 += Math.log(d3);
        }
        return d2;
    }

    private double Poisson(double d) {
        return Math.exp(-this.m_Lambda + d * Math.log(this.m_Lambda) - this.logFac(d));
    }

    public void addValue(double d, double d2) {
        this.m_NumValues += d2;
        this.m_SumOfValues += d * d2;
        if (this.m_NumValues != 0.0) {
            this.m_Lambda = this.m_SumOfValues / this.m_NumValues;
        }
    }

    public double getProbability(double d) {
        return this.Poisson(d);
    }

    public String toString() {
        return LocalString.get("Poisson Lambda = ") + Utils.doubleToString(this.m_Lambda, 4, 2) + "\n";
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                System.out.println(LocalString.get("Please specify a set of instances."));
                return;
            }
            PoissonEstimator poissonEstimator = new PoissonEstimator();
            for (int i = 0; i < stringArray.length; ++i) {
                double d = Double.valueOf(stringArray[i]);
                System.out.println(poissonEstimator);
                System.out.println(LocalString.get("Prediction for ") + d + " = " + poissonEstimator.getProbability(d));
                poissonEstimator.addValue(d, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

