/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.LocalString;
import weka.core.Statistics;
import weka.core.Utils;

public final class SpecialFunctions {
    private static double log2 = Math.log(2.0);

    public static double lnFactorial(double d) {
        return Statistics.lnGamma(d + 1.0);
    }

    public static double log2Binomial(double d, double d2) {
        if (Utils.gr(d2, d)) {
            throw new ArithmeticException(LocalString.get("Can't compute binomial coefficient."));
        }
        return (SpecialFunctions.lnFactorial(d) - SpecialFunctions.lnFactorial(d2) - SpecialFunctions.lnFactorial(d - d2)) / log2;
    }

    public static double log2Multinomial(double d, double[] dArray) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (Utils.gr(dArray[i], d)) {
                throw new ArithmeticException(LocalString.get("Can't compute multinomial coefficient."));
            }
            d2 += SpecialFunctions.lnFactorial(dArray[i]);
        }
        return (SpecialFunctions.lnFactorial(d) - d2) / log2;
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{1.0, 2.0, 3.0};
        System.out.println("6!: " + Math.exp(SpecialFunctions.lnFactorial(6.0)));
        System.out.println(LocalString.get("Binomial 6 over 2: ") + Math.pow(2.0, SpecialFunctions.log2Binomial(6.0, 2.0)));
        System.out.println(LocalString.get("Multinomial 6 over 1, 2, 3: ") + Math.pow(2.0, SpecialFunctions.log2Multinomial(6.0, dArray)));
    }
}

