/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;

public class Id3
extends Classifier {
    private Id3[] m_Successors;
    private Attribute m_Attribute;
    private double m_ClassValue;
    private double[] m_Distribution;
    private Attribute m_ClassAttribute;

    public String globalInfo() {
        return LocalString.get("Class for constructing an unpruned decision tree based on the ID3 ") + LocalString.get("algorithm. Can only deal with nominal attributes. No missing values ") + LocalString.get("allowed. Empty leaves may result in unclassified instances. For more ") + LocalString.get("information see: \n\n") + LocalString.get(" R. Quinlan (1986). \"Induction of decision ") + LocalString.get("trees\". Machine Learning. Vol.1, No.1, pp. 81-106");
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException(LocalString.get("Id3: nominal class, please."));
        }
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            if (((Attribute)enumeration.nextElement()).isNominal()) continue;
            throw new UnsupportedAttributeTypeException(LocalString.get("Id3: only nominal ") + LocalString.get("attributes, please."));
        }
        Enumeration enumeration2 = instances.enumerateInstances();
        while (enumeration2.hasMoreElements()) {
            if (!((Instance)enumeration2.nextElement()).hasMissingValue()) continue;
            throw new NoSupportForMissingValuesException(LocalString.get("Id3: no missing values, ") + LocalString.get("please."));
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.makeTree(instances);
    }

    private void makeTree(Instances instances) throws Exception {
        Object object;
        if (instances.numInstances() == 0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[instances.numClasses()];
            return;
        }
        double[] dArray = new double[instances.numAttributes()];
        Enumeration enumeration = instances.enumerateAttributes();
        while (enumeration.hasMoreElements()) {
            object = (Instances[])enumeration.nextElement();
            dArray[((Attribute)object).index()] = this.computeInfoGain(instances, (Attribute)object);
        }
        this.m_Attribute = instances.attribute(Utils.maxIndex(dArray));
        if (Utils.eq(dArray[this.m_Attribute.index()], 0.0)) {
            this.m_Attribute = null;
            this.m_Distribution = new double[instances.numClasses()];
            object = instances.enumerateInstances();
            while (object.hasMoreElements()) {
                Instance instance = (Instance)object.nextElement();
                int n = (int)instance.classValue();
                this.m_Distribution[n] = this.m_Distribution[n] + 1.0;
            }
            Utils.normalize(this.m_Distribution);
            this.m_ClassValue = Utils.maxIndex(this.m_Distribution);
            this.m_ClassAttribute = instances.classAttribute();
        } else {
            object = this.splitData(instances, this.m_Attribute);
            this.m_Successors = new Id3[this.m_Attribute.numValues()];
            for (int i = 0; i < this.m_Attribute.numValues(); ++i) {
                this.m_Successors[i] = new Id3();
                this.m_Successors[i].makeTree((Instances)object[i]);
            }
        }
    }

    public double classifyInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException(LocalString.get("Id3: no missing values, ") + LocalString.get("please."));
        }
        if (this.m_Attribute == null) {
            return this.m_ClassValue;
        }
        return this.m_Successors[(int)instance.value(this.m_Attribute)].classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws NoSupportForMissingValuesException {
        if (instance.hasMissingValue()) {
            throw new NoSupportForMissingValuesException(LocalString.get("Id3: no missing values, ") + LocalString.get("please."));
        }
        if (this.m_Attribute == null) {
            return this.m_Distribution;
        }
        return this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_Distribution == null && this.m_Successors == null) {
            return LocalString.get("Id3: No model built yet.");
        }
        return LocalString.get("Id3\n\n") + this.toString(0);
    }

    private double computeInfoGain(Instances instances, Attribute attribute) throws Exception {
        double d = this.computeEntropy(instances);
        Instances[] instancesArray = this.splitData(instances, attribute);
        for (int i = 0; i < attribute.numValues(); ++i) {
            if (instancesArray[i].numInstances() <= 0) continue;
            d -= (double)instancesArray[i].numInstances() / (double)instances.numInstances() * this.computeEntropy(instancesArray[i]);
        }
        return d;
    }

    private double computeEntropy(Instances instances) throws Exception {
        double[] dArray = new double[instances.numClasses()];
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n = (int)instance.classValue();
            dArray[n] = dArray[n] + 1.0;
        }
        double d = 0.0;
        for (int i = 0; i < instances.numClasses(); ++i) {
            if (!(dArray[i] > 0.0)) continue;
            d -= dArray[i] * Utils.log2(dArray[i]);
        }
        return (d /= (double)instances.numInstances()) + Utils.log2(instances.numInstances());
    }

    private Instances[] splitData(Instances instances, Attribute attribute) {
        Instances[] instancesArray = new Instances[attribute.numValues()];
        for (int i = 0; i < attribute.numValues(); ++i) {
            instancesArray[i] = new Instances(instances, instances.numInstances());
        }
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            instancesArray[(int)instance.value(attribute)].add(instance);
        }
        for (int i = 0; i < instancesArray.length; ++i) {
            instancesArray[i].compactify();
        }
        return instancesArray;
    }

    private String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                stringBuffer.append(LocalString.get(": null"));
            } else {
                stringBuffer.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue));
            }
        } else {
            for (int i = 0; i < this.m_Attribute.numValues(); ++i) {
                stringBuffer.append("\n");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("|  ");
                }
                stringBuffer.append(this.m_Attribute.name() + " = " + this.m_Attribute.value(i));
                stringBuffer.append(this.m_Successors[i].toString(n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Id3(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

