/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.trees.lmt.LogisticBase;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class SimpleLogistic
extends Classifier
implements OptionHandler,
AdditionalMeasureProducer,
WeightedInstancesHandler {
    protected LogisticBase m_boostedModel;
    protected NominalToBinary m_NominalToBinary = null;
    protected ReplaceMissingValues m_ReplaceMissingValues = null;
    protected int m_numBoostingIterations;
    protected int m_maxBoostingIterations = 500;
    protected int m_heuristicStop = 50;
    protected boolean m_useCrossValidation;
    protected boolean m_errorOnProbabilities;

    public SimpleLogistic() {
        this.m_numBoostingIterations = 0;
        this.m_useCrossValidation = true;
        this.m_errorOnProbabilities = false;
    }

    public SimpleLogistic(int n, boolean bl, boolean bl2) {
        this.m_numBoostingIterations = n;
        this.m_useCrossValidation = bl;
        this.m_errorOnProbabilities = bl2;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (instances.classAttribute().type() != 1) {
            throw new UnsupportedClassTypeException(LocalString.get("Class attribute must be nominal."));
        }
        if (instances.checkForStringAttributes()) {
            throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
        }
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numInstances() == 0) {
            throw new Exception(LocalString.get("No instances without missing class values in training file!"));
        }
        this.m_ReplaceMissingValues = new ReplaceMissingValues();
        this.m_ReplaceMissingValues.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_ReplaceMissingValues);
        this.m_NominalToBinary = new NominalToBinary();
        this.m_NominalToBinary.setInputFormat(instances);
        instances = Filter.useFilter(instances, this.m_NominalToBinary);
        this.m_boostedModel = new LogisticBase(this.m_numBoostingIterations, this.m_useCrossValidation, this.m_errorOnProbabilities);
        this.m_boostedModel.setMaxIterations(this.m_maxBoostingIterations);
        this.m_boostedModel.setHeuristicStop(this.m_heuristicStop);
        this.m_boostedModel.buildClassifier(instances);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingValues.input(instance);
        instance = this.m_ReplaceMissingValues.output();
        this.m_NominalToBinary.input(instance);
        instance = this.m_NominalToBinary.output();
        return this.m_boostedModel.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option(LocalString.get("\tSet fixed number of iterations for LogitBoost\n"), "I", 1, LocalString.get("-I <iterations>")));
        vector.addElement(new Option(LocalString.get("\tUse stopping criterion on training set (instead of cross-validation)\n"), "S", 0, "-S"));
        vector.addElement(new Option(LocalString.get("\tUse error on probabilities (rmse) instead of misclassification error ") + LocalString.get("for stopping criterion\n"), "P", 0, "-P"));
        vector.addElement(new Option(LocalString.get("\tSet maximum number of boosting iterations\n"), "M", 1, LocalString.get("-M <iterations>")));
        vector.addElement(new Option(LocalString.get("\tSet parameter for heuristic for early stopping of LogitBoost.") + LocalString.get("If enabled, the minimum is selected greedily, stopping if the current minimum") + LocalString.get(" has not changed for iter iterations. By default, heuristic is enabled with") + LocalString.get("value 50. Set to zero to disable heuristic.") + "\n", "H", 1, LocalString.get("-H <iterations>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setNumBoostingIterations(new Integer(string));
        }
        this.setUseCrossValidation(!Utils.getFlag('S', stringArray));
        this.setErrorOnProbabilities(Utils.getFlag('P', stringArray));
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMaxBoostingIterations(new Integer(string));
        }
        if ((string = Utils.getOption('H', stringArray)).length() != 0) {
            this.setHeuristicStop(new Integer(string));
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[9];
        int n = 0;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.getNumBoostingIterations();
        if (!this.getUseCrossValidation()) {
            stringArray[n++] = "-S";
        }
        if (this.getErrorOnProbabilities()) {
            stringArray[n++] = "-P";
        }
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.getMaxBoostingIterations();
        stringArray[n++] = "-H";
        stringArray[n++] = "" + this.getHeuristicStop();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public int getNumBoostingIterations() {
        return this.m_numBoostingIterations;
    }

    public boolean getUseCrossValidation() {
        return this.m_useCrossValidation;
    }

    public boolean getErrorOnProbabilities() {
        return this.m_errorOnProbabilities;
    }

    public int getMaxBoostingIterations() {
        return this.m_maxBoostingIterations;
    }

    public int getHeuristicStop() {
        return this.m_heuristicStop;
    }

    public void setNumBoostingIterations(int n) {
        this.m_numBoostingIterations = n;
    }

    public void setUseCrossValidation(boolean bl) {
        this.m_useCrossValidation = bl;
    }

    public void setErrorOnProbabilities(boolean bl) {
        this.m_errorOnProbabilities = bl;
    }

    public void setMaxBoostingIterations(int n) {
        this.m_maxBoostingIterations = n;
    }

    public void setHeuristicStop(int n) {
        this.m_heuristicStop = n == 0 ? this.m_maxBoostingIterations : n;
    }

    public int getNumRegressions() {
        return this.m_boostedModel.getNumRegressions();
    }

    public String toString() {
        if (this.m_boostedModel == null) {
            return LocalString.get("No model built");
        }
        return "SimpleLogistic:\n" + this.m_boostedModel.toString();
    }

    public double measureAttributesUsed() {
        return this.m_boostedModel.percentAttributesUsed();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(3);
        vector.addElement(LocalString.get("measureAttributesUsed"));
        vector.addElement(LocalString.get("measureNumIterations"));
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase(LocalString.get("measureAttributesUsed")) == 0) {
            return this.measureAttributesUsed();
        }
        if (string.compareToIgnoreCase(LocalString.get("measureNumIterations")) == 0) {
            return this.getNumRegressions();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (SimpleLogistic)"));
    }

    public String globalInfo() {
        return LocalString.get("Classifier for building linear logistic regression models. LogitBoost with simple regression ") + LocalString.get("functions as base learners is used for fitting the logistic models. The optimal number of LogitBoost ") + LocalString.get("iterations to perform is cross-validated, which leads to automatic attribute selection. ") + LocalString.get("For more information see: N.Landwehr, M.Hall, E. Frank 'Logistic Model Trees' (ECML 2003).");
    }

    public String numBoostingIterationsTipText() {
        return LocalString.get("Set fixed number of iterations for LogitBoost. If >= 0, this sets the number of LogitBoost iterations ") + LocalString.get("to perform. If < 0, the number is cross-validated or a stopping criterion on the training set is used ") + LocalString.get("(depending on the value of useCrossValidation).");
    }

    public String useCrossValidationTipText() {
        return LocalString.get("Sets whether the number of LogitBoost iterations is to be cross-validated or the stopping criterion ") + LocalString.get("on the training set should be used. If not set (and no fixed number of iterations was given), ") + LocalString.get("the number of LogitBoost iterations is used that minimizes the error on the training set ") + LocalString.get("(misclassification error or error on probabilities depending on errorOnProbabilities).");
    }

    public String errorOnProbabilitiesTipText() {
        return LocalString.get("Use error on the probabilties as error measure when determining the best number of LogitBoost iterations. ") + LocalString.get("If set, the number of LogitBoost iterations is chosen that minimizes the root mean squared error ") + LocalString.get("(either on the training set or in the cross-validation, depending on useCrossValidation).");
    }

    public String maxBoostingIterationsTipText() {
        return LocalString.get("Sets the maximum number of iterations for LogitBoost. Default value is 500, for very small/large ") + LocalString.get("datasets a lower/higher value might be preferable.");
    }

    public String heuristicStopTipText() {
        return LocalString.get("If heuristicStop > 0, the heuristic for greedy stopping while cross-validating the number of ") + LocalString.get("LogitBoost iterations is enabled. This means LogitBoost is stopped if no new error minimum ") + LocalString.get("has been reached in the last heuristicStop iterations. It is recommended to use this heuristic, ") + LocalString.get("it gives a large speed-up especially on small datasets. The default value is 50.");
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new SimpleLogistic(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

