/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.NormalizedPolyKernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class SMOreg
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    protected boolean m_featureSpaceNormalization = false;
    protected boolean m_useRBF = false;
    protected int m_cacheSize = 250007;
    protected Kernel m_kernel;
    protected boolean m_lowerOrder = false;
    protected double m_exponent = 1.0;
    protected double m_gamma = 0.01;
    protected int m_classIndex = -1;
    protected boolean m_onlyNumeric;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, LocalString.get("Normalize training data")), new Tag(1, LocalString.get("Standardize training data")), new Tag(2, LocalString.get("No normalization/standardization"))};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = false;
    protected Instances m_data;
    protected double m_C = 1.0;
    protected double[] m_alpha;
    protected double[] m_alpha_;
    protected double m_b;
    protected double m_bLow;
    protected double m_bUp;
    protected int m_iLow;
    protected int m_iUp;
    protected double[] m_weights;
    protected double[] m_fcache;
    protected SMOset m_I0;
    protected SMOset m_I1;
    protected SMOset m_I2;
    protected SMOset m_I3;
    protected double m_epsilon = 0.001;
    protected double m_tol = 0.001;
    protected double m_eps = 1.0E-12;
    protected static double m_Del = 1.0E-10;
    protected double m_Alin;
    protected double m_Blin;
    protected double[] m_sparseWeights;
    protected int[] m_sparseIndices;

    public String globalInfo() {
        return LocalString.get("Implements Alex Smola and Bernhard Scholkopf's sequential minimal ") + LocalString.get("optimization algorithm for training a support vector regression model. ") + LocalString.get("This implementation globally replaces all missing values and ") + LocalString.get("transforms nominal attributes into binary ones. It also ") + LocalString.get("normalizes all attributes by default. (Note that the coefficients ") + LocalString.get("in the output are based on the normalized/standardized data, not the ") + LocalString.get("original data.) ") + LocalString.get("For more information on the SMO algorithm, see\n\n") + LocalString.get("Alex J. Smola, Bernhard Scholkopf (1998). \"A Tutorial on Support Vector ") + LocalString.get("Regression\".  NeuroCOLT2 Technical Report Series - NC2-TR-1998-030.\n\n") + LocalString.get("S.K. Shevade, S.S. Keerthi, C. Bhattacharyya, K.R.K. Murthy,  ") + LocalString.get("\"Improvements to SMO Algorithm for SVM Regression\".  ") + LocalString.get("Technical Report CD-99-16, Control Division Dept of Mechanical and ") + LocalString.get("Production Engineering, National University of Singapore. ");
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        Serializable serializable;
        if (!this.m_checksTurnedOff) {
            if (instances.checkForStringAttributes()) {
                throw new UnsupportedAttributeTypeException(LocalString.get("Cannot handle string attributes!"));
            }
            if (instances.classAttribute().isNominal()) {
                throw new UnsupportedClassTypeException(LocalString.get("SMOreg can't handle a nominal class! ") + LocalString.get("Use SMO for performing ") + LocalString.get("classification."));
            }
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
            if (instances.numInstances() == 0) {
                throw new Exception(LocalString.get("No training instances without a missing class!"));
            }
            serializable = new Instances(instances, instances.numInstances());
            for (int i = 0; i < instances.numInstances(); ++i) {
                if (!(instances.instance(i).weight() > 0.0)) continue;
                ((Instances)serializable).add(instances.instance(i));
            }
            if (((Instances)serializable).numInstances() == 0) {
                throw new Exception(LocalString.get("No training instances left after removing ") + LocalString.get("instance with either a weight null or a missing class!"));
            }
            instances = serializable;
        }
        this.m_onlyNumeric = true;
        if (!this.m_checksTurnedOff) {
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
                this.m_onlyNumeric = false;
                break;
            }
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary = new NominalToBinary();
            this.m_NominalToBinary.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_classIndex = instances.classIndex();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            ((Normalize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_data = instances;
        if (this.m_Filter != null) {
            serializable = (Instance)instances.instance(0).copy();
            ((Instance)serializable).setValue(this.m_classIndex, 0.0);
            this.m_Filter.input((Instance)serializable);
            this.m_Filter.batchFinished();
            Instance instance = this.m_Filter.output();
            this.m_Blin = instance.value(this.m_classIndex);
            ((Instance)serializable).setValue(this.m_classIndex, 1.0);
            this.m_Filter.input((Instance)serializable);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
            this.m_Alin = instance.value(this.m_classIndex) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        this.m_kernel = this.m_useRBF ? new RBFKernel(this.m_data, this.m_cacheSize, this.m_gamma) : (this.m_featureSpaceNormalization ? new NormalizedPolyKernel(this.m_data, this.m_cacheSize, this.m_exponent, this.m_lowerOrder) : new PolyKernel(this.m_data, this.m_cacheSize, this.m_exponent, this.m_lowerOrder));
        this.m_weights = (double[])(!this.m_useRBF && this.m_exponent == 1.0 ? new double[this.m_data.numAttributes()] : null);
        this.m_fcache = new double[this.m_data.numInstances()];
        this.m_I0 = new SMOset(this.m_data.numInstances());
        this.m_I1 = new SMOset(this.m_data.numInstances());
        this.m_I2 = new SMOset(this.m_data.numInstances());
        this.m_I3 = new SMOset(this.m_data.numInstances());
        this.m_alpha = new double[this.m_data.numInstances()];
        this.m_alpha_ = new double[this.m_data.numInstances()];
        for (n2 = 0; n2 < this.m_data.numInstances(); ++n2) {
            this.m_I1.insert(n2);
        }
        this.m_bUp = this.m_data.instance(0).classValue() + this.m_epsilon;
        this.m_bLow = this.m_data.instance(0).classValue() - this.m_epsilon;
        this.m_iLow = 0;
        this.m_iUp = 0;
        n2 = 0;
        boolean bl = true;
        while (n2 > 0 || bl) {
            n2 = 0;
            if (bl) {
                for (n = 0; n < this.m_alpha.length; ++n) {
                    n2 += this.examineExample(n);
                }
            } else {
                n = this.m_I0.getNext(-1);
                while (n != -1) {
                    n2 += this.examineExample(n);
                    if (this.m_bUp > this.m_bLow - 2.0 * this.m_tol) {
                        n2 = 0;
                        break;
                    }
                    n = this.m_I0.getNext(n);
                }
            }
            if (bl) {
                bl = false;
                continue;
            }
            if (n2 != 0) continue;
            bl = true;
        }
        this.m_b = (this.m_bLow + this.m_bUp) / 2.0;
        this.m_kernel.clean();
        this.m_fcache = null;
        this.m_I3 = null;
        this.m_I2 = null;
        this.m_I1 = null;
        this.m_I0 = null;
        if (!this.m_useRBF && this.m_exponent == 1.0) {
            for (n = 0; n < this.m_weights.length; ++n) {
                this.m_weights[n] = 0.0;
            }
            for (n = 0; n < this.m_alpha.length; ++n) {
                for (int i = 0; i < this.m_weights.length; ++i) {
                    if (i == this.m_data.classIndex()) continue;
                    int n3 = i;
                    this.m_weights[n3] = this.m_weights[n3] + (this.m_alpha[n] - this.m_alpha_[n]) * this.m_data.instance(n).value(i);
                }
            }
            double[] dArray = new double[this.m_weights.length];
            int[] nArray = new int[this.m_weights.length];
            int n4 = 0;
            for (int i = 0; i < this.m_weights.length; ++i) {
                if (this.m_weights[i] == 0.0) continue;
                dArray[n4] = this.m_weights[i];
                nArray[n4] = i;
                ++n4;
            }
            this.m_sparseWeights = new double[n4];
            this.m_sparseIndices = new int[n4];
            System.arraycopy(dArray, 0, this.m_sparseWeights, 0, n4);
            System.arraycopy(nArray, 0, this.m_sparseIndices, 0, n4);
            this.m_data = !this.m_checksTurnedOff ? new Instances(this.m_data, 0) : null;
            this.m_weights = null;
            this.m_alpha = null;
            this.m_alpha_ = null;
        }
    }

    protected int examineExample(int n) throws Exception {
        int n2;
        double d = this.m_alpha[n];
        double d2 = this.m_alpha_[n];
        double d3 = 0.0;
        if (this.m_I0.contains(n)) {
            d3 = this.m_fcache[n];
        } else {
            d3 = this.m_data.instance(n).classValue();
            for (n2 = 0; n2 < this.m_alpha.length; ++n2) {
                d3 -= (this.m_alpha[n2] - this.m_alpha_[n2]) * this.m_kernel.eval(n, n2, this.m_data.instance(n));
            }
            this.m_fcache[n] = d3;
            if (this.m_I1.contains(n)) {
                if (d3 + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = d3 + this.m_epsilon;
                    this.m_iUp = n;
                } else if (d3 - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = d3 - this.m_epsilon;
                    this.m_iLow = n;
                }
            } else if (this.m_I2.contains(n) && d3 + this.m_epsilon > this.m_bLow) {
                this.m_bLow = d3 + this.m_epsilon;
                this.m_iLow = n;
            } else if (this.m_I3.contains(n) && d3 - this.m_epsilon < this.m_bUp) {
                this.m_bUp = d3 - this.m_epsilon;
                this.m_iUp = n;
            }
        }
        n2 = 1;
        int n3 = -1;
        if (this.m_I0.contains(n) && 0.0 < d && d < this.m_C * this.m_data.instance(n).weight()) {
            if (this.m_bLow - (d3 - this.m_epsilon) > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iLow;
                if (d3 - this.m_epsilon - this.m_bUp > this.m_bLow - (d3 - this.m_epsilon)) {
                    n3 = this.m_iUp;
                }
            } else if (d3 - this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iUp;
                if (this.m_bLow - (d3 - this.m_epsilon) > d3 - this.m_epsilon - this.m_bUp) {
                    n3 = this.m_iLow;
                }
            }
        } else if (this.m_I0.contains(n) && 0.0 < d2 && d2 < this.m_C * this.m_data.instance(n).weight()) {
            if (this.m_bLow - (d3 + this.m_epsilon) > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iLow;
                if (d3 + this.m_epsilon - this.m_bUp > this.m_bLow - (d3 + this.m_epsilon)) {
                    n3 = this.m_iUp;
                }
            } else if (d3 + this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iUp;
                if (this.m_bLow - (d3 + this.m_epsilon) > d3 + this.m_epsilon - this.m_bUp) {
                    n3 = this.m_iLow;
                }
            }
        } else if (this.m_I1.contains(n)) {
            if (this.m_bLow - (d3 + this.m_epsilon) > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iLow;
                if (d3 + this.m_epsilon - this.m_bUp > this.m_bLow - (d3 + this.m_epsilon)) {
                    n3 = this.m_iUp;
                }
            } else if (d3 - this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iUp;
                if (this.m_bLow - (d3 - this.m_epsilon) > d3 - this.m_epsilon - this.m_bUp) {
                    n3 = this.m_iLow;
                }
            }
        } else if (this.m_I2.contains(n)) {
            if (d3 + this.m_epsilon - this.m_bUp > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iUp;
            }
        } else if (this.m_I3.contains(n)) {
            if (this.m_bLow - (d3 - this.m_epsilon) > 2.0 * this.m_tol) {
                n2 = 0;
                n3 = this.m_iLow;
            }
        } else {
            throw new RuntimeException(LocalString.get("Inconsistent state ! I0, I1, I2 and I3 ") + LocalString.get("must cover the whole set of indices."));
        }
        if (n2 != 0) {
            return 0;
        }
        if (this.takeStep(n3, n)) {
            return 1;
        }
        return 0;
    }

    protected boolean takeStep(int n, int n2) throws Exception {
        if (n == n2) {
            return false;
        }
        double d = this.m_alpha[n];
        double d2 = this.m_alpha_[n];
        double d3 = this.m_alpha[n2];
        double d4 = this.m_alpha_[n2];
        double d5 = this.m_fcache[n];
        double d6 = this.m_fcache[n2];
        double d7 = this.m_kernel.eval(n, n, this.m_data.instance(n));
        double d8 = this.m_kernel.eval(n, n2, this.m_data.instance(n));
        double d9 = this.m_kernel.eval(n2, n2, this.m_data.instance(n2));
        double d10 = -2.0 * d8 + d7 + d9;
        double d11 = d - d2 + d3 - d4;
        if (d10 < 0.0) {
            d10 = 0.0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        double d12 = d5 - d6;
        boolean bl6 = false;
        while (!bl5) {
            double d13;
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            if (!bl && (d > 0.0 || d2 == 0.0 && d12 > 0.0) && (d3 > 0.0 || d4 == 0.0 && d12 < 0.0)) {
                d18 = Math.max(0.0, d11 - this.m_C * this.m_data.instance(n).weight());
                if (d18 < (d17 = Math.min(this.m_C * this.m_data.instance(n2).weight(), d11))) {
                    if (d10 > 0.0) {
                        d16 = d3 - d12 / d10;
                        if (d16 > d17) {
                            d16 = d17;
                        } else if (d16 < d18) {
                            d16 = d18;
                        }
                    } else {
                        d15 = -d18 * d12;
                        d14 = -d17 * d12;
                        d16 = d15 > d14 ? d18 : d17;
                    }
                    d13 = d - (d16 - d3);
                    if (Math.abs(d13 - d) > this.m_eps || Math.abs(d16 - d3) > this.m_eps) {
                        d = d13;
                        d3 = d16;
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                }
                bl = true;
            } else if (!bl2 && (d > 0.0 || d2 == 0.0 && d12 > 2.0 * this.m_epsilon) && (d4 > 0.0 || d3 == 0.0 && d12 > 2.0 * this.m_epsilon)) {
                d18 = Math.max(0.0, -d11);
                if (d18 < (d17 = Math.min(this.m_C * this.m_data.instance(n2).weight(), -d11 + this.m_C * this.m_data.instance(n).weight()))) {
                    if (d10 > 0.0) {
                        d16 = d4 + (d12 - 2.0 * this.m_epsilon) / d10;
                        if (d16 > d17) {
                            d16 = d17;
                        } else if (d16 < d18) {
                            d16 = d18;
                        }
                    } else {
                        d15 = d18 * (-2.0 * this.m_epsilon + d12);
                        d14 = d17 * (-2.0 * this.m_epsilon + d12);
                        d16 = d15 > d14 ? d18 : d17;
                    }
                    d13 = d + (d16 - d4);
                    if (Math.abs(d13 - d) > this.m_eps || Math.abs(d16 - d4) > this.m_eps) {
                        d = d13;
                        d4 = d16;
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                }
                bl2 = true;
            } else if (!bl3 && (d2 > 0.0 || d == 0.0 && d12 < -2.0 * this.m_epsilon) && (d3 > 0.0 || d4 == 0.0 && d12 < -2.0 * this.m_epsilon)) {
                d18 = Math.max(0.0, d11);
                if (d18 < (d17 = Math.min(this.m_C * this.m_data.instance(n2).weight(), this.m_C * this.m_data.instance(n).weight() + d11))) {
                    if (d10 > 0.0) {
                        d16 = d3 - (d12 + 2.0 * this.m_epsilon) / d10;
                        if (d16 > d17) {
                            d16 = d17;
                        } else if (d16 < d18) {
                            d16 = d18;
                        }
                    } else {
                        d15 = -d18 * (2.0 * this.m_epsilon + d12);
                        d14 = -d17 * (2.0 * this.m_epsilon + d12);
                        d16 = d15 > d14 ? d18 : d17;
                    }
                    d13 = d2 + (d16 - d3);
                    if (Math.abs(d13 - d2) > this.m_eps || Math.abs(d16 - d3) > this.m_eps) {
                        d2 = d13;
                        d3 = d16;
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                }
                bl3 = true;
            } else if (!bl4 && (d2 > 0.0 || d == 0.0 && d12 < 0.0) && (d4 > 0.0 || d3 == 0.0 && d12 > 0.0)) {
                d18 = Math.max(0.0, -d11 - this.m_C * this.m_data.instance(n).weight());
                if (d18 < (d17 = Math.min(this.m_C * this.m_data.instance(n2).weight(), -d11))) {
                    if (d10 > 0.0) {
                        d16 = d4 + d12 / d10;
                        if (d16 > d17) {
                            d16 = d17;
                        } else if (d16 < d18) {
                            d16 = d18;
                        }
                    } else {
                        d15 = d18 * d12;
                        d14 = d17 * d12;
                        d16 = d15 > d14 ? d18 : d17;
                    }
                    d13 = d2 - (d16 - d4);
                    if (Math.abs(d13 - d2) > this.m_eps || Math.abs(d16 - d4) > this.m_eps) {
                        d2 = d13;
                        d4 = d16;
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                }
                bl4 = true;
            } else {
                bl5 = true;
            }
            d12 += d10 * (d3 - d4 - (this.m_alpha[n2] - this.m_alpha_[n2]));
        }
        if (bl6) {
            int n3 = this.m_I0.getNext(-1);
            while (n3 != -1) {
                if (n3 != n && n3 != n2) {
                    int n4 = n3;
                    this.m_fcache[n4] = this.m_fcache[n4] + ((this.m_alpha[n] - this.m_alpha_[n] - (d - d2)) * this.m_kernel.eval(n, n3, this.m_data.instance(n)) + (this.m_alpha[n2] - this.m_alpha_[n2] - (d3 - d4)) * this.m_kernel.eval(n2, n3, this.m_data.instance(n2)));
                }
                n3 = this.m_I0.getNext(n3);
            }
            int n5 = n;
            this.m_fcache[n5] = this.m_fcache[n5] + ((this.m_alpha[n] - this.m_alpha_[n] - (d - d2)) * d7 + (this.m_alpha[n2] - this.m_alpha_[n2] - (d3 - d4)) * d8);
            int n6 = n2;
            this.m_fcache[n6] = this.m_fcache[n6] + ((this.m_alpha[n] - this.m_alpha_[n] - (d - d2)) * d8 + (this.m_alpha[n2] - this.m_alpha_[n2] - (d3 - d4)) * d9);
            if (d > this.m_C * this.m_data.instance(n).weight() - m_Del * this.m_C * this.m_data.instance(n).weight()) {
                d = this.m_C * this.m_data.instance(n).weight();
            } else if (d <= m_Del * this.m_C * this.m_data.instance(n).weight()) {
                d = 0.0;
            }
            if (d2 > this.m_C * this.m_data.instance(n).weight() - m_Del * this.m_C * this.m_data.instance(n).weight()) {
                d2 = this.m_C * this.m_data.instance(n).weight();
            } else if (d2 <= m_Del * this.m_C * this.m_data.instance(n).weight()) {
                d2 = 0.0;
            }
            if (d3 > this.m_C * this.m_data.instance(n2).weight() - m_Del * this.m_C * this.m_data.instance(n2).weight()) {
                d3 = this.m_C * this.m_data.instance(n2).weight();
            } else if (d3 <= m_Del * this.m_C * this.m_data.instance(n2).weight()) {
                d3 = 0.0;
            }
            if (d4 > this.m_C * this.m_data.instance(n2).weight() - m_Del * this.m_C * this.m_data.instance(n2).weight()) {
                d4 = this.m_C * this.m_data.instance(n2).weight();
            } else if (d4 <= m_Del * this.m_C * this.m_data.instance(n2).weight()) {
                d4 = 0.0;
            }
            this.m_alpha[n] = d;
            this.m_alpha_[n] = d2;
            this.m_alpha[n2] = d3;
            this.m_alpha_[n2] = d4;
            if (0.0 < d && d < this.m_C * this.m_data.instance(n).weight() || 0.0 < d2 && d2 < this.m_C * this.m_data.instance(n).weight()) {
                this.m_I0.insert(n);
            } else {
                this.m_I0.delete(n);
            }
            if (d == 0.0 && d2 == 0.0) {
                this.m_I1.insert(n);
            } else {
                this.m_I1.delete(n);
            }
            if (d == 0.0 && d2 == this.m_C * this.m_data.instance(n).weight()) {
                this.m_I2.insert(n);
            } else {
                this.m_I2.delete(n);
            }
            if (d == this.m_C * this.m_data.instance(n).weight() && d2 == 0.0) {
                this.m_I3.insert(n);
            } else {
                this.m_I3.delete(n);
            }
            if (0.0 < d3 && d3 < this.m_C * this.m_data.instance(n2).weight() || 0.0 < d4 && d4 < this.m_C * this.m_data.instance(n2).weight()) {
                this.m_I0.insert(n2);
            } else {
                this.m_I0.delete(n2);
            }
            if (d3 == 0.0 && d4 == 0.0) {
                this.m_I1.insert(n2);
            } else {
                this.m_I1.delete(n2);
            }
            if (d3 == 0.0 && d4 == this.m_C * this.m_data.instance(n2).weight()) {
                this.m_I2.insert(n2);
            } else {
                this.m_I2.delete(n2);
            }
            if (d3 == this.m_C * this.m_data.instance(n2).weight() && d4 == 0.0) {
                this.m_I3.insert(n2);
            } else {
                this.m_I3.delete(n2);
            }
            this.m_bLow = -1.7976931348623157E308;
            this.m_bUp = Double.MAX_VALUE;
            this.m_iLow = -1;
            this.m_iUp = -1;
            n3 = this.m_I0.getNext(-1);
            while (n3 != -1) {
                if (0.0 < this.m_alpha_[n3] && this.m_alpha_[n3] < this.m_C * this.m_data.instance(n3).weight() && this.m_fcache[n3] + this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[n3] + this.m_epsilon;
                    this.m_iLow = n3;
                } else if (0.0 < this.m_alpha[n3] && this.m_alpha[n3] < this.m_C * this.m_data.instance(n3).weight() && this.m_fcache[n3] - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[n3] - this.m_epsilon;
                    this.m_iLow = n3;
                }
                if (0.0 < this.m_alpha[n3] && this.m_alpha[n3] < this.m_C * this.m_data.instance(n3).weight() && this.m_fcache[n3] - this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[n3] - this.m_epsilon;
                    this.m_iUp = n3;
                } else if (0.0 < this.m_alpha_[n3] && this.m_alpha_[n3] < this.m_C * this.m_data.instance(n3).weight() && this.m_fcache[n3] + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[n3] + this.m_epsilon;
                    this.m_iUp = n3;
                }
                n3 = this.m_I0.getNext(n3);
            }
            if (!this.m_I0.contains(n)) {
                if (this.m_I2.contains(n) && this.m_fcache[n] + this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[n] + this.m_epsilon;
                    this.m_iLow = n;
                } else if (this.m_I1.contains(n) && this.m_fcache[n] - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[n] - this.m_epsilon;
                    this.m_iLow = n;
                }
                if (this.m_I3.contains(n) && this.m_fcache[n] - this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[n] - this.m_epsilon;
                    this.m_iUp = n;
                } else if (this.m_I1.contains(n) && this.m_fcache[n] + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[n] + this.m_epsilon;
                    this.m_iUp = n;
                }
            }
            if (!this.m_I0.contains(n2)) {
                if (this.m_I2.contains(n2) && this.m_fcache[n2] + this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[n2] + this.m_epsilon;
                    this.m_iLow = n2;
                } else if (this.m_I1.contains(n2) && this.m_fcache[n2] - this.m_epsilon > this.m_bLow) {
                    this.m_bLow = this.m_fcache[n2] - this.m_epsilon;
                    this.m_iLow = n2;
                }
                if (this.m_I3.contains(n2) && this.m_fcache[n2] - this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[n2] - this.m_epsilon;
                    this.m_iUp = n2;
                } else if (this.m_I1.contains(n2) && this.m_fcache[n2] + this.m_epsilon < this.m_bUp) {
                    this.m_bUp = this.m_fcache[n2] + this.m_epsilon;
                    this.m_iUp = n2;
                }
            }
            if (this.m_iLow == -1 || this.m_iUp == -1) {
                throw new RuntimeException(LocalString.get("Fatal error! The program failled to ") + LocalString.get("initialize i_Low, iUp."));
            }
            return true;
        }
        return false;
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        double d = this.m_b;
        if (!this.m_useRBF && this.m_exponent == 1.0) {
            if (this.m_sparseWeights == null) {
                int n = instance.numValues();
                for (int i = 0; i < n; ++i) {
                    if (instance.index(i) == this.m_classIndex) continue;
                    d += this.m_weights[instance.index(i)] * instance.valueSparse(i);
                }
            } else {
                int n = instance.numValues();
                int n2 = this.m_sparseWeights.length;
                int n3 = 0;
                int n4 = 0;
                while (n3 < n && n4 < n2) {
                    int n5;
                    int n6 = instance.index(n3);
                    if (n6 == (n5 = this.m_sparseIndices[n4])) {
                        if (n6 != this.m_classIndex) {
                            d += instance.valueSparse(n3) * this.m_sparseWeights[n4];
                        }
                        ++n3;
                        ++n4;
                        continue;
                    }
                    if (n6 > n5) {
                        ++n4;
                        continue;
                    }
                    ++n3;
                }
            }
        } else {
            for (int i = 0; i < this.m_alpha.length; ++i) {
                d += (this.m_alpha[i] - this.m_alpha_[i]) * this.m_kernel.eval(-1, i, instance);
            }
        }
        return (d - this.m_Blin) / this.m_Alin;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(11);
        vector.addElement(new Option(LocalString.get("\tThe amount up to which deviations are\n") + LocalString.get("\ttolerated (epsilon). (default 1e-3)"), "S", 1, LocalString.get("-S <double>")));
        vector.addElement(new Option(LocalString.get("\tThe complexity constant C. (default 1)"), "C", 1, LocalString.get("-C <double>")));
        vector.addElement(new Option(LocalString.get("\tThe exponent for the ") + LocalString.get("polynomial kernel. (default 1)"), "E", 1, LocalString.get("-E <double>")));
        vector.addElement(new Option(LocalString.get("\tGamma for the ") + LocalString.get("RBF kernel. (default 0.01)"), "G", 1, LocalString.get("-G <double>")));
        vector.addElement(new Option(LocalString.get("\tWhether to 0=normalize/1=standardize/2=neither. ") + LocalString.get("(default 0=normalize)"), "N", 1, "-N"));
        vector.addElement(new Option(LocalString.get("\tFeature-space normalization (only for\n") + LocalString.get("\tnon-linear polynomial kernels)."), "F", 0, "-F"));
        vector.addElement(new Option(LocalString.get("\tUse lower-order terms (only for non-linear\n") + LocalString.get("\tpolynomial kernels)."), "O", 0, "-O"));
        vector.addElement(new Option(LocalString.get("\tUse RBF kernel. ") + LocalString.get("(default poly)"), "R", 0, "-R"));
        vector.addElement(new Option(LocalString.get("\tThe size of the kernel cache. ") + LocalString.get("(default 250007, use 0 for full cache)"), "A", 1, LocalString.get("-A <int>")));
        vector.addElement(new Option(LocalString.get("\tThe tolerance parameter. ") + LocalString.get("(default 1.0e-3)"), "T", 1, LocalString.get("-T <double>")));
        vector.addElement(new Option(LocalString.get("\tThe epsilon for round-off error. ") + LocalString.get("(default 1.0e-12)"), "P", 1, LocalString.get("-P <double>")));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        this.m_epsilon = string.length() != 0 ? new Double(string) : 0.001;
        String string2 = Utils.getOption('C', stringArray);
        this.m_C = string2.length() != 0 ? new Double(string2) : 1.0;
        String string3 = Utils.getOption('E', stringArray);
        this.m_exponent = string3.length() != 0 ? new Double(string3) : 1.0;
        String string4 = Utils.getOption('G', stringArray);
        this.m_gamma = string4.length() != 0 ? new Double(string4) : 0.01;
        String string5 = Utils.getOption('A', stringArray);
        this.m_cacheSize = string5.length() != 0 ? Integer.parseInt(string5) : 250007;
        String string6 = Utils.getOption('T', stringArray);
        this.m_tol = string6.length() != 0 ? new Double(string6) : 0.001;
        String string7 = Utils.getOption('P', stringArray);
        this.m_eps = string7.length() != 0 ? new Double(string7) : 1.0E-12;
        this.m_useRBF = Utils.getFlag('R', stringArray);
        String string8 = Utils.getOption('N', stringArray);
        if (string8.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string8), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.m_featureSpaceNormalization = Utils.getFlag('F', stringArray);
        if (this.m_useRBF && this.m_featureSpaceNormalization) {
            throw new Exception(LocalString.get("RBF machine doesn't require feature-space normalization."));
        }
        if (this.m_exponent == 1.0 && this.m_featureSpaceNormalization) {
            throw new Exception(LocalString.get("Can't use feature-space normalization with linear machine."));
        }
        this.m_lowerOrder = Utils.getFlag('O', stringArray);
        if (this.m_useRBF && this.m_lowerOrder) {
            throw new Exception(LocalString.get("Can't use lower-order terms with RBF machine."));
        }
        if (this.m_exponent == 1.0 && this.m_lowerOrder) {
            throw new Exception(LocalString.get("Can't use lower-order terms with linear machine."));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[20];
        int n = 0;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_epsilon;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.m_C;
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.m_exponent;
        stringArray[n++] = "-G";
        stringArray[n++] = "" + this.m_gamma;
        stringArray[n++] = "-A";
        stringArray[n++] = "" + this.m_cacheSize;
        stringArray[n++] = "-T";
        stringArray[n++] = "" + this.m_tol;
        stringArray[n++] = "-P";
        stringArray[n++] = "" + this.m_eps;
        stringArray[n++] = "-N";
        stringArray[n++] = "" + this.m_filterType;
        if (this.m_featureSpaceNormalization) {
            stringArray[n++] = "-F";
        }
        if (this.m_lowerOrder) {
            stringArray[n++] = "-O";
        }
        if (this.m_useRBF) {
            stringArray[n++] = "-R";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String filterTypeTipText() {
        return LocalString.get("Determines how/if the data will be transformed.");
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String exponentTipText() {
        return LocalString.get("The exponent for the polynomial kernel.");
    }

    public double getExponent() {
        return this.m_exponent;
    }

    public void setExponent(double d) {
        if (d == 1.0) {
            this.m_featureSpaceNormalization = false;
            this.m_lowerOrder = false;
        }
        this.m_exponent = d;
    }

    public String gammaTipText() {
        return LocalString.get("The value of the gamma parameter for RBF kernels.");
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public void setGamma(double d) {
        this.m_gamma = d;
    }

    public String cTipText() {
        return LocalString.get("The complexity parameter C.");
    }

    public double getC() {
        return this.m_C;
    }

    public void setC(double d) {
        this.m_C = d;
    }

    public String toleranceParameterTipText() {
        return LocalString.get("The tolerance parameter (shouldn't be changed).");
    }

    public double getToleranceParameter() {
        return this.m_tol;
    }

    public void setToleranceParameter(double d) {
        this.m_tol = d;
    }

    public String epsTipText() {
        return LocalString.get("The epsilon for round-off error (shouldn't be changed).");
    }

    public double getEps() {
        return this.m_eps;
    }

    public void setEps(double d) {
        this.m_eps = d;
    }

    public String epsilonTipText() {
        return LocalString.get("The amount up to which deviations are tolerated. ") + LocalString.get("Watch out, the value of epsilon is used with the (normalized/standardized) ") + LocalString.get("data.");
    }

    public double getEpsilon() {
        return this.m_epsilon;
    }

    public void setEpsilon(double d) {
        this.m_epsilon = d;
    }

    public String cacheSizeTipText() {
        return LocalString.get("The size of the kernel cache (should be a prime number).");
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public void setCacheSize(int n) {
        this.m_cacheSize = n;
    }

    public String useRBFTipText() {
        return LocalString.get("Whether to use an RBF kernel instead of a polynomial one.");
    }

    public boolean getUseRBF() {
        return this.m_useRBF;
    }

    public void setUseRBF(boolean bl) {
        if (bl) {
            this.m_featureSpaceNormalization = false;
            this.m_lowerOrder = false;
        }
        this.m_useRBF = bl;
    }

    public String featureSpaceNormalizationTipText() {
        return LocalString.get("Whether feature-space normalization is performed (only ") + LocalString.get("available for non-linear polynomial kernels).");
    }

    public boolean getFeatureSpaceNormalization() throws Exception {
        return this.m_featureSpaceNormalization;
    }

    public void setFeatureSpaceNormalization(boolean bl) throws Exception {
        this.m_featureSpaceNormalization = this.m_useRBF || this.m_exponent == 1.0 ? false : bl;
    }

    public String lowerOrderTermsTipText() {
        return LocalString.get("Whether lower order polyomials are also used (only ") + LocalString.get("available for non-linear polynomial kernels).");
    }

    public boolean getLowerOrderTerms() {
        return this.m_lowerOrder;
    }

    public void setLowerOrderTerms(boolean bl) {
        this.m_lowerOrder = this.m_exponent == 1.0 || this.m_useRBF ? false : bl;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.m_alpha == null && this.m_sparseWeights == null) {
            return LocalString.get("SMOreg : No model built yet.");
        }
        try {
            int n2;
            stringBuffer.append(LocalString.get("SMOreg\n\n"));
            stringBuffer.append(LocalString.get("Kernel used : \n"));
            if (this.m_useRBF) {
                stringBuffer.append(LocalString.get("  RBF kernel : K(x,y) = e^-(") + this.m_gamma + LocalString.get("* <x-y,x-y>^2)"));
            } else if (this.m_exponent == 1.0) {
                stringBuffer.append(LocalString.get("  Linear Kernel : K(x,y) = <x,y>"));
            } else if (this.m_featureSpaceNormalization) {
                if (this.m_lowerOrder) {
                    stringBuffer.append(LocalString.get("  Normalized Poly Kernel with lower order : K(x,y) = (<x,y>+1)^") + this.m_exponent + "/" + LocalString.get("((<x,x>+1)^") + this.m_exponent + "*" + LocalString.get("(<y,y>+1)^") + this.m_exponent + ")^(1/2)");
                } else {
                    stringBuffer.append(LocalString.get("  Normalized Poly Kernel : K(x,y) = <x,y>^") + this.m_exponent + "/" + "(<x,x>^" + this.m_exponent + "*" + "<y,y>^" + this.m_exponent + ")^(1/2)");
                }
            } else if (this.m_lowerOrder) {
                stringBuffer.append(LocalString.get("  Poly Kernel with lower order : K(x,y) = (<x,y> + 1)^") + this.m_exponent);
            } else {
                stringBuffer.append(LocalString.get("  Poly Kernel : K(x,y) = <x,y>^") + this.m_exponent);
            }
            stringBuffer.append("\n\n");
            String string = "";
            if (this.m_filterType == 1) {
                string = LocalString.get("(standardized) ");
            } else if (this.m_filterType == 0) {
                string = LocalString.get("(normalized) ");
            }
            if (!this.m_useRBF && this.m_exponent == 1.0) {
                stringBuffer.append(LocalString.get("Machine Linear: showing attribute weights, "));
                stringBuffer.append(LocalString.get("not support vectors.\n"));
                stringBuffer.append(string + this.m_data.classAttribute().name() + " =\n");
                for (n2 = 0; n2 < this.m_sparseWeights.length; ++n2) {
                    if (this.m_sparseIndices[n2] == this.m_classIndex) continue;
                    if (n > 0) {
                        stringBuffer.append(" + ");
                    } else {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append(Utils.doubleToString(this.m_sparseWeights[n2], 12, 4) + " * ");
                    if (this.m_filterType == 1) {
                        stringBuffer.append(LocalString.get("(standardized) "));
                    } else if (this.m_filterType == 0) {
                        stringBuffer.append(LocalString.get("(normalized) "));
                    }
                    if (!this.m_checksTurnedOff) {
                        stringBuffer.append(this.m_data.attribute(this.m_sparseIndices[n2]).name() + "\n");
                    } else {
                        stringBuffer.append(LocalString.get("attribute with index ") + this.m_sparseIndices[n2] + "\n");
                    }
                    ++n;
                }
            } else {
                stringBuffer.append(LocalString.get("Support Vector Expansion :\n"));
                stringBuffer.append(string + this.m_data.classAttribute().name() + " =\n");
                n = 0;
                for (n2 = 0; n2 < this.m_alpha.length; ++n2) {
                    double d = this.m_alpha[n2] - this.m_alpha_[n2];
                    if (Math.abs(d) < 1.0E-4) continue;
                    if (n > 0) {
                        stringBuffer.append(" + ");
                    } else {
                        stringBuffer.append("   ");
                    }
                    stringBuffer.append(Utils.doubleToString(d, 12, 4) + " * K[X(" + n2 + "), X]\n");
                    ++n;
                }
            }
            if (this.m_b > 0.0) {
                stringBuffer.append(" + " + Utils.doubleToString(this.m_b, 12, 4));
            } else {
                stringBuffer.append(" - " + Utils.doubleToString(-this.m_b, 12, 4));
            }
            if (this.m_useRBF || this.m_exponent != 1.0) {
                stringBuffer.append(LocalString.get("\n\nNumber of support vectors: ") + n);
            }
            n2 = 0;
            int n3 = -1;
            if (this.m_kernel != null) {
                n2 = this.m_kernel.numEvals();
                n3 = this.m_kernel.numCacheHits();
            }
            stringBuffer.append(LocalString.get("\n\nNumber of kernel evaluations: ") + n2);
            if (n3 >= 0 && n2 > 0) {
                double d = 1 - n2 / (n3 + n2);
                stringBuffer.append(" (" + Utils.doubleToString(d * 100.0, 7, 3) + LocalString.get("% cached)"));
            }
        }
        catch (Exception exception) {
            return LocalString.get("Can't print the classifier.");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            SMOreg sMOreg = new SMOreg();
            System.out.println(Evaluation.evaluateModel(sMOreg, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    protected double objFun() throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.m_alpha.length; ++i) {
            for (int j = 0; j < this.m_alpha.length; ++j) {
                d2 += (this.m_alpha[i] - this.m_alpha_[i]) * (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            d3 += this.m_data.instance(i).classValue() * (this.m_alpha[i] - this.m_alpha_[i]) - this.m_epsilon * (this.m_alpha[i] + this.m_alpha_[i]);
        }
        return d += -0.5 * d2 + d3;
    }

    protected double objFun(int n, int n2, double d, double d2, double d3, double d4) throws Exception {
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < this.m_alpha.length; ++i) {
            double d8;
            double d9;
            if (i == n) {
                d9 = d;
                d8 = d2;
            } else if (i == n2) {
                d9 = d3;
                d8 = d4;
            } else {
                d9 = this.m_alpha[i];
                d8 = this.m_alpha_[i];
            }
            for (int j = 0; j < this.m_alpha.length; ++j) {
                double d10;
                double d11;
                if (j == n) {
                    d11 = d;
                    d10 = d2;
                } else if (j == n2) {
                    d11 = d3;
                    d10 = d4;
                } else {
                    d11 = this.m_alpha[j];
                    d10 = this.m_alpha_[j];
                }
                d6 += (d9 - d8) * (d11 - d10) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            d7 += this.m_data.instance(i).classValue() * (d9 - d8) - this.m_epsilon * (d9 + d8);
        }
        return d5 += -0.5 * d6 + d7;
    }

    protected void checkSets() throws Exception {
        boolean[] blArray = new boolean[this.m_data.numInstances()];
        int n = this.m_I0.getNext(-1);
        while (n != -1) {
            if (blArray[n]) {
                throw new Exception(LocalString.get("Fatal error! indice ") + n + LocalString.get(" appears in two different sets."));
            }
            blArray[n] = true;
            if (!(0.0 < this.m_alpha[n] && this.m_alpha[n] < this.m_C * this.m_data.instance(n).weight() || 0.0 < this.m_alpha_[n] && this.m_alpha_[n] < this.m_C * this.m_data.instance(n).weight())) {
                throw new Exception(LocalString.get("Warning! I0 contains an incorrect indice."));
            }
            n = this.m_I0.getNext(n);
        }
        n = this.m_I1.getNext(-1);
        while (n != -1) {
            if (blArray[n]) {
                throw new Exception(LocalString.get("Fatal error! indice ") + n + LocalString.get(" appears in two different sets."));
            }
            blArray[n] = true;
            if (this.m_alpha[n] != 0.0 || this.m_alpha_[n] != 0.0) {
                throw new Exception(LocalString.get("Fatal error! I1 contains an incorrect indice."));
            }
            n = this.m_I1.getNext(n);
        }
        n = this.m_I2.getNext(-1);
        while (n != -1) {
            if (blArray[n]) {
                throw new Exception(LocalString.get("Fatal error! indice ") + n + LocalString.get(" appears in two different sets."));
            }
            blArray[n] = true;
            if (this.m_alpha[n] != 0.0 || this.m_alpha_[n] != this.m_C * this.m_data.instance(n).weight()) {
                throw new Exception(LocalString.get("Fatal error! I2 contains an incorrect indice."));
            }
            n = this.m_I2.getNext(n);
        }
        n = this.m_I3.getNext(-1);
        while (n != -1) {
            if (blArray[n]) {
                throw new Exception(LocalString.get("Fatal error! indice ") + n + LocalString.get(" appears in two different sets."));
            }
            blArray[n] = true;
            if (this.m_alpha_[n] != 0.0 || this.m_alpha[n] != this.m_C * this.m_data.instance(n).weight()) {
                throw new Exception(LocalString.get("Fatal error! I3 contains an incorrect indice."));
            }
            n = this.m_I3.getNext(n);
        }
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            throw new Exception(LocalString.get("Fatal error! indice ") + n + LocalString.get(" doesn't belong to any set."));
        }
    }

    protected void checkAlphas() throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.m_alpha.length; ++i) {
            if (0.0 != this.m_alpha[i] && this.m_alpha_[i] != 0.0) {
                throw new Exception(LocalString.get("Fatal error! Inconsistent alphas!"));
            }
            d += this.m_alpha[i] - this.m_alpha_[i];
        }
        if (d > 1.0E-10) {
            throw new Exception(LocalString.get("Fatal error! Inconsistent alphas' sum = ") + d);
        }
    }

    protected void displayStat(int n, int n2) throws Exception {
        System.err.println(LocalString.get("\n-------- Status : ---------"));
        System.err.println(LocalString.get("\n i, alpha, alpha'\n"));
        for (int i = 0; i < this.m_alpha.length; ++i) {
            double d = (this.m_bLow + this.m_bUp) / 2.0;
            for (int j = 0; j < this.m_alpha.length; ++j) {
                d += (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            System.err.print(" " + i + ":  (" + this.m_alpha[i] + ", " + this.m_alpha_[i] + "),       " + (this.m_data.instance(i).classValue() - this.m_epsilon) + " <= " + d + " <= " + (this.m_data.instance(i).classValue() + this.m_epsilon));
            if (i == n) {
                System.err.print(" <-- i1");
            }
            if (i == n2) {
                System.err.print(" <-- i2");
            }
            System.err.println();
        }
        System.err.println(LocalString.get("bLow = ") + this.m_bLow + LocalString.get("  bUp = ") + this.m_bUp);
        System.err.println("---------------------------\n");
    }

    protected void displayB() throws Exception {
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            double d = this.m_data.instance(i).classValue();
            for (int j = 0; j < this.m_alpha.length; ++j) {
                d -= (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            System.err.print("(" + this.m_alpha[i] + ", " + this.m_alpha_[i] + ") : ");
            System.err.print(d - this.m_epsilon + ",  " + (d + this.m_epsilon));
            double d2 = d - this.m_epsilon;
            double d3 = d + this.m_epsilon;
            String string = "";
            if (this.m_I0.contains(i)) {
                if (0.0 < this.m_alpha[i] && this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight()) {
                    string = string + LocalString.get("(in I0a) bUp = min(bUp, ") + d2 + LocalString.get(")   bLow = max(bLow, ") + d2 + ")";
                }
                if (0.0 < this.m_alpha_[i] && this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight()) {
                    string = string + LocalString.get("(in I0a) bUp = min(bUp, ") + d3 + LocalString.get(")   bLow = max(bLow, ") + d3 + ")";
                }
            }
            if (this.m_I1.contains(i)) {
                string = string + LocalString.get("(in I1) bUp = min(bUp, ") + d3 + LocalString.get(")   bLow = max(bLow, ") + d2 + ")";
            }
            if (this.m_I2.contains(i)) {
                string = string + LocalString.get("(in I2) bLow = max(bLow, ") + d3 + ")";
            }
            if (this.m_I3.contains(i)) {
                string = string + LocalString.get("(in I3) bUp = min(bUp, ") + d2 + ")";
            }
            System.err.println(" " + string + " {" + (this.m_alpha[i] - 1.0) + ", " + (this.m_alpha_[i] - 1.0) + "}");
        }
        System.err.println("\n\n");
    }

    protected void checkOptimality() throws Exception {
        int n;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < this.m_data.numInstances(); ++n) {
            double d3 = this.m_data.instance(n).classValue();
            for (int i = 0; i < this.m_alpha.length; ++i) {
                d3 -= (this.m_alpha[i] - this.m_alpha_[i]) * this.m_kernel.eval(n, i, this.m_data.instance(n));
            }
            double d4 = 0.0;
            double d5 = 0.0;
            if (this.m_I0.contains(n) && 0.0 < this.m_alpha[n] && this.m_alpha[n] < this.m_C * this.m_data.instance(n).weight()) {
                d4 = d3 - this.m_epsilon;
                d5 = d3 - this.m_epsilon;
            }
            if (this.m_I0.contains(n) && 0.0 < this.m_alpha_[n] && this.m_alpha_[n] < this.m_C * this.m_data.instance(n).weight()) {
                d4 = d3 + this.m_epsilon;
                d5 = d3 + this.m_epsilon;
            }
            if (this.m_I1.contains(n)) {
                d4 = d3 - this.m_epsilon;
                d5 = d3 + this.m_epsilon;
            }
            if (this.m_I2.contains(n)) {
                d4 = d3 + this.m_epsilon;
                d5 = Double.POSITIVE_INFINITY;
            }
            if (this.m_I3.contains(n)) {
                d4 = Double.NEGATIVE_INFINITY;
                d5 = d3 - this.m_epsilon;
            }
            if (d5 < d) {
                d = d5;
                n2 = n;
            }
            if (!(d4 > d2)) continue;
            d2 = d4;
            n3 = n;
        }
        if (!(d2 <= d + 2.0 * this.m_tol)) {
            System.err.println(LocalString.get("Warning! Optimality not reached : inequation (6) doesn't hold!"));
        }
        n = 1;
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            double d6 = this.m_data.instance(i).classValue();
            for (int j = 0; j < this.m_alpha.length; ++j) {
                d6 -= (this.m_alpha[j] - this.m_alpha_[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            double d7 = d6 - (this.m_bUp + this.m_bLow) / 2.0;
            if (this.m_alpha[i] > 0.0 && !(d7 >= this.m_epsilon - this.m_tol)) {
                System.err.println(LocalString.get("Warning! Optimality not reached : inequation (8a) doesn't hold for ") + i);
                n = 0;
            }
            if (this.m_alpha[i] < this.m_C * this.m_data.instance(i).weight() && !(d7 <= this.m_epsilon + this.m_tol)) {
                System.err.println(LocalString.get("Warning! Optimality not reached : inequation (8b) doesn't hold for ") + i);
                n = 0;
            }
            if (this.m_alpha_[i] > 0.0 && !(d7 <= -this.m_epsilon + this.m_tol)) {
                System.err.println(LocalString.get("Warning! Optimality not reached : inequation (8c) doesn't hold for ") + i);
                n = 0;
            }
            if (!(this.m_alpha_[i] < this.m_C * this.m_data.instance(i).weight()) || d7 >= -this.m_epsilon - this.m_tol) continue;
            System.err.println(LocalString.get("Warning! Optimality not reached : inequation (8d) doesn't hold for ") + i);
            n = 0;
        }
        if (n == 0) {
            System.err.println();
        }
    }
}

