/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.UpdateableClassifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class AODE
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
UpdateableClassifier {
    private double[][][] m_CondiCounts;
    private double[] m_ClassCounts;
    private double[][] m_SumForCounts;
    private int m_NumClasses;
    private int m_NumAttributes;
    private int m_NumInstances;
    private int m_ClassIndex;
    private Instances m_Instances;
    private int m_TotalAttValues;
    private int[] m_StartAttIndex;
    private int[] m_NumAttValues;
    private double[] m_Frequencies;
    private double m_SumInstances;
    private int m_Limit;
    private boolean m_Debug = false;

    public String globalInfo() {
        return LocalString.get("AODE achieves highly accurate classification by averaging over all ") + LocalString.get("of a small space of alternative naive-Bayes-like models that have ") + LocalString.get("weaker (and hence less detrimental) independence assumptions than ") + LocalString.get("naive Bayes. The resulting algorithm is computationally efficient while ") + LocalString.get("delivering highly accurate classification on many learning tasks.\n\n") + LocalString.get("For more information, see\n\n") + LocalString.get("G. Webb, J. Boughton & Z. Wang (2004). Not So Naive Bayes. ") + LocalString.get("To be published in Machine Learning. ") + LocalString.get("G. Webb, J. Boughton & Z. Wang (2002). <i>Averaged One-Dependence ") + LocalString.get("Estimators: Preliminary Results. AI2002 Data Mining Workshop, Canberra.");
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.m_SumInstances = 0.0;
        this.m_NumClasses = instances.numClasses();
        if (instances.classAttribute().isNumeric()) {
            throw new Exception(LocalString.get("AODE: Class is numeric!"));
        }
        if (this.m_NumClasses < 2) {
            throw new Exception(LocalString.get("Dataset has no class attribute"));
        }
        if (instances.checkForStringAttributes()) {
            throw new Exception(LocalString.get("AODE: String attributes are not allowed."));
        }
        this.m_ClassIndex = instances.classIndex();
        this.m_NumAttributes = instances.numAttributes();
        for (n = 0; n < this.m_NumAttributes; ++n) {
            Attribute attribute = instances.attribute(n);
            if (attribute.isNominal()) continue;
            throw new Exception(LocalString.get("Attributes must be nominal.  ") + LocalString.get("Discretize dataset with FilteredClassifer."));
        }
        this.m_Instances = instances;
        this.m_NumInstances = this.m_Instances.numInstances();
        this.m_StartAttIndex = new int[this.m_NumAttributes];
        this.m_NumAttValues = new int[this.m_NumAttributes];
        this.m_TotalAttValues = 0;
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (n != this.m_ClassIndex) {
                this.m_StartAttIndex[n] = this.m_TotalAttValues;
                this.m_NumAttValues[n] = this.m_Instances.attribute(n).numValues();
                this.m_TotalAttValues += this.m_NumAttValues[n] + 1;
                continue;
            }
            this.m_NumAttValues[n] = this.m_NumClasses;
        }
        this.m_CondiCounts = new double[this.m_NumClasses][this.m_TotalAttValues][this.m_TotalAttValues];
        this.m_ClassCounts = new double[this.m_NumClasses];
        this.m_SumForCounts = new double[this.m_NumClasses][this.m_NumAttributes];
        this.m_Frequencies = new double[this.m_TotalAttValues];
        for (n = 0; n < this.m_NumInstances; ++n) {
            this.addToCounts(this.m_Instances.instance(n));
        }
        this.m_Instances = new Instances(this.m_Instances, 0);
    }

    public void updateClassifier(Instance instance) {
        this.addToCounts(instance);
    }

    private void addToCounts(Instance instance) {
        int n;
        if (instance.classIsMissing()) {
            return;
        }
        int n2 = (int)instance.classValue();
        int n3 = (int)instance.weight();
        int n4 = n2;
        this.m_ClassCounts[n4] = this.m_ClassCounts[n4] + (double)n3;
        this.m_SumInstances += (double)n3;
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = n == this.m_ClassIndex ? -1 : (instance.isMissing(n) ? this.m_StartAttIndex[n] + this.m_NumAttValues[n] : this.m_StartAttIndex[n] + (int)instance.value(n));
        }
        for (n = 0; n < this.m_NumAttributes; ++n) {
            if (nArray[n] == -1) continue;
            int n5 = nArray[n];
            this.m_Frequencies[n5] = this.m_Frequencies[n5] + (double)n3;
            if (!instance.isMissing(n)) {
                double[] dArray = this.m_SumForCounts[n2];
                int n6 = n;
                dArray[n6] = dArray[n6] + (double)n3;
            }
            double[] dArray = this.m_CondiCounts[n2][nArray[n]];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (nArray[i] == -1) continue;
                int n7 = nArray[i];
                dArray[n7] = dArray[n7] + (double)n3;
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_NumClasses];
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = instance.isMissing(n) || n == this.m_ClassIndex ? -1 : this.m_StartAttIndex[n] + (int)instance.value(n);
        }
        for (n = 0; n < this.m_NumClasses; ++n) {
            dArray[n] = 0.0;
            double d = 0.0;
            int n2 = 0;
            double[][] dArray2 = this.m_CondiCounts[n];
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                int n3;
                if (nArray[i] == -1 || this.m_Frequencies[n3 = nArray[i]] < (double)this.m_Limit) continue;
                double[] dArray3 = dArray2[n3];
                nArray[i] = -1;
                ++n2;
                double d2 = dArray3[n3];
                double d3 = this.m_Frequencies[this.m_StartAttIndex[i] + this.m_NumAttValues[i]];
                d = (d2 + 1.0) / (this.m_SumInstances - d3 + (double)(this.m_NumClasses * this.m_NumAttValues[i]));
                for (int j = 0; j < this.m_NumAttributes; ++j) {
                    if (nArray[j] == -1) continue;
                    double d4 = dArray3[this.m_StartAttIndex[j] + this.m_NumAttValues[j]];
                    d *= (dArray3[nArray[j]] + 1.0) / (d2 - d4 + (double)this.m_NumAttValues[j]);
                }
                int n4 = n;
                dArray[n4] = dArray[n4] + d;
                nArray[i] = n3;
            }
            if (n2 < 1) {
                dArray[n] = this.NBconditionalProb(instance, n);
                continue;
            }
            int n5 = n;
            dArray[n5] = dArray[n5] / (double)n2;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public double NBconditionalProb(Instance instance, int n) {
        double d = (this.m_ClassCounts[n] + 1.0) / (this.m_SumInstances + (double)this.m_NumClasses);
        double[][] dArray = this.m_CondiCounts[n];
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (i == this.m_ClassIndex || instance.isMissing(i)) continue;
            int n2 = this.m_StartAttIndex[i] + (int)instance.value(i);
            d *= (dArray[n2][n2] + 1.0) / (this.m_SumForCounts[n][i] + (double)this.m_NumAttValues[i]);
        }
        return d;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tOutput debugging information\n"), "D", 0, "-D"));
        vector.addElement(new Option(LocalString.get("\tImpose a frequency limit for superParents\n") + LocalString.get("\t(default is 30)"), "F", 1, "-F"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_Debug = Utils.getFlag('D', stringArray);
        String string = Utils.getOption('F', stringArray);
        this.m_Limit = string.length() != 0 ? Integer.parseInt(string) : 30;
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (this.m_Debug) {
            stringArray[n++] = "-D";
        }
        stringArray[n++] = "-F ";
        stringArray[n++] = "" + this.m_Limit;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("The AODE Classifier"));
        if (this.m_Instances == null) {
            stringBuffer.append(LocalString.get(": No model built yet."));
        } else {
            try {
                for (int i = 0; i < this.m_NumClasses; ++i) {
                    stringBuffer.append(LocalString.get("\nClass ") + this.m_Instances.classAttribute().value(i) + LocalString.get(": Prior probability = ") + Utils.doubleToString((this.m_ClassCounts[i] + 1.0) / (this.m_SumInstances + (double)this.m_NumClasses), 4, 2) + "\n\n");
                }
                stringBuffer.append(LocalString.get("Dataset: ") + this.m_Instances.relationName() + "\n" + LocalString.get("Instances: ") + this.m_NumInstances + "\n" + LocalString.get("Attributes: ") + this.m_NumAttributes + "\n" + LocalString.get("Frequency limit for superParents: ") + this.m_Limit + "\n");
            }
            catch (Exception exception) {
                stringBuffer.append(exception.getMessage());
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new AODE(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

