/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.Color;
import weka.LocalString;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Add;

public class PlotData2D {
    protected Instances m_plotInstances = null;
    protected String m_plotName = LocalString.get("new plot");
    public boolean m_useCustomColour = false;
    public Color m_customColour = null;
    public boolean m_displayAllPoints = false;
    protected double[][] m_pointLookup;
    protected int[] m_shapeSize;
    protected int[] m_shapeType;
    protected boolean[] m_connectPoints;
    private int m_xIndex;
    private int m_yIndex;
    private int m_cIndex;
    protected double m_maxX;
    protected double m_minX;
    protected double m_maxY;
    protected double m_minY;
    protected double m_maxC;
    protected double m_minC;

    public PlotData2D(Instances instances) {
        this.m_plotInstances = instances;
        this.m_cIndex = 0;
        this.m_yIndex = 0;
        this.m_xIndex = 0;
        this.m_pointLookup = new double[this.m_plotInstances.numInstances()][4];
        this.m_shapeSize = new int[this.m_plotInstances.numInstances()];
        this.m_shapeType = new int[this.m_plotInstances.numInstances()];
        this.m_connectPoints = new boolean[this.m_plotInstances.numInstances()];
        for (int i = 0; i < this.m_plotInstances.numInstances(); ++i) {
            this.m_shapeSize[i] = 2;
            this.m_shapeType[i] = -1;
        }
        this.determineBounds();
    }

    public void addInstanceNumberAttribute() {
        String string = this.m_plotInstances.relationName();
        try {
            Add add = new Add();
            add.setAttributeName("Instance_number");
            add.setAttributeIndex("first");
            add.setInputFormat(this.m_plotInstances);
            this.m_plotInstances = Filter.useFilter(this.m_plotInstances, add);
            this.m_plotInstances.setClassIndex(this.m_plotInstances.numAttributes() - 1);
            for (int i = 0; i < this.m_plotInstances.numInstances(); ++i) {
                this.m_plotInstances.instance(i).setValue(0, (double)i);
            }
            this.m_plotInstances.setRelationName(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Instances getPlotInstances() {
        return new Instances(this.m_plotInstances);
    }

    public void setPlotName(String string) {
        this.m_plotName = string;
    }

    public String getPlotName() {
        return this.m_plotName;
    }

    public void setShapeType(int[] nArray) throws Exception {
        this.m_shapeType = nArray;
        if (this.m_shapeType.length != this.m_plotInstances.numInstances()) {
            throw new Exception(LocalString.get("PlotData2D: Shape type array must have the same ") + LocalString.get("number of entries as number of data points!"));
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.m_shapeType[i] != 1000) continue;
            this.m_shapeSize[i] = 3;
        }
    }

    public void setShapeType(FastVector fastVector) throws Exception {
        if (fastVector.size() != this.m_plotInstances.numInstances()) {
            throw new Exception(LocalString.get("PlotData2D: Shape type vector must have the same ") + LocalString.get("number of entries as number of data points!"));
        }
        this.m_shapeType = new int[fastVector.size()];
        for (int i = 0; i < fastVector.size(); ++i) {
            this.m_shapeType[i] = (Integer)fastVector.elementAt(i);
            if (this.m_shapeType[i] != 1000) continue;
            this.m_shapeSize[i] = 3;
        }
    }

    public void setShapeSize(int[] nArray) throws Exception {
        this.m_shapeSize = nArray;
        if (this.m_shapeType.length != this.m_plotInstances.numInstances()) {
            throw new Exception(LocalString.get("PlotData2D: Shape size array must have the same ") + LocalString.get("number of entries as number of data points!"));
        }
    }

    public void setShapeSize(FastVector fastVector) throws Exception {
        if (fastVector.size() != this.m_plotInstances.numInstances()) {
            throw new Exception(LocalString.get("PlotData2D: Shape size vector must have the same ") + LocalString.get("number of entries as number of data points!"));
        }
        this.m_shapeSize = new int[fastVector.size()];
        for (int i = 0; i < fastVector.size(); ++i) {
            this.m_shapeSize[i] = (Integer)fastVector.elementAt(i);
        }
    }

    public void setConnectPoints(boolean[] blArray) throws Exception {
        this.m_connectPoints = blArray;
        if (this.m_connectPoints.length != this.m_plotInstances.numInstances()) {
            throw new Exception(LocalString.get("PlotData2D: connect points array must have the ") + LocalString.get("same number of entries as number of data points!"));
        }
        this.m_connectPoints[0] = false;
    }

    public void setConnectPoints(FastVector fastVector) throws Exception {
        if (fastVector.size() != this.m_plotInstances.numInstances()) {
            throw new Exception(LocalString.get("PlotData2D: connect points array must have the ") + LocalString.get("same number of entries as number of data points!"));
        }
        this.m_shapeSize = new int[fastVector.size()];
        for (int i = 0; i < fastVector.size(); ++i) {
            this.m_connectPoints[i] = (Boolean)fastVector.elementAt(i);
        }
        this.m_connectPoints[0] = false;
    }

    public void setCustomColour(Color color) {
        this.m_customColour = color;
        this.m_useCustomColour = color != null;
    }

    public void setXindex(int n) {
        this.m_xIndex = n;
        this.determineBounds();
    }

    public void setYindex(int n) {
        this.m_yIndex = n;
        this.determineBounds();
    }

    public void setCindex(int n) {
        this.m_cIndex = n;
        this.determineBounds();
    }

    public int getXindex() {
        return this.m_xIndex;
    }

    public int getYindex() {
        return this.m_yIndex;
    }

    public int getCindex() {
        return this.m_cIndex;
    }

    private void determineBounds() {
        if (this.m_plotInstances != null && this.m_plotInstances.numAttributes() > 0 && this.m_plotInstances.numInstances() > 0) {
            double d;
            int n;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            if (this.m_plotInstances.attribute(this.m_xIndex).isNominal()) {
                this.m_minX = 0.0;
                this.m_maxX = this.m_plotInstances.attribute(this.m_xIndex).numValues() - 1;
            } else {
                for (n = 0; n < this.m_plotInstances.numInstances(); ++n) {
                    if (this.m_plotInstances.instance(n).isMissing(this.m_xIndex)) continue;
                    d = this.m_plotInstances.instance(n).value(this.m_xIndex);
                    if (d < d2) {
                        d2 = d;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                if (d2 == Double.POSITIVE_INFINITY) {
                    d3 = 0.0;
                    d2 = 0.0;
                }
                this.m_minX = d2;
                this.m_maxX = d3;
                if (d2 == d3) {
                    this.m_maxX += 0.05;
                    this.m_minX -= 0.05;
                }
            }
            d2 = Double.POSITIVE_INFINITY;
            d3 = Double.NEGATIVE_INFINITY;
            if (this.m_plotInstances.attribute(this.m_yIndex).isNominal()) {
                this.m_minY = 0.0;
                this.m_maxY = this.m_plotInstances.attribute(this.m_yIndex).numValues() - 1;
            } else {
                for (n = 0; n < this.m_plotInstances.numInstances(); ++n) {
                    if (this.m_plotInstances.instance(n).isMissing(this.m_yIndex)) continue;
                    d = this.m_plotInstances.instance(n).value(this.m_yIndex);
                    if (d < d2) {
                        d2 = d;
                    }
                    if (!(d > d3)) continue;
                    d3 = d;
                }
                if (d2 == Double.POSITIVE_INFINITY) {
                    d3 = 0.0;
                    d2 = 0.0;
                }
                this.m_minY = d2;
                this.m_maxY = d3;
                if (d2 == d3) {
                    this.m_maxY += 0.05;
                    this.m_minY -= 0.05;
                }
            }
            d2 = Double.POSITIVE_INFINITY;
            d3 = Double.NEGATIVE_INFINITY;
            for (n = 0; n < this.m_plotInstances.numInstances(); ++n) {
                if (this.m_plotInstances.instance(n).isMissing(this.m_cIndex)) continue;
                d = this.m_plotInstances.instance(n).value(this.m_cIndex);
                if (d < d2) {
                    d2 = d;
                }
                if (!(d > d3)) continue;
                d3 = d;
            }
            if (d2 == Double.POSITIVE_INFINITY) {
                d3 = 0.0;
                d2 = 0.0;
            }
            this.m_minC = d2;
            this.m_maxC = d3;
        }
    }
}

