/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.LocalString;
import weka.associations.Apriori;
import weka.associations.Associator;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogPanel;
import weka.gui.Logger;
import weka.gui.PropertyPanel;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.SelectedTagEditor;
import weka.gui.SysErrLog;
import weka.gui.TaskLogger;

public class AssociationsPanel
extends JPanel {
    protected GenericObjectEditor m_AssociatorEditor = new GenericObjectEditor();
    protected PropertyPanel m_CEPanel = new PropertyPanel(this.m_AssociatorEditor);
    protected JTextArea m_OutText = new JTextArea(20, 40);
    protected Logger m_Log = new SysErrLog();
    protected SaveBuffer m_SaveOut = new SaveBuffer(this.m_Log, this);
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JButton m_StartBut = new JButton("Start");
    protected JButton m_StopBut = new JButton("Stop");
    protected Instances m_Instances;
    protected Instances m_TestInstances;
    protected Thread m_RunThread;

    public AssociationsPanel() {
        this.m_OutText.setEditable(false);
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16) {
                    AssociationsPanel.this.m_OutText.selectAll();
                }
            }
        });
        this.m_History.setBorder(BorderFactory.createTitledBorder(LocalString.get("Result list (right-click for options)")));
        this.m_History.setHandleRightClicks(false);
        this.m_History.getList().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                    int n = AssociationsPanel.this.m_History.getList().locationToIndex(mouseEvent.getPoint());
                    if (n != -1) {
                        String string = AssociationsPanel.this.m_History.getNameAtIndex(n);
                        AssociationsPanel.this.historyRightClickPopup(string, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        AssociationsPanel.this.historyRightClickPopup(null, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
        this.m_AssociatorEditor.setClassType(Associator.class);
        this.m_AssociatorEditor.setValue(new Apriori());
        this.m_AssociatorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AssociationsPanel.this.repaint();
            }
        });
        this.m_StartBut.setToolTipText(LocalString.get("Starts the associator"));
        this.m_StopBut.setToolTipText(LocalString.get("Stops the associator"));
        this.m_StartBut.setEnabled(false);
        this.m_StopBut.setEnabled(false);
        this.m_StartBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssociationsPanel.this.startAssociator();
            }
        });
        this.m_StopBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssociationsPanel.this.stopAssociator();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Associator"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_CEPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel3.add(this.m_StartBut);
        jPanel3.add(this.m_StopBut);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(LocalString.get("Associator output")));
        jPanel4.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_OutText);
        jPanel4.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel5 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel5.add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.m_History, gridBagConstraints);
        jPanel5.add(this.m_History);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel5.add(jPanel4);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel5, "Center");
    }

    public void setLog(Logger logger) {
        this.m_Log = logger;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        String[] stringArray = new String[this.m_Instances.numAttributes()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "";
            switch (this.m_Instances.attribute(i).type()) {
                case 1: {
                    string = LocalString.get("(Nom) ");
                    break;
                }
                case 0: {
                    string = LocalString.get("(Num) ");
                    break;
                }
                case 2: {
                    string = LocalString.get("(Str) ");
                    break;
                }
                default: {
                    string = "(???) ";
                }
            }
            stringArray[i] = string + this.m_Instances.attribute(i).name();
        }
        this.m_StartBut.setEnabled(this.m_RunThread == null);
        this.m_StopBut.setEnabled(this.m_RunThread != null);
    }

    protected void startAssociator() {
        if (this.m_RunThread == null) {
            this.m_StartBut.setEnabled(false);
            this.m_StopBut.setEnabled(true);
            this.m_RunThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    AssociationsPanel.this.m_Log.statusMessage(LocalString.get("Setting up..."));
                    Instances instances = new Instances(AssociationsPanel.this.m_Instances);
                    Associator associator = (Associator)AssociationsPanel.this.m_AssociatorEditor.getValue();
                    StringBuffer stringBuffer = new StringBuffer();
                    String string = new SimpleDateFormat(LocalString.get("HH:mm:ss - ")).format(new Date());
                    String string2 = associator.getClass().getName();
                    string = string2.startsWith("weka.associations.") ? string + string2.substring("weka.associations.".length()) : string + string2;
                    try {
                        try {
                            AssociationsPanel.this.m_Log.logMessage(LocalString.get("Started ") + string2);
                            if (AssociationsPanel.this.m_Log instanceof TaskLogger) {
                                ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskStarted();
                            }
                            stringBuffer.append(LocalString.get("=== Run information ===\n\n"));
                            stringBuffer.append(LocalString.get("Scheme:       ") + string2);
                            if (associator instanceof OptionHandler) {
                                String[] stringArray = ((OptionHandler)((Object)associator)).getOptions();
                                stringBuffer.append(" " + Utils.joinOptions(stringArray));
                            }
                            stringBuffer.append("\n");
                            stringBuffer.append(LocalString.get("Relation:     ") + instances.relationName() + '\n');
                            stringBuffer.append(LocalString.get("Instances:    ") + instances.numInstances() + '\n');
                            stringBuffer.append(LocalString.get("Attributes:   ") + instances.numAttributes() + '\n');
                            if (instances.numAttributes() < 100) {
                                for (int i = 0; i < instances.numAttributes(); ++i) {
                                    stringBuffer.append("              " + instances.attribute(i).name() + '\n');
                                }
                            } else {
                                stringBuffer.append(LocalString.get("              [list of attributes omitted]\n"));
                            }
                            AssociationsPanel.this.m_History.addResult(string, stringBuffer);
                            AssociationsPanel.this.m_History.setSingle(string);
                            AssociationsPanel.this.m_Log.statusMessage(LocalString.get("Building model on training data..."));
                            associator.buildAssociations(instances);
                            stringBuffer.append(LocalString.get("=== Associator model (full training set) ===\n\n"));
                            stringBuffer.append(associator.toString() + '\n');
                            AssociationsPanel.this.m_History.updateResult(string);
                            AssociationsPanel.this.m_Log.logMessage(LocalString.get("Finished ") + string2);
                            AssociationsPanel.this.m_Log.statusMessage("OK");
                        }
                        catch (Exception exception) {
                            AssociationsPanel.this.m_Log.logMessage(exception.getMessage());
                            AssociationsPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                            Object var8_10 = null;
                            if (this.isInterrupted()) {
                                AssociationsPanel.this.m_Log.logMessage(LocalString.get("Interrupted ") + string2);
                                AssociationsPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                            }
                            AssociationsPanel.this.m_RunThread = null;
                            AssociationsPanel.this.m_StartBut.setEnabled(true);
                            AssociationsPanel.this.m_StopBut.setEnabled(false);
                            if (!(AssociationsPanel.this.m_Log instanceof TaskLogger)) return;
                            ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                            return;
                        }
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        if (this.isInterrupted()) {
                            AssociationsPanel.this.m_Log.logMessage(LocalString.get("Interrupted ") + string2);
                            AssociationsPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                        }
                        AssociationsPanel.this.m_RunThread = null;
                        AssociationsPanel.this.m_StartBut.setEnabled(true);
                        AssociationsPanel.this.m_StopBut.setEnabled(false);
                        if (!(AssociationsPanel.this.m_Log instanceof TaskLogger)) throw throwable;
                        ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                        throw throwable;
                    }
                    if (this.isInterrupted()) {
                        AssociationsPanel.this.m_Log.logMessage(LocalString.get("Interrupted ") + string2);
                        AssociationsPanel.this.m_Log.statusMessage(LocalString.get("See error log"));
                    }
                    AssociationsPanel.this.m_RunThread = null;
                    AssociationsPanel.this.m_StartBut.setEnabled(true);
                    AssociationsPanel.this.m_StopBut.setEnabled(false);
                    if (!(AssociationsPanel.this.m_Log instanceof TaskLogger)) return;
                    ((TaskLogger)((Object)AssociationsPanel.this.m_Log)).taskFinished();
                }
            };
            this.m_RunThread.setPriority(1);
            this.m_RunThread.start();
        }
    }

    protected void stopAssociator() {
        if (this.m_RunThread != null) {
            this.m_RunThread.interrupt();
            this.m_RunThread.stop();
        }
    }

    protected void saveBuffer(String string) {
        StringBuffer stringBuffer = this.m_History.getNamedBuffer(string);
        if (stringBuffer != null && this.m_SaveOut.save(stringBuffer)) {
            this.m_Log.logMessage(LocalString.get("Save successful."));
        }
    }

    protected void historyRightClickPopup(String string, int n, int n2) {
        final String string2 = string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(LocalString.get("View in main window"));
        if (string2 != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AssociationsPanel.this.m_History.setSingle(string2);
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(LocalString.get("View in separate window"));
        if (string2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AssociationsPanel.this.m_History.openFrame(string2);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(LocalString.get("Save result buffer"));
        if (string2 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AssociationsPanel.this.saveBuffer(string2);
                }
            });
        } else {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.show(this.m_History.getList(), n, n2);
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Weka Explorer: Associator"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            AssociationsPanel associationsPanel = new AssociationsPanel();
            jFrame.getContentPane().add((Component)associationsPanel, "Center");
            LogPanel logPanel = new LogPanel();
            associationsPanel.setLog(logPanel);
            jFrame.getContentPane().add((Component)logPanel, "South");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            if (stringArray.length == 1) {
                System.err.println(LocalString.get("Loading instances from ") + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                associationsPanel.setInstances(instances);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(SelectedTag.class, SelectedTagEditor.class);
        PropertyEditorManager.registerEditor(Filter.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(Associator.class, GenericObjectEditor.class);
    }
}

