/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.LocalString;
import weka.experiment.Experiment;

public class RunNumberPanel
extends JPanel {
    protected JTextField m_LowerText = new JTextField("1");
    protected JTextField m_UpperText = new JTextField("10");
    protected Experiment m_Exp;

    public RunNumberPanel() {
        this.m_LowerText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                RunNumberPanel.this.m_Exp.setRunLower(RunNumberPanel.this.getLower());
            }
        });
        this.m_LowerText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RunNumberPanel.this.m_Exp.setRunLower(RunNumberPanel.this.getLower());
            }
        });
        this.m_UpperText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                RunNumberPanel.this.m_Exp.setRunUpper(RunNumberPanel.this.getUpper());
            }
        });
        this.m_UpperText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RunNumberPanel.this.m_Exp.setRunUpper(RunNumberPanel.this.getUpper());
            }
        });
        this.m_LowerText.setEnabled(false);
        this.m_UpperText.setEnabled(false);
        this.setLayout(new GridLayout(1, 2));
        this.setBorder(BorderFactory.createTitledBorder("Runs"));
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add(new JLabel("From:", 4));
        box.add(Box.createHorizontalStrut(5));
        box.add(this.m_LowerText);
        this.add(box);
        Box box2 = new Box(0);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(new JLabel("To:", 4));
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.m_UpperText);
        this.add(box2);
    }

    public RunNumberPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_LowerText.setText("" + this.m_Exp.getRunLower());
        this.m_UpperText.setText("" + this.m_Exp.getRunUpper());
        this.m_LowerText.setEnabled(true);
        this.m_UpperText.setEnabled(true);
    }

    public int getLower() {
        int n = 1;
        try {
            n = Integer.parseInt(this.m_LowerText.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(1, n);
    }

    public int getUpper() {
        int n = 1;
        try {
            n = Integer.parseInt(this.m_UpperText.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.max(1, n);
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Dataset List Editor"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)new RunNumberPanel(new Experiment()), "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

