/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.converters.CSVLoader;
import weka.experiment.CSVResultListener;
import weka.experiment.DatabaseResultListener;
import weka.experiment.Experiment;
import weka.experiment.InstanceQuery;
import weka.experiment.PairedCorrectedTTester;
import weka.experiment.PairedTTester;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ExtensionFileFilter;
import weka.gui.ListSelectorDialog;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.OutputFormatDialog;

public class ResultsPanel
extends JPanel {
    protected static final String NO_SOURCE = LocalString.get("No source");
    protected JButton m_FromFileBut = new JButton("File...");
    protected JButton m_FromDBaseBut = new JButton("Database...");
    protected JButton m_FromExpBut = new JButton("Experiment");
    protected JLabel m_FromLab = new JLabel(NO_SOURCE);
    private static String[] FOR_JFC_1_1_DCBM_BUG = new String[]{""};
    protected DefaultComboBoxModel m_DatasetModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
    protected DefaultComboBoxModel m_CompareModel = new DefaultComboBoxModel<String>(FOR_JFC_1_1_DCBM_BUG);
    protected DefaultListModel m_TestsModel = new DefaultListModel();
    protected DefaultListModel m_DisplayedModel = new DefaultListModel();
    protected JLabel m_DatasetKeyLabel = new JLabel("Row", 4);
    protected JButton m_DatasetKeyBut = new JButton("Select");
    protected DefaultListModel m_DatasetKeyModel = new DefaultListModel();
    protected JList m_DatasetKeyList = new JList(this.m_DatasetKeyModel);
    protected JLabel m_ResultKeyLabel = new JLabel("Column", 4);
    protected JButton m_ResultKeyBut = new JButton("Select");
    protected DefaultListModel m_ResultKeyModel = new DefaultListModel();
    protected JList m_ResultKeyList = new JList(this.m_ResultKeyModel);
    protected JButton m_TestsButton = new JButton(LocalString.get("Select base..."));
    protected JButton m_DisplayedButton = new JButton("Select");
    protected JList m_TestsList = new JList(this.m_TestsModel);
    protected JList m_DisplayedList = new JList(this.m_DisplayedModel);
    protected JComboBox m_CompareCombo = new JComboBox(this.m_CompareModel);
    protected JTextField m_SigTex = new JTextField("" + ExperimenterDefaults.getSignificance());
    protected JCheckBox m_ShowStdDevs = new JCheckBox("");
    protected JButton m_OutputFormatButton = new JButton("Select");
    protected JButton m_PerformBut = new JButton(LocalString.get("Perform test"));
    protected JButton m_SaveOutBut = new JButton(LocalString.get("Save output"));
    SaveBuffer m_SaveOut = new SaveBuffer(null, this);
    protected JTextArea m_OutText = new JTextArea();
    protected ResultHistoryPanel m_History = new ResultHistoryPanel(this.m_OutText);
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected ExtensionFileFilter m_csvFileFilter = new ExtensionFileFilter(CSVLoader.FILE_EXTENSION, LocalString.get("CSV data files"));
    protected ExtensionFileFilter m_arffFileFilter = new ExtensionFileFilter(Instances.FILE_EXTENSION, LocalString.get("Arff data files"));
    protected PairedTTester m_TTester = new PairedCorrectedTTester();
    protected Instances m_Instances;
    protected InstanceQuery m_InstanceQuery;
    protected Thread m_LoadThread;
    protected Experiment m_Exp;
    private Dimension COMBO_SIZE;
    protected boolean m_latexOutput;
    protected boolean m_csvOutput;
    protected int m_MeanPrec;
    protected int m_StdDevPrec;

    public ResultsPanel() {
        this.COMBO_SIZE = new Dimension(150, this.m_ResultKeyBut.getPreferredSize().height);
        this.m_latexOutput = false;
        this.m_csvOutput = false;
        this.m_MeanPrec = ExperimenterDefaults.getMeanPrecision();
        this.m_StdDevPrec = ExperimenterDefaults.getStdDevPrecision();
        this.m_FileChooser.addChoosableFileFilter(this.m_csvFileFilter);
        this.m_FileChooser.addChoosableFileFilter(this.m_arffFileFilter);
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_FromExpBut.setEnabled(false);
        this.m_FromExpBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResultsPanel.this.m_LoadThread == null) {
                    ResultsPanel.this.m_LoadThread = new Thread(){

                        public void run() {
                            ResultsPanel.this.setInstancesFromExp(ResultsPanel.this.m_Exp);
                            ResultsPanel.this.m_LoadThread = null;
                        }
                    };
                    ResultsPanel.this.m_LoadThread.start();
                }
            }
        });
        this.m_FromDBaseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ResultsPanel.this.m_LoadThread == null) {
                    ResultsPanel.this.m_LoadThread = new Thread(){

                        public void run() {
                            ResultsPanel.this.setInstancesFromDBaseQuery();
                            ResultsPanel.this.m_LoadThread = null;
                        }
                    };
                    ResultsPanel.this.m_LoadThread.start();
                }
            }
        });
        this.m_FromFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ResultsPanel.this.m_FileChooser.showOpenDialog(ResultsPanel.this);
                if (n == 0) {
                    final File file = ResultsPanel.this.m_FileChooser.getSelectedFile();
                    if (ResultsPanel.this.m_LoadThread == null) {
                        ResultsPanel.this.m_LoadThread = new Thread(){

                            public void run() {
                                ResultsPanel.this.setInstancesFromFile(file);
                                ResultsPanel.this.m_LoadThread = null;
                            }
                        };
                        ResultsPanel.this.m_LoadThread.start();
                    }
                }
            }
        });
        this.setComboSizes();
        this.m_DatasetKeyBut.setEnabled(false);
        this.m_DatasetKeyBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.setDatasetKeyFromDialog();
            }
        });
        this.m_DatasetKeyList.setSelectionMode(2);
        this.m_ResultKeyBut.setEnabled(false);
        this.m_ResultKeyBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.setResultKeyFromDialog();
            }
        });
        this.m_ResultKeyList.setSelectionMode(2);
        this.m_CompareCombo.setEnabled(false);
        this.m_SigTex.setEnabled(false);
        this.m_TestsButton.setEnabled(false);
        this.m_TestsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.setTestBaseFromDialog();
            }
        });
        this.m_DisplayedButton.setEnabled(false);
        this.m_DisplayedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.setDisplayedFromDialog();
            }
        });
        this.m_ShowStdDevs.setEnabled(false);
        this.m_ShowStdDevs.setSelected(ExperimenterDefaults.getShowStdDevs());
        this.m_OutputFormatButton.setEnabled(false);
        this.m_OutputFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.setOutputFormatFromDialog();
            }
        });
        this.m_PerformBut.setEnabled(false);
        this.m_PerformBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.performTest();
                ResultsPanel.this.m_SaveOutBut.setEnabled(true);
            }
        });
        this.m_PerformBut.setToolTipText(LocalString.get("Performs test using corrected resampled t-test statistic (Nadeau and Bengio)"));
        this.m_SaveOutBut.setEnabled(false);
        this.m_SaveOutBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultsPanel.this.saveBuffer();
            }
        });
        this.m_OutText.setFont(new Font("Monospaced", 0, 12));
        this.m_OutText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_OutText.setEditable(false);
        this.m_History.setBorder(BorderFactory.createTitledBorder(LocalString.get("Result list")));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Source"));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel2.add((Component)this.m_FromFileBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.m_FromDBaseBut, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this.m_FromExpBut, gridBagConstraints);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_FromLab, "Center");
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(LocalString.get("Configure test")));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(this.m_DatasetKeyLabel, gridBagConstraints2);
        jPanel3.add(this.m_DatasetKeyLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_DatasetKeyBut, gridBagConstraints2);
        jPanel3.add(this.m_DatasetKeyBut);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(this.m_ResultKeyLabel, gridBagConstraints2);
        jPanel3.add(this.m_ResultKeyLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_ResultKeyBut, gridBagConstraints2);
        jPanel3.add(this.m_ResultKeyBut);
        JLabel jLabel = new JLabel(LocalString.get("Comparison field"), 4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_CompareCombo, gridBagConstraints2);
        jPanel3.add(this.m_CompareCombo);
        jLabel = new JLabel("Significance", 4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagLayout2.setConstraints(this.m_SigTex, gridBagConstraints2);
        jPanel3.add(this.m_SigTex);
        jLabel = new JLabel(LocalString.get("Test base"), 4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_TestsButton, gridBagConstraints2);
        jPanel3.add(this.m_TestsButton);
        jLabel = new JLabel(LocalString.get("Displayed Columns"), 4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_DisplayedButton, gridBagConstraints2);
        jPanel3.add(this.m_DisplayedButton);
        jLabel = new JLabel(LocalString.get("Show std. deviations"), 4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_ShowStdDevs, gridBagConstraints2);
        jPanel3.add(this.m_ShowStdDevs);
        jLabel = new JLabel(LocalString.get("Output Format"), 4);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 10);
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints2);
        jPanel3.add(jLabel);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 100.0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 0);
        gridBagLayout2.setConstraints(this.m_OutputFormatButton, gridBagConstraints2);
        jPanel3.add(this.m_OutputFormatButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(LocalString.get("Test output")));
        jPanel4.add((Component)new JScrollPane(this.m_OutText), "Center");
        JPanel jPanel5 = new JPanel();
        gridBagLayout2 = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints2);
        jPanel5.add(jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel6.add(this.m_PerformBut);
        jPanel6.add(this.m_SaveOutBut);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagLayout2.setConstraints(jPanel6, gridBagConstraints2);
        jPanel5.add(jPanel6);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 100.0;
        gridBagLayout2.setConstraints(this.m_History, gridBagConstraints2);
        jPanel5.add(this.m_History);
        JSplitPane jSplitPane = new JSplitPane(1, jPanel5, jPanel4);
        jSplitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jSplitPane, "Center");
    }

    protected void setComboSizes() {
        this.m_DatasetKeyBut.setPreferredSize(this.COMBO_SIZE);
        this.m_ResultKeyBut.setPreferredSize(this.COMBO_SIZE);
        this.m_CompareCombo.setPreferredSize(this.COMBO_SIZE);
        this.m_SigTex.setPreferredSize(this.COMBO_SIZE);
        this.m_DatasetKeyBut.setMaximumSize(this.COMBO_SIZE);
        this.m_ResultKeyBut.setMaximumSize(this.COMBO_SIZE);
        this.m_CompareCombo.setMaximumSize(this.COMBO_SIZE);
        this.m_SigTex.setMaximumSize(this.COMBO_SIZE);
        this.m_DatasetKeyBut.setMinimumSize(this.COMBO_SIZE);
        this.m_ResultKeyBut.setMinimumSize(this.COMBO_SIZE);
        this.m_CompareCombo.setMinimumSize(this.COMBO_SIZE);
        this.m_SigTex.setMinimumSize(this.COMBO_SIZE);
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_FromExpBut.setEnabled(experiment != null);
    }

    protected void setInstancesFromDBaseQuery() {
        try {
            if (this.m_InstanceQuery == null) {
                this.m_InstanceQuery = new InstanceQuery();
            }
            String string = this.m_InstanceQuery.getDatabaseURL();
            String string2 = this.m_InstanceQuery.getUsername();
            String string3 = this.m_InstanceQuery.getPassword();
            DatabaseConnectionDialog databaseConnectionDialog = new DatabaseConnectionDialog(null, string, string2);
            databaseConnectionDialog.setVisible(true);
            if (databaseConnectionDialog.getReturnValue() == -1) {
                this.m_FromLab.setText("Cancelled");
                return;
            }
            string = databaseConnectionDialog.getURL();
            string2 = databaseConnectionDialog.getUsername();
            string3 = databaseConnectionDialog.getPassword();
            this.m_InstanceQuery.setDatabaseURL(string);
            this.m_InstanceQuery.setUsername(string2);
            this.m_InstanceQuery.setPassword(string3);
            this.m_InstanceQuery.connectToDatabase();
            if (!this.m_InstanceQuery.experimentIndexExists()) {
                System.err.println(LocalString.get("not found"));
                this.m_FromLab.setText(LocalString.get("No experiment index"));
                return;
            }
            System.err.println("found");
            this.m_FromLab.setText(LocalString.get("Getting experiment index"));
            Instances instances = this.m_InstanceQuery.retrieveInstances(LocalString.get("SELECT * FROM ") + "Experiment_index");
            if (instances.numInstances() == 0) {
                this.m_FromLab.setText(LocalString.get("No experiments available"));
                return;
            }
            this.m_FromLab.setText(LocalString.get("Got experiment index"));
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (int i = 0; i < instances.numInstances(); ++i) {
                defaultListModel.addElement(instances.instance(i).toString());
            }
            JList jList = new JList(defaultListModel);
            jList.setSelectedIndex(0);
            ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, jList);
            int n = listSelectorDialog.showDialog();
            if (n != 0) {
                this.m_FromLab.setText("Cancelled");
                return;
            }
            Instance instance = instances.instance(jList.getSelectedIndex());
            Attribute attribute = instances.attribute("Result_table");
            String string4 = "Results" + instance.toString(attribute);
            this.setInstancesFromDatabaseTable(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_FromLab.setText(LocalString.get("Problem reading database: '") + exception.getMessage() + "'");
        }
    }

    protected void setInstancesFromExp(Experiment experiment) {
        if (experiment.getResultListener() instanceof CSVResultListener) {
            File file = ((CSVResultListener)experiment.getResultListener()).getOutputFile();
            if (file == null) {
                this.m_FromLab.setText(LocalString.get("No result file"));
            } else {
                this.setInstancesFromFile(file);
            }
        } else if (experiment.getResultListener() instanceof DatabaseResultListener) {
            String string = ((DatabaseResultListener)experiment.getResultListener()).getDatabaseURL();
            try {
                if (this.m_InstanceQuery == null) {
                    this.m_InstanceQuery = new InstanceQuery();
                }
                this.m_InstanceQuery.setDatabaseURL(string);
                this.m_InstanceQuery.connectToDatabase();
                String string2 = this.m_InstanceQuery.getResultsTableName(experiment.getResultProducer());
                this.setInstancesFromDatabaseTable(string2);
            }
            catch (Exception exception) {
                this.m_FromLab.setText(LocalString.get("Problem reading database"));
            }
        } else {
            this.m_FromLab.setText(LocalString.get("Can't get results from experiment"));
        }
    }

    protected void setInstancesFromDatabaseTable(String string) {
        try {
            this.m_FromLab.setText(LocalString.get("Reading from database, please wait..."));
            final Instances instances = this.m_InstanceQuery.retrieveInstances(LocalString.get("SELECT * FROM ") + string);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ResultsPanel.this.setInstances(instances);
                }
            });
            this.m_InstanceQuery.disconnectFromDatabase();
        }
        catch (Exception exception) {
            this.m_FromLab.setText(exception.getMessage());
        }
    }

    protected void setInstancesFromFile(File file) {
        block5: {
            String string = file.getName();
            try {
                this.m_FromLab.setText(LocalString.get("Reading from file..."));
                if (file.getName().toLowerCase().endsWith(Instances.FILE_EXTENSION)) {
                    string = "arff";
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    this.setInstances(new Instances(bufferedReader));
                    ((Reader)bufferedReader).close();
                    break block5;
                }
                if (file.getName().toLowerCase().endsWith(CSVLoader.FILE_EXTENSION)) {
                    string = "csv";
                    CSVLoader cSVLoader = new CSVLoader();
                    cSVLoader.setSource(file);
                    Instances instances = cSVLoader.getDataSet();
                    this.setInstances(instances);
                    break block5;
                }
                throw new Exception(LocalString.get("Unrecognized file type"));
            }
            catch (Exception exception) {
                this.m_FromLab.setText(LocalString.get("File '") + file.getName() + LocalString.get("' not recognised as an ") + string + LocalString.get(" file."));
                if (JOptionPane.showOptionDialog(this, LocalString.get("File '") + file.getName() + LocalString.get("' not recognised as an ") + string + LocalString.get(" file.\n") + "Reason:\n" + exception.getMessage(), LocalString.get("Load Instances"), 0, 0, null, new String[]{"OK"}, null) == 1) {
                    // empty if block
                }
            }
        }
    }

    protected Vector determineColumnNames(String string, String string2, Instances instances) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < instances.numAttributes(); ++i) {
            vector.add(instances.attribute(i).name().toLowerCase());
        }
        Vector<String> vector2 = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            if (vector.contains(string3)) {
                vector2.add(string3);
                continue;
            }
            vector2.clear();
            break;
        }
        if (vector2.size() == 0) {
            stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken().toLowerCase());
            }
        }
        return vector2;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
        this.m_TTester.setInstances(this.m_Instances);
        this.m_FromLab.setText(LocalString.get("Got ") + this.m_Instances.numInstances() + LocalString.get(" results"));
        Vector vector = this.determineColumnNames(ExperimenterDefaults.getRow(), "Key_Dataset", this.m_Instances);
        Vector vector2 = this.determineColumnNames(ExperimenterDefaults.getColumn(), "Key_Scheme,Key_Scheme_options,Key_Scheme_version_ID", this.m_Instances);
        this.m_DatasetKeyModel.removeAllElements();
        this.m_ResultKeyModel.removeAllElements();
        this.m_CompareModel.removeAllElements();
        String string = "";
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            String string3 = this.m_Instances.attribute(i).name();
            if (string3.toLowerCase().startsWith("key_", 0)) {
                this.m_DatasetKeyModel.addElement(string3.substring(4));
                this.m_ResultKeyModel.addElement(string3.substring(4));
                this.m_CompareModel.addElement(string3.substring(4));
            } else {
                this.m_DatasetKeyModel.addElement(string3);
                this.m_ResultKeyModel.addElement(string3);
                this.m_CompareModel.addElement(string3);
            }
            if (vector.contains(string3.toLowerCase())) {
                this.m_DatasetKeyList.addSelectionInterval(i, i);
                string2 = string2 + "," + (i + 1);
                continue;
            }
            if (string3.toLowerCase().equals("key_run")) {
                this.m_TTester.setRunColumn(i);
                continue;
            }
            if (string3.toLowerCase().equals("key_fold")) {
                this.m_TTester.setFoldColumn(i);
                continue;
            }
            if (vector2.contains(string3.toLowerCase())) {
                this.m_ResultKeyList.addSelectionInterval(i, i);
                string = string + "," + (i + 1);
                continue;
            }
            if (string3.toLowerCase().indexOf(ExperimenterDefaults.getComparisonField()) != -1) {
                this.m_CompareCombo.setSelectedIndex(i);
                bl = true;
                continue;
            }
            if (string3.toLowerCase().indexOf("root_relative_squared_error") == -1 || bl) continue;
            this.m_CompareCombo.setSelectedIndex(i);
            bl = true;
        }
        this.m_DatasetKeyBut.setEnabled(true);
        this.m_ResultKeyBut.setEnabled(true);
        this.m_CompareCombo.setEnabled(true);
        Range range = new Range();
        if (string.length() != 0) {
            try {
                range.setRanges(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
            }
        }
        this.m_TTester.setResultsetKeyColumns(range);
        range = new Range();
        if (string2.length() != 0) {
            try {
                range.setRanges(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println(exception.getMessage());
            }
        }
        this.m_TTester.setDatasetKeyColumns(range);
        this.m_SigTex.setEnabled(true);
        this.setTTester();
    }

    protected void setTTester() {
        int n;
        this.m_TTester.setDisplayedResultsets(null);
        String string = new SimpleDateFormat(LocalString.get("HH:mm:ss - ")).format(new Date()) + LocalString.get("Available resultsets");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("Available resultsets\n") + this.m_TTester.resultsetKey() + "\n\n");
        this.m_History.addResult(string, stringBuffer);
        this.m_History.setSingle(string);
        this.m_TestsModel.removeAllElements();
        for (n = 0; n < this.m_TTester.getNumResultsets(); ++n) {
            String string2 = this.m_TTester.getResultsetName(n);
            this.m_TestsModel.addElement(string2);
        }
        this.m_DisplayedModel.removeAllElements();
        for (n = 0; n < this.m_TestsModel.size(); ++n) {
            this.m_DisplayedModel.addElement(this.m_TestsModel.elementAt(n));
        }
        this.m_TestsModel.addElement("Summary");
        this.m_TestsModel.addElement("Ranking");
        this.m_TestsList.setSelectedIndex(0);
        this.m_DisplayedList.setSelectionInterval(0, this.m_DisplayedModel.size() - 1);
        this.m_TestsButton.setEnabled(true);
        this.m_DisplayedButton.setEnabled(true);
        this.m_ShowStdDevs.setEnabled(true);
        this.m_OutputFormatButton.setEnabled(true);
        this.m_PerformBut.setEnabled(true);
    }

    protected void performTest() {
        String string = this.m_SigTex.getText();
        if (string.length() != 0) {
            this.m_TTester.setSignificanceLevel(new Double(string));
        } else {
            this.m_TTester.setSignificanceLevel(ExperimenterDefaults.getSignificance());
        }
        this.m_TTester.setShowStdDevs(this.m_ShowStdDevs.isSelected());
        int n = this.m_CompareCombo.getSelectedIndex();
        int n2 = this.m_TestsList.getSelectedIndex();
        String string2 = new SimpleDateFormat(LocalString.get("HH:mm:ss - ")).format(new Date()) + (String)this.m_CompareCombo.getSelectedItem() + " - " + (String)this.m_TestsList.getSelectedValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_TTester.header(n));
        stringBuffer.append("\n");
        this.m_History.addResult(string2, stringBuffer);
        this.m_History.setSingle(string2);
        this.m_TTester.setDisplayedResultsets(this.m_DisplayedList.getSelectedIndices());
        this.m_TTester.setMeanPrec(this.m_MeanPrec);
        this.m_TTester.setStdDevPrec(this.m_StdDevPrec);
        this.m_TTester.setProduceLatex(this.m_latexOutput);
        this.m_TTester.setProduceCSV(this.m_csvOutput);
        try {
            if (n2 < this.m_TTester.getNumResultsets()) {
                stringBuffer.append(this.m_TTester.multiResultsetFull(n2, n));
            } else if (n2 == this.m_TTester.getNumResultsets()) {
                stringBuffer.append(this.m_TTester.multiResultsetSummary(n));
            } else {
                stringBuffer.append(this.m_TTester.multiResultsetRanking(n));
            }
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            stringBuffer.append(exception.getMessage() + "\n");
        }
        this.m_History.updateResult(string2);
    }

    public void setResultKeyFromDialog() {
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, this.m_ResultKeyList);
        int n = listSelectorDialog.showDialog();
        if (n == 0) {
            int[] nArray = this.m_ResultKeyList.getSelectedIndices();
            String string = "";
            for (int i = 0; i < nArray.length; ++i) {
                string = string + "," + (nArray[i] + 1);
            }
            Range range = new Range();
            if (string.length() != 0) {
                try {
                    range.setRanges(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println(exception.getMessage());
                }
            }
            this.m_TTester.setResultsetKeyColumns(range);
            this.setTTester();
        }
    }

    public void setDatasetKeyFromDialog() {
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, this.m_DatasetKeyList);
        int n = listSelectorDialog.showDialog();
        if (n == 0) {
            int[] nArray = this.m_DatasetKeyList.getSelectedIndices();
            String string = "";
            for (int i = 0; i < nArray.length; ++i) {
                string = string + "," + (nArray[i] + 1);
            }
            Range range = new Range();
            if (string.length() != 0) {
                try {
                    range.setRanges(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println(exception.getMessage());
                }
            }
            this.m_TTester.setDatasetKeyColumns(range);
            this.setTTester();
        }
    }

    public void setTestBaseFromDialog() {
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, this.m_TestsList);
        listSelectorDialog.showDialog();
    }

    public void setDisplayedFromDialog() {
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, this.m_DisplayedList);
        listSelectorDialog.showDialog();
    }

    public void setOutputFormatFromDialog() {
        OutputFormatDialog outputFormatDialog = new OutputFormatDialog(null);
        outputFormatDialog.setProduceLatex(this.m_latexOutput);
        outputFormatDialog.setProduceCSV(this.m_csvOutput);
        outputFormatDialog.setMeanPrec(this.m_MeanPrec);
        outputFormatDialog.setStdDevPrec(this.m_StdDevPrec);
        if (outputFormatDialog.showDialog() == 0) {
            this.m_latexOutput = outputFormatDialog.getProduceLatex();
            this.m_csvOutput = outputFormatDialog.getProduceCSV();
            this.m_MeanPrec = outputFormatDialog.getMeanPrec();
            this.m_StdDevPrec = outputFormatDialog.getStdDevPrec();
        }
    }

    protected void saveBuffer() {
        StringBuffer stringBuffer = this.m_History.getSelectedBuffer();
        if (stringBuffer != null) {
            if (this.m_SaveOut.save(stringBuffer)) {
                JOptionPane.showMessageDialog(this, LocalString.get("File saved"), "Results", 1);
            }
        } else {
            this.m_SaveOutBut.setEnabled(false);
        }
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame(LocalString.get("Weka Experiment: Results Analysis"));
            jFrame.getContentPane().setLayout(new BorderLayout());
            ResultsPanel resultsPanel = new ResultsPanel();
            jFrame.getContentPane().add((Component)resultsPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setSize(700, 550);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

