/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorManager;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import weka.LocalString;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.core.SelectedTag;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseSaver;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.Loader;
import weka.filters.Filter;
import weka.gui.CostMatrixEditor;
import weka.gui.FileEditor;
import weka.gui.GenericArrayEditor;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.SelectedTagEditor;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.Saver;

public class SaverCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester {
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Saver m_dsSaver;
    private PropertySheetPanel m_SaverEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JTextField m_dbaseURLText;
    private JTextField m_userNameText;
    private JPasswordField m_passwordText;
    private JTextField m_tableText;
    private JComboBox m_idBox;
    private JComboBox m_tabBox;
    private JTextField m_prefixText;

    public SaverCustomizer() {
        try {
            this.m_SaverEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SaverCustomizer.this.repaint();
                    if (SaverCustomizer.this.m_dsSaver != null) {
                        System.err.println(LocalString.get("Property change!!"));
                        SaverCustomizer.this.m_dsSaver.setSaver(SaverCustomizer.this.m_dsSaver.getSaver());
                    }
                }
            });
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.setFileSelectionMode(1);
        this.m_fileChooser.setApproveButtonText(LocalString.get("Select directory and prefix"));
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    try {
                        SaverCustomizer.this.m_dsSaver.getSaver().setFilePrefix(SaverCustomizer.this.m_prefixText.getText());
                        SaverCustomizer.this.m_dsSaver.getSaver().setDir(SaverCustomizer.this.m_fileChooser.getSelectedFile().getAbsolutePath());
                        SaverCustomizer.this.m_dsSaver.setSaver(SaverCustomizer.this.m_dsSaver.getSaver());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (SaverCustomizer.this.m_parentFrame != null) {
                    SaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
    }

    public void setParentFrame(JFrame jFrame) {
        this.m_parentFrame = jFrame;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_SaverEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 1));
        this.m_dbaseURLText = new JTextField(((DatabaseConverter)((Object)this.m_dsSaver.getSaver())).getUrl(), 50);
        JLabel jLabel = new JLabel(LocalString.get(" Database URL:          "), 2);
        jLabel.setFont(new Font("Monospaced", 0, 12));
        this.m_userNameText = new JTextField(((DatabaseConverter)((Object)this.m_dsSaver.getSaver())).getUser(), 50);
        JLabel jLabel2 = new JLabel(LocalString.get(" Username:              "), 2);
        jLabel2.setFont(new Font("Monospaced", 0, 12));
        this.m_passwordText = new JPasswordField(50);
        JLabel jLabel3 = new JLabel(LocalString.get(" Password:              "), 2);
        jLabel3.setFont(new Font("Monospaced", 0, 12));
        this.m_tableText = new JTextField(((DatabaseSaver)this.m_dsSaver.getSaver()).getTableName(), 50);
        this.m_tableText.setEditable(!((DatabaseSaver)this.m_dsSaver.getSaver()).getRelationForTableName());
        JLabel jLabel4 = new JLabel(LocalString.get(" Table Name:            "), 2);
        jLabel4.setFont(new Font("Monospaced", 0, 12));
        this.m_tabBox = new JComboBox();
        this.m_tabBox.addItem(new Boolean(true));
        this.m_tabBox.addItem(new Boolean(false));
        if (!((DatabaseSaver)this.m_dsSaver.getSaver()).getRelationForTableName()) {
            this.m_tabBox.setSelectedIndex(1);
        } else {
            this.m_tabBox.setSelectedIndex(0);
        }
        this.m_tabBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SaverCustomizer.this.m_tableText.setEditable((Boolean)SaverCustomizer.this.m_tabBox.getSelectedItem() == false);
            }
        });
        JLabel jLabel5 = new JLabel(LocalString.get(" Use relation name:     "), 2);
        jLabel5.setFont(new Font("Monospaced", 0, 12));
        this.m_idBox = new JComboBox();
        this.m_idBox.addItem(new Boolean(true));
        this.m_idBox.addItem(new Boolean(false));
        if (!((DatabaseSaver)this.m_dsSaver.getSaver()).getAutoKeyGeneration()) {
            this.m_idBox.setSelectedIndex(1);
        } else {
            this.m_idBox.setSelectedIndex(0);
        }
        JLabel jLabel6 = new JLabel(LocalString.get(" Automatic primary key: "), 2);
        jLabel6.setFont(new Font("Monospaced", 0, 12));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.m_dbaseURLText);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(jLabel2);
        jPanel3.add(this.m_userNameText);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel3);
        jPanel4.add(this.m_passwordText);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(jLabel5);
        jPanel5.add(this.m_tabBox);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(jLabel4);
        jPanel6.add(this.m_tableText);
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(jLabel6);
        jPanel7.add(this.m_idBox);
        jPanel.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        JButton jButton = new JButton("OK");
        jPanel8.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jPanel8.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).resetStructure();
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setUrl(SaverCustomizer.this.m_dbaseURLText.getText());
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setUser(SaverCustomizer.this.m_userNameText.getText());
                ((DatabaseConverter)((Object)SaverCustomizer.this.m_dsSaver.getSaver())).setPassword(new String(SaverCustomizer.this.m_passwordText.getPassword()));
                if (!((Boolean)SaverCustomizer.this.m_tabBox.getSelectedItem()).booleanValue()) {
                    ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).setTableName(SaverCustomizer.this.m_tableText.getText());
                }
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).setAutoKeyGeneration((Boolean)SaverCustomizer.this.m_idBox.getSelectedItem());
                ((DatabaseSaver)SaverCustomizer.this.m_dsSaver.getSaver()).setRelationForTableName((Boolean)SaverCustomizer.this.m_tabBox.getSelectedItem());
                if (SaverCustomizer.this.m_parentFrame != null) {
                    SaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SaverCustomizer.this.m_parentFrame != null) {
                    SaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        jPanel.add(jPanel8);
        JPanel jPanel9 = this.m_SaverEditor.getAboutPanel();
        if (jPanel9 != null) {
            this.add((Component)jPanel9, "North");
        }
        this.add((Component)jPanel, "South");
    }

    public void setUpFile() {
        JComponent jComponent;
        this.removeAll();
        this.m_fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return "Directory";
            }
        });
        this.m_fileChooser.setAcceptAllFileFilterUsed(false);
        try {
            if (!this.m_dsSaver.getSaver().retrieveDir().equals("")) {
                this.m_fileChooser.setCurrentDirectory(new File(this.m_dsSaver.getSaver().retrieveDir()));
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        try {
            this.m_prefixText = new JTextField(this.m_dsSaver.getSaver().filePrefix(), 25);
            jComponent = new JLabel(LocalString.get(" Prefix for file name:"), 2);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0));
            jPanel2.add(jComponent);
            jPanel2.add(this.m_prefixText);
            jPanel.add((Component)jPanel2, "South");
        }
        catch (Exception exception) {
            // empty catch block
        }
        jComponent = this.m_SaverEditor.getAboutPanel();
        if (jComponent != null) {
            jPanel.add((Component)jComponent, "North");
        }
        this.add((Component)jPanel, "North");
        this.add((Component)this.m_fileChooser, "Center");
    }

    public void setObject(Object object) {
        this.m_dsSaver = (Saver)object;
        this.m_SaverEditor.setTarget(this.m_dsSaver.getSaver());
        if (this.m_dsSaver.getSaver() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else if (this.m_dsSaver.getSaver() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else {
            this.setUpOther();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        PropertyEditorManager.registerEditor(weka.core.converters.Saver.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(Loader.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(SelectedTag.class, SelectedTagEditor.class);
        PropertyEditorManager.registerEditor(Filter.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(ASSearch.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(ASEvaluation.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(Classifier[].class, GenericArrayEditor.class);
        PropertyEditorManager.registerEditor(Object[].class, GenericArrayEditor.class);
        PropertyEditorManager.registerEditor(Classifier.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(CostMatrix.class, CostMatrixEditor.class);
        PropertyEditorManager.registerEditor(File.class, FileEditor.class);
    }
}

