/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorManager;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import weka.LocalString;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.core.SelectedTag;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.filters.Filter;
import weka.gui.CostMatrixEditor;
import weka.gui.ExtensionFileFilter;
import weka.gui.FileEditor;
import weka.gui.GenericArrayEditor;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.SelectedTagEditor;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.Loader;

public class LoaderCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester {
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Loader m_dsLoader;
    private PropertySheetPanel m_LoaderEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JTextField m_dbaseURLText;
    private JTextField m_userNameText;
    private JTextField m_queryText;
    private JTextField m_keyText;
    private JPasswordField m_passwordText;

    public LoaderCustomizer() {
        try {
            this.m_LoaderEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LoaderCustomizer.this.repaint();
                    if (LoaderCustomizer.this.m_dsLoader != null) {
                        System.err.println(LocalString.get("Property change!!"));
                        LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_dsLoader.getLoader());
                    }
                }
            });
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(0);
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    try {
                        ((FileSourcedConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setFile(LoaderCustomizer.this.m_fileChooser.getSelectedFile());
                        LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_dsLoader.getLoader());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
    }

    public void setParentFrame(JFrame jFrame) {
        this.m_parentFrame = jFrame;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_LoaderEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 1));
        this.m_dbaseURLText = new JTextField(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUrl(), 50);
        JLabel jLabel = new JLabel(LocalString.get(" Database URL:"), 2);
        jLabel.setFont(new Font("Monospaced", 0, 12));
        this.m_userNameText = new JTextField(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUser(), 50);
        JLabel jLabel2 = new JLabel(LocalString.get(" Username:    "), 2);
        jLabel2.setFont(new Font("Monospaced", 0, 12));
        this.m_passwordText = new JPasswordField(50);
        JLabel jLabel3 = new JLabel(LocalString.get(" Password:    "), 2);
        jLabel3.setFont(new Font("Monospaced", 0, 12));
        this.m_queryText = new JTextField(((DatabaseLoader)this.m_dsLoader.getLoader()).getQuery(), 50);
        JLabel jLabel4 = new JLabel(LocalString.get(" Query:       "), 2);
        jLabel4.setFont(new Font("Monospaced", 0, 12));
        this.m_keyText = new JTextField(((DatabaseLoader)this.m_dsLoader.getLoader()).getKeys(), 50);
        JLabel jLabel5 = new JLabel(LocalString.get(" Key columns: "), 2);
        jLabel5.setFont(new Font("Monospaced", 0, 12));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.m_dbaseURLText);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(jLabel2);
        jPanel3.add(this.m_userNameText);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel3);
        jPanel4.add(this.m_passwordText);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(jLabel4);
        jPanel5.add(this.m_queryText);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(0));
        jPanel6.add(jLabel5);
        jPanel6.add(this.m_keyText);
        jPanel.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        JButton jButton = new JButton("OK");
        jPanel7.add(jButton);
        JButton jButton2 = new JButton("Cancel");
        jPanel7.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).resetStructure();
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUrl(LoaderCustomizer.this.m_dbaseURLText.getText());
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUser(LoaderCustomizer.this.m_userNameText.getText());
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setPassword(new String(LoaderCustomizer.this.m_passwordText.getPassword()));
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setQuery(LoaderCustomizer.this.m_queryText.getText());
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setKeys(LoaderCustomizer.this.m_keyText.getText());
                try {
                    LoaderCustomizer.this.m_dsLoader.notifyStructureAvailable(((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).getStructure());
                    LoaderCustomizer.this.m_dsLoader.setDB(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        jPanel.add(jPanel7);
        JPanel jPanel8 = this.m_LoaderEditor.getAboutPanel();
        if (jPanel8 != null) {
            this.add((Component)jPanel8, "North");
        }
        this.add((Component)jPanel, "South");
    }

    public void setUpFile() {
        this.removeAll();
        this.m_fileChooser.setSelectedFile(((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).retrieveFile());
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).getFileExtension(), ((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).getFileDescription());
        this.m_fileChooser.addChoosableFileFilter(extensionFileFilter);
        JPanel jPanel = this.m_LoaderEditor.getAboutPanel();
        if (jPanel != null) {
            this.add((Component)jPanel, "North");
        }
        this.add((Component)this.m_fileChooser, "Center");
    }

    public void setObject(Object object) {
        this.m_dsLoader = (Loader)object;
        this.m_LoaderEditor.setTarget(this.m_dsLoader.getLoader());
        if (this.m_dsLoader.getLoader() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else if (this.m_dsLoader.getLoader() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else {
            this.setUpOther();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_pcSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        PropertyEditorManager.registerEditor(weka.core.converters.Loader.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(SelectedTag.class, SelectedTagEditor.class);
        PropertyEditorManager.registerEditor(Filter.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(ASSearch.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(ASEvaluation.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(Classifier[].class, GenericArrayEditor.class);
        PropertyEditorManager.registerEditor(Object[].class, GenericArrayEditor.class);
        PropertyEditorManager.registerEditor(Classifier.class, GenericObjectEditor.class);
        PropertyEditorManager.registerEditor(CostMatrix.class, CostMatrixEditor.class);
        PropertyEditorManager.registerEditor(File.class, FileEditor.class);
    }
}

