/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.LocalString;

public class SimpleCLI
extends Frame
implements ActionListener {
    protected TextArea m_OutputArea = new TextArea();
    protected TextField m_Input = new TextField();
    protected Vector m_CommandHistory = new Vector();
    protected int m_HistoryPos = 0;
    protected PipedOutputStream m_POO = new PipedOutputStream();
    protected PipedOutputStream m_POE = new PipedOutputStream();
    protected Thread m_OutRedirector;
    protected Thread m_ErrRedirector;
    protected Thread m_RunThread;

    public SimpleCLI() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_OutputArea, "Center");
        this.add((Component)this.m_Input, "South");
        this.m_Input.addActionListener(this);
        this.m_Input.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                SimpleCLI.this.doHistory(keyEvent);
            }
        });
        this.m_OutputArea.setEditable(false);
        this.m_OutputArea.setFont(new Font("Monospaced", 0, 12));
        PipedInputStream pipedInputStream = new PipedInputStream(this.m_POO);
        System.setOut(new PrintStream(this.m_POO));
        InputStreamReader inputStreamReader = new InputStreamReader(pipedInputStream);
        this.m_OutRedirector = new ReaderToTextArea(inputStreamReader, this.m_OutputArea);
        this.m_OutRedirector.start();
        PipedInputStream pipedInputStream2 = new PipedInputStream(this.m_POE);
        System.setErr(new PrintStream(this.m_POE));
        inputStreamReader = new InputStreamReader(pipedInputStream2);
        this.m_ErrRedirector = new ReaderToTextArea(inputStreamReader, this.m_OutputArea);
        this.m_ErrRedirector.start();
        this.pack();
        this.setSize(600, 500);
        System.out.println(LocalString.get("\nWelcome to the WEKA SimpleCLI\n\n") + LocalString.get("Enter commands in the textfield at the bottom of \n") + LocalString.get("the window. Use the up and down arrows to move \n") + LocalString.get("through previous commands.\n\n"));
        this.runCommand("help");
    }

    public void runCommand(String string) throws Exception {
        System.out.println("> " + string + '\n');
        System.out.flush();
        String[] stringArray = SimpleCLI.splitOptions(string);
        if (stringArray.length == 0) {
            return;
        }
        if (stringArray[0].equals("java")) {
            stringArray[0] = "";
            try {
                if (stringArray.length == 1) {
                    throw new Exception(LocalString.get("No class name given"));
                }
                String string2 = stringArray[1];
                stringArray[1] = "";
                if (this.m_RunThread != null) {
                    throw new Exception(LocalString.get("An object is already running, use \"break\"") + LocalString.get(" to interrupt it."));
                }
                Class<?> clazz = Class.forName(string2);
                Vector<String> vector = new Vector<String>();
                for (int i = 2; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
                this.m_RunThread = new ClassRunner(clazz, vector.toArray(new String[vector.size()]));
                this.m_RunThread.setPriority(1);
                this.m_RunThread.start();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        } else if (stringArray[0].equals("cls")) {
            this.m_OutputArea.setText("");
        } else if (stringArray[0].equals("break")) {
            if (this.m_RunThread == null) {
                System.err.println(LocalString.get("Nothing is currently running."));
            } else {
                System.out.println("[Interrupt...]");
                this.m_RunThread.interrupt();
            }
        } else if (stringArray[0].equals("kill")) {
            if (this.m_RunThread == null) {
                System.err.println(LocalString.get("Nothing is currently running."));
            } else {
                System.out.println("[Kill...]");
                this.m_RunThread.stop();
                this.m_RunThread = null;
            }
        } else if (stringArray[0].equals("exit")) {
            this.processEvent(new WindowEvent(this, 201));
        } else {
            boolean bl;
            boolean bl2 = bl = stringArray.length > 1 && stringArray[0].equals("help");
            if (bl && stringArray[1].equals("java")) {
                System.err.println(LocalString.get("java <classname> <args>\n\n") + LocalString.get("Starts the main method of <classname> with ") + LocalString.get("the supplied command line arguments (if any).\n") + LocalString.get("The command is started in a separate thread, ") + LocalString.get("and may be interrupted with the \"break\"\n") + LocalString.get("command (friendly), or killed with the \"kill\" ") + LocalString.get("command (unfriendly).\n"));
            } else if (bl && stringArray[1].equals("break")) {
                System.err.println("break\n\n" + LocalString.get("Attempts to nicely interrupt the running job, ") + LocalString.get("if any. If this doesn't respond in an\n") + LocalString.get("acceptable time, use \"kill\".\n"));
            } else if (bl && stringArray[1].equals("kill")) {
                System.err.println("kill\n\n" + LocalString.get("Kills the running job, if any. You should only ") + LocalString.get("use this if the job doesn't respond to\n") + "\"break\".\n");
            } else if (bl && stringArray[1].equals("cls")) {
                System.err.println("cls\n\n" + LocalString.get("Clears the output area.\n"));
            } else if (bl && stringArray[1].equals("exit")) {
                System.err.println("exit\n\n" + LocalString.get("Exits the SimpleCLI program.\n"));
            } else {
                System.err.println(LocalString.get("Command must be one of:\n") + LocalString.get("\tjava <classname> <args>\n") + "\tbreak\n" + "\tkill\n" + "\tcls\n" + "\texit\n" + LocalString.get("\thelp <command>\n"));
            }
        }
    }

    protected static String[] splitOptions(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public void doHistory(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.m_Input) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (this.m_HistoryPos <= 0) break;
                    --this.m_HistoryPos;
                    String string = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    this.m_Input.setText(string);
                    break;
                }
                case 40: {
                    if (this.m_HistoryPos >= this.m_CommandHistory.size()) break;
                    ++this.m_HistoryPos;
                    String string = "";
                    if (this.m_HistoryPos < this.m_CommandHistory.size()) {
                        string = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    }
                    this.m_Input.setText(string);
                    break;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.m_Input) {
                String string = this.m_Input.getText();
                int n = this.m_CommandHistory.size() - 1;
                if (n < 0 || !string.equals((String)this.m_CommandHistory.elementAt(n))) {
                    this.m_CommandHistory.addElement(string);
                    this.m_HistoryPos = this.m_CommandHistory.size();
                }
                this.runCommand(string);
                this.m_Input.setText("");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            final SimpleCLI simpleCLI = new SimpleCLI();
            simpleCLI.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.err.println(LocalString.get("window closed"));
                    simpleCLI.dispose();
                }
            });
            simpleCLI.setVisible(true);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(0);
        }
    }

    class ClassRunner
    extends Thread {
        protected Method m_MainMethod;
        String[] m_CommandArgs;

        public ClassRunner(Class clazz, String[] stringArray) throws Exception {
            this.setDaemon(true);
            Class[] classArray = new Class[]{String[].class};
            this.m_CommandArgs = stringArray;
            this.m_MainMethod = clazz.getMethod("main", classArray);
            if ((this.m_MainMethod.getModifiers() & 8) == 0 || (this.m_MainMethod.getModifiers() & 1) == 0) {
                throw new NoSuchMethodException(LocalString.get("main(String[]) method of ") + clazz.getName() + LocalString.get(" is not public and static."));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object[] objectArray = new Object[]{this.m_CommandArgs};
                this.m_MainMethod.invoke(null, objectArray);
                if (this.isInterrupted()) {
                    System.err.println("[...Interrupted]");
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() == null) {
                    System.err.println("[...Killed]");
                } else {
                    System.err.println(LocalString.get("[Run exception] ") + exception.getMessage());
                }
            }
            finally {
                SimpleCLI.this.m_RunThread = null;
            }
        }
    }

    class ReaderToTextArea
    extends Thread {
        protected LineNumberReader m_Input;
        protected TextArea m_Output;

        public ReaderToTextArea(Reader reader, TextArea textArea) {
            this.setDaemon(true);
            this.m_Input = new LineNumberReader(reader);
            this.m_Output = textArea;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.m_Output.append(this.m_Input.readLine() + '\n');
                    }
                }
                catch (Exception exception) {
                    try {
                        ReaderToTextArea.sleep(100L);
                    }
                    catch (Exception exception2) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

