/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.LocalString;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class Copy
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    protected Range m_CopyCols = new Range();
    protected int[] m_SelectedAttributes;
    protected int[] m_InputStringIndex;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tSpecify list of columns to copy. First and last are valid\n") + LocalString.get("\tindexes. (default none)"), "R", 1, LocalString.get("-R <index1,index2-index4,...>")));
        vector.addElement(new Option(LocalString.get("\tInvert matching sense (i.e. copy all non-specified columns)"), "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndices(string);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[3];
        int n = 0;
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        if (!this.getAttributeIndices().equals("")) {
            stringArray[n++] = "-R";
            stringArray[n++] = this.getAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_CopyCols.setUpper(instances.numAttributes() - 1);
        Instances instances2 = new Instances(instances, 0);
        this.m_SelectedAttributes = this.m_CopyCols.getSelection();
        int n = 0;
        int[] nArray = new int[this.m_SelectedAttributes.length];
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int n2 = this.m_SelectedAttributes[i];
            Attribute attribute = instances.attribute(n2);
            instances2.insertAttributeAt((Attribute)attribute.copy(), instances2.numAttributes());
            instances2.renameAttribute(instances2.numAttributes() - 1, LocalString.get("Copy of ") + attribute.name());
            if (attribute.type() != 2) continue;
            nArray[n++] = n2;
        }
        int[] nArray2 = this.getInputStringIndex();
        this.m_InputStringIndex = new int[nArray2.length + n];
        System.arraycopy(nArray2, 0, this.m_InputStringIndex, 0, nArray2.length);
        System.arraycopy(nArray, 0, this.m_InputStringIndex, nArray2.length, n);
        this.setOutputFormat(instances2);
        return true;
    }

    public boolean input(Instance instance) {
        int n;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException(LocalString.get("No input instance format defined"));
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        double[] dArray = new double[this.outputFormatPeek().numAttributes()];
        for (n = 0; n < this.getInputFormat().numAttributes(); ++n) {
            dArray[n] = instance.value(n);
        }
        n = this.getInputFormat().numAttributes();
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            int n2 = this.m_SelectedAttributes[i];
            dArray[i + n] = instance.value(n2);
        }
        Instance instance2 = null;
        instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray) : new Instance(instance.weight(), dArray);
        this.copyStringValues(instance2, false, instance.dataset(), this.m_InputStringIndex, this.getOutputFormat(), this.getOutputStringIndex());
        instance2.setDataset(this.getOutputFormat());
        this.push(instance2);
        return true;
    }

    public String globalInfo() {
        return LocalString.get("An instance filter that copies a range of attributes in the") + LocalString.get(" dataset. This is used in conjunction with other filters that") + LocalString.get(" overwrite attribute values during the course of their operation --") + LocalString.get(" this filter allows the original attributes to be kept as well") + LocalString.get(" as the new attributes.");
    }

    public String invertSelectionTipText() {
        return LocalString.get("Sets copy selected vs unselected action.") + LocalString.get(" If set to false, only the specified attributes will be copied;") + LocalString.get(" If set to true, non-specified attributes will be copied.");
    }

    public boolean getInvertSelection() {
        return this.m_CopyCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_CopyCols.setInvert(bl);
    }

    public String getAttributeIndices() {
        return this.m_CopyCols.getRanges();
    }

    public String attributeIndicesTipText() {
        return LocalString.get("Specify range of attributes to act on.") + LocalString.get(" This is a comma separated list of attribute indices, with") + LocalString.get(" \"first\" and \"last\" valid values. Specify an inclusive") + LocalString.get(" range with \"-\". E.g: \"first-3,5,6-10,last\".");
    }

    public void setAttributeIndices(String string) throws Exception {
        this.m_CopyCols.setRanges(string);
    }

    public void setAttributeIndicesArray(int[] nArray) throws Exception {
        this.setAttributeIndices(Range.indicesToRangeList(nArray));
    }

    public static void main(String[] stringArray) {
        try {
            if (Utils.getFlag('b', stringArray)) {
                Filter.batchFilterFile(new Copy(), stringArray);
            } else {
                Filter.filterFile(new Copy(), stringArray);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

