/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.experiment.AveragingResultProducer;
import weka.experiment.CSVResultListener;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class LearningRateResultProducer
implements ResultListener,
ResultProducer,
OptionHandler,
AdditionalMeasureProducer {
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected ResultProducer m_ResultProducer = new AveragingResultProducer();
    protected String[] m_AdditionalMeasures = null;
    protected int m_LowerSize = 0;
    protected int m_UpperSize = -1;
    protected int m_StepSize = 10;
    protected int m_CurrentSize = 0;
    public static String STEP_FIELD_NAME = "Total_instances";

    public String globalInfo() {
        return LocalString.get("Tells a sub-ResultProducer to reproduce the current run for ") + LocalString.get("varying sized subsamples of the dataset. Normally used with ") + LocalString.get("an AveragingResultProducer and CrossValidationResultProducer ") + LocalString.get("combo to generate learning curve results.");
    }

    public String[] determineColumnConstraints(ResultProducer resultProducer) throws Exception {
        return null;
    }

    public void doRunKeys(int n) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception(LocalString.get("No ResultProducer set"));
        }
        if (this.m_ResultListener == null) {
            throw new Exception(LocalString.get("No ResultListener set"));
        }
        if (this.m_Instances == null) {
            throw new Exception(LocalString.get("No Instances set"));
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.setInstances(this.m_Instances);
        this.m_CurrentSize = this.m_LowerSize == 0 ? this.m_StepSize : this.m_LowerSize;
        while (this.m_CurrentSize <= this.m_Instances.numInstances() && (this.m_UpperSize == -1 || this.m_CurrentSize <= this.m_UpperSize)) {
            this.m_ResultProducer.doRunKeys(n);
            this.m_CurrentSize += this.m_StepSize;
        }
    }

    public void doRun(int n) throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception(LocalString.get("No ResultProducer set"));
        }
        if (this.m_ResultListener == null) {
            throw new Exception(LocalString.get("No ResultListener set"));
        }
        if (this.m_Instances == null) {
            throw new Exception(LocalString.get("No Instances set"));
        }
        Instances instances = new Instances(this.m_Instances);
        instances.randomize(new Random(n));
        if (instances.classAttribute().isNominal()) {
            instances.stratify(this.m_StepSize);
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_CurrentSize = this.m_LowerSize == 0 ? this.m_StepSize : this.m_LowerSize;
        while (this.m_CurrentSize <= this.m_Instances.numInstances() && (this.m_UpperSize == -1 || this.m_CurrentSize <= this.m_UpperSize)) {
            this.m_ResultProducer.setInstances(new Instances(instances, 0, this.m_CurrentSize));
            this.m_ResultProducer.doRun(n);
            this.m_CurrentSize += this.m_StepSize;
        }
    }

    public void preProcess(ResultProducer resultProducer) throws Exception {
        if (this.m_ResultListener == null) {
            throw new Exception(LocalString.get("No ResultListener set"));
        }
        this.m_ResultListener.preProcess(this);
    }

    public void preProcess() throws Exception {
        if (this.m_ResultProducer == null) {
            throw new Exception(LocalString.get("No ResultProducer set"));
        }
        this.m_ResultProducer.setResultListener(this);
        this.m_ResultProducer.preProcess();
    }

    public void postProcess(ResultProducer resultProducer) throws Exception {
        this.m_ResultListener.postProcess(this);
    }

    public void postProcess() throws Exception {
        this.m_ResultProducer.postProcess();
    }

    public void acceptResult(ResultProducer resultProducer, Object[] objectArray, Object[] objectArray2) throws Exception {
        if (this.m_ResultProducer != resultProducer) {
            throw new Error(LocalString.get("Unrecognized ResultProducer sending results!!"));
        }
        Object[] objectArray3 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        objectArray3[objectArray.length] = new String("" + this.m_CurrentSize);
        this.m_ResultListener.acceptResult(this, objectArray3, objectArray2);
    }

    public boolean isResultRequired(ResultProducer resultProducer, Object[] objectArray) throws Exception {
        if (this.m_ResultProducer != resultProducer) {
            throw new Error(LocalString.get("Unrecognized ResultProducer sending results!!"));
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = new String("" + this.m_CurrentSize);
        return this.m_ResultListener.isResultRequired(this, objectArray2);
    }

    public String[] getKeyNames() throws Exception {
        String[] stringArray = this.m_ResultProducer.getKeyNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = STEP_FIELD_NAME;
        return stringArray2;
    }

    public Object[] getKeyTypes() throws Exception {
        Object[] objectArray = this.m_ResultProducer.getKeyTypes();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        objectArray2[objectArray.length] = "";
        return objectArray2;
    }

    public String[] getResultNames() throws Exception {
        return this.m_ResultProducer.getResultNames();
    }

    public Object[] getResultTypes() throws Exception {
        return this.m_ResultProducer.getResultTypes();
    }

    public String getCompatibilityState() {
        String string = " ";
        string = this.m_ResultProducer == null ? string + LocalString.get("<null ResultProducer>") : string + "-W " + this.m_ResultProducer.getClass().getName();
        string = string + " -- " + this.m_ResultProducer.getCompatibilityState();
        return string.trim();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tThe number of steps in the learning rate curve.\n") + LocalString.get("\t(default 10)"), "X", 1, LocalString.get("-X <num steps>")));
        vector.addElement(new Option(LocalString.get("\tThe full class name of a ResultProducer.\n") + LocalString.get("\teg: weka.experiment.CrossValidationResultProducer"), "W", 1, LocalString.get("-W <class name>")));
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, LocalString.get("\nOptions specific to result producer ") + this.m_ResultProducer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_ResultProducer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setStepSize(Integer.parseInt(string));
        } else {
            this.setStepSize(10);
        }
        String string2 = Utils.getOption('L', stringArray);
        if (string2.length() != 0) {
            this.setLowerSize(Integer.parseInt(string2));
        } else {
            this.setLowerSize(0);
        }
        String string3 = Utils.getOption('U', stringArray);
        if (string3.length() != 0) {
            this.setUpperSize(Integer.parseInt(string3));
        } else {
            this.setUpperSize(-1);
        }
        String string4 = Utils.getOption('W', stringArray);
        if (string4.length() == 0) {
            throw new Exception(LocalString.get("A ResultProducer must be specified with") + LocalString.get(" the -W option."));
        }
        this.setResultProducer((ResultProducer)Utils.forName(ResultProducer.class, string4, null));
        if (this.getResultProducer() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getResultProducer())).setOptions(Utils.partitionOptions(stringArray));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_ResultProducer != null && this.m_ResultProducer instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_ResultProducer)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 9];
        int n = 0;
        stringArray2[n++] = "-S";
        stringArray2[n++] = "" + this.getStepSize();
        stringArray2[n++] = "-L";
        stringArray2[n++] = "" + this.getLowerSize();
        stringArray2[n++] = "-U";
        stringArray2[n++] = "" + this.getUpperSize();
        if (this.getResultProducer() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getResultProducer().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_AdditionalMeasures = stringArray;
        if (this.m_ResultProducer != null) {
            System.err.println(LocalString.get("LearningRateResultProducer: setting additional ") + LocalString.get("measures for ") + "ResultProducer");
            this.m_ResultProducer.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_ResultProducer instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_ResultProducer)).getMeasure(string);
        }
        throw new IllegalArgumentException(LocalString.get("LearningRateResultProducer: ") + LocalString.get("Can't return value for : ") + string + ". " + this.m_ResultProducer.getClass().getName() + " " + LocalString.get("is not an AdditionalMeasureProducer"));
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public String lowerSizeTipText() {
        return LocalString.get("Set the minmum number of instances in a dataset. Setting zero ") + LocalString.get("here will actually use <stepSize> number of instances at the first ") + LocalString.get("step (since it makes no sense to use zero instances :-))");
    }

    public int getLowerSize() {
        return this.m_LowerSize;
    }

    public void setLowerSize(int n) {
        this.m_LowerSize = n;
    }

    public String upperSizeTipText() {
        return LocalString.get("Set the maximum number of instances in a dataset. Setting -1 ") + LocalString.get("sets no upper limit (other than the total number of instances ") + LocalString.get("in the full dataset)");
    }

    public int getUpperSize() {
        return this.m_UpperSize;
    }

    public void setUpperSize(int n) {
        this.m_UpperSize = n;
    }

    public String stepSizeTipText() {
        return LocalString.get("Set the number of instances to add at each step.");
    }

    public int getStepSize() {
        return this.m_StepSize;
    }

    public void setStepSize(int n) {
        this.m_StepSize = n;
    }

    public void setResultListener(ResultListener resultListener) {
        this.m_ResultListener = resultListener;
    }

    public String resultProducerTipText() {
        return LocalString.get("Set the resultProducer for which learning rate results should be ") + "generated.";
    }

    public ResultProducer getResultProducer() {
        return this.m_ResultProducer;
    }

    public void setResultProducer(ResultProducer resultProducer) {
        this.m_ResultProducer = resultProducer;
        this.m_ResultProducer.setResultListener(this);
    }

    public String toString() {
        String string = LocalString.get("LearningRateResultProducer: ");
        string = string + this.getCompatibilityState();
        string = this.m_Instances == null ? string + LocalString.get(": <null Instances>") : string + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return string;
    }
}

