/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.LocalString;
import weka.core.xml.XMLDocument;

public class XMLOptions {
    public static final String TAG_OPTION = "option";
    public static final String TAG_OPTIONS = "options";
    public static final String ATT_NAME = "name";
    public static final String ATT_TYPE = "type";
    public static final String ATT_VALUE = "value";
    public static final String VAL_TYPE_FLAG = "flag";
    public static final String VAL_TYPE_SINGLE = "single";
    public static final String VAL_TYPE_HYPHENS = "hyphens";
    public static final String VAL_TYPE_QUOTES = "quotes";
    public static final String VAL_TYPE_CLASSIFIER = "classifier";
    public static final String ROOT_NODE = "options";
    public static final String DOCTYPE = LocalString.get("<!DOCTYPE ") + "options" + "\n" + "[\n" + LocalString.get("   <!ELEMENT ") + "options" + " (" + "option" + ")*>\n" + LocalString.get("   <!ATTLIST ") + "options" + " " + "type" + LocalString.get(" CDATA \"classifier\">\n") + LocalString.get("   <!ATTLIST ") + "options" + " " + "value" + LocalString.get(" CDATA \"\">\n") + LocalString.get("   <!ELEMENT ") + "option" + LocalString.get(" (#PCDATA | ") + "options" + ")*>\n" + LocalString.get("   <!ATTLIST ") + "option" + " " + "name" + LocalString.get(" CDATA #REQUIRED>\n") + LocalString.get("   <!ATTLIST ") + "option" + " " + "type" + LocalString.get(" (flag | single | hyphens | quotes) \"single\">\n") + "]\n" + ">";
    protected XMLDocument m_XMLDocument = new XMLDocument();

    public XMLOptions() throws Exception {
        this.m_XMLDocument.setRootNode("options");
        this.m_XMLDocument.setDocType(DOCTYPE);
        this.setValidating(true);
    }

    public XMLOptions(String string) throws Exception {
        this();
        this.getXMLDocument().read(string);
    }

    public XMLOptions(File file) throws Exception {
        this();
        this.getXMLDocument().read(file);
    }

    public XMLOptions(InputStream inputStream) throws Exception {
        this();
        this.getXMLDocument().read(inputStream);
    }

    public XMLOptions(Reader reader) throws Exception {
        this();
        this.getXMLDocument().read(reader);
    }

    public boolean getValidating() {
        return this.m_XMLDocument.getValidating();
    }

    public void setValidating(boolean bl) throws Exception {
        this.m_XMLDocument.setValidating(bl);
    }

    public Document getDocument() {
        return this.fixHyphens(this.m_XMLDocument.getDocument());
    }

    public XMLDocument getXMLDocument() {
        return this.m_XMLDocument;
    }

    protected Document fixHyphens(Document document) {
        int n;
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(TAG_OPTION);
        Vector<Node> vector = new Vector<Node>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!((Element)nodeList.item(n)).getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) continue;
            vector.add(nodeList.item(n));
        }
        for (n = 0; n < vector.size(); ++n) {
            Node node = (Node)vector.get(n);
            boolean bl = true;
            Node node2 = node;
            while (node2.getNextSibling() != null) {
                if (node2.getNextSibling().getNodeType() == 1) {
                    bl = false;
                    break;
                }
                node2 = node2.getNextSibling();
            }
            if (bl) continue;
            node2 = node.getParentNode();
            node2.removeChild(node);
            node2.appendChild(node);
        }
        return document;
    }

    protected int getQuotesLevel(Node node) {
        int n = 0;
        while (node.getParentNode() != null) {
            if (!(node instanceof Element)) continue;
            if (node.getNodeName().equals(TAG_OPTION) && ((Element)node).getAttribute(ATT_TYPE).equals(VAL_TYPE_QUOTES)) {
                ++n;
            }
            node = node.getParentNode();
        }
        return n;
    }

    protected String toCommandLine(String string, Element element, int n) {
        String string2 = "";
        if (element.getNodeName().equals("options")) {
            if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_CLASSIFIER)) {
                string2 = string2 + element.getAttribute(ATT_VALUE);
            }
            Vector vector = XMLDocument.getChildTags(element);
            for (int i = 0; i < vector.size(); ++i) {
                string2 = this.toCommandLine(string2, (Element)vector.get(i), n + 1);
            }
        } else if (element.getNodeName().equals(TAG_OPTION)) {
            string2 = string2 + " -" + element.getAttribute(ATT_NAME);
            Vector vector = XMLDocument.getChildTags(element);
            NodeList nodeList = element.getChildNodes();
            if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_SINGLE)) {
                if (nodeList.getLength() > 0 && !nodeList.item(0).getNodeValue().trim().equals("")) {
                    string2 = string2 + " " + nodeList.item(0).getNodeValue().trim();
                }
            } else if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_HYPHENS)) {
                string2 = string2 + " " + ((Element)vector.get(0)).getAttribute(ATT_VALUE);
                vector = XMLDocument.getChildTags((Element)vector.get(0));
                String string3 = "";
                for (int i = 0; i < vector.size(); ++i) {
                    string3 = this.toCommandLine(string3, (Element)vector.get(i), n + 1);
                }
                if (!(string3 = string3.trim()).equals("")) {
                    string2 = string2 + " -- " + string3;
                }
            } else if (element.getAttribute(ATT_TYPE).equals(VAL_TYPE_QUOTES)) {
                int n2;
                string2 = string2 + " ";
                for (n2 = 1; n2 < this.getQuotesLevel(element); ++n2) {
                    string2 = string2 + "\\";
                }
                string2 = string2 + "\"";
                String string4 = "";
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    string4 = this.toCommandLine(string4, (Element)vector.get(n2), n + 1);
                }
                string2 = string2 + string4.trim();
                for (n2 = 1; n2 < this.getQuotesLevel(element); ++n2) {
                    string2 = string2 + "\\";
                }
                string2 = string2 + "\"";
            }
        }
        string = string + " " + string2.trim();
        return string.trim();
    }

    public String toCommandLine() throws Exception {
        return this.toCommandLine(new String(), this.getDocument().getDocumentElement(), 0);
    }

    public String[] toArray() throws Exception {
        String string = this.toCommandLine();
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            boolean bl3 = true;
            switch (string.charAt(i)) {
                case '\\': {
                    bl2 = true;
                    break;
                }
                case '\"': {
                    if (!bl2) {
                        bl = !bl;
                        bl3 = false;
                    }
                    bl2 = false;
                    break;
                }
                case ' ': {
                    if (bl) break;
                    vector.add(string2.replaceAll("\\\\\"", "\""));
                    bl3 = false;
                    string2 = "";
                }
            }
            if (!bl3) continue;
            string2 = string2 + "" + string.charAt(i);
        }
        if (!string2.equals("")) {
            vector.add(string2);
        }
        return vector.toArray(new String[1]);
    }

    public String toString() {
        return this.getXMLDocument().toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            System.out.println("\nXML:\n\n" + new XMLOptions(stringArray[0]).toString());
            System.out.println("\nCommandline:\n\n" + new XMLOptions(stringArray[0]).toCommandLine());
            System.out.println(LocalString.get("\nString array:\n"));
            String[] stringArray2 = new XMLOptions(stringArray[0]).toArray();
            for (int i = 0; i < stringArray2.length; ++i) {
                System.out.println(stringArray2[i]);
            }
        }
    }
}

