/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import weka.LocalString;
import weka.core.xml.KOML;

public class SerialUIDChanger {
    protected static boolean checkKOML() throws Exception {
        if (!KOML.isPresent()) {
            throw new Exception(LocalString.get("KOML is not present!"));
        }
        return true;
    }

    public static boolean isKOML(String string) {
        return string.toLowerCase().endsWith(".koml");
    }

    protected static Object readBinary(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    protected static void writeBinary(String string, Object object) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
        objectOutputStream.writeObject(object);
        objectOutputStream.close();
    }

    public static void binaryToKOML(String string, String string2) throws Exception {
        SerialUIDChanger.checkKOML();
        Object object = SerialUIDChanger.readBinary(string);
        if (object == null) {
            throw new Exception(LocalString.get("Failed to deserialize object from binary file '") + string + "'!");
        }
        KOML.write(string2, object);
    }

    public static void komlToBinary(String string, String string2) throws Exception {
        SerialUIDChanger.checkKOML();
        Object object = KOML.read(string);
        if (object == null) {
            throw new Exception(LocalString.get("Failed to deserialize object from XML file '") + string + "'!");
        }
        SerialUIDChanger.writeBinary(string2, object);
    }

    public static void changeUID(long l, long l2, String string, String string2) throws Exception {
        String string3;
        String string4;
        if (!SerialUIDChanger.isKOML(string)) {
            string4 = string + ".koml";
            SerialUIDChanger.binaryToKOML(string, string4);
        } else {
            string4 = string;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
        String string5 = "";
        while ((string3 = bufferedReader.readLine()) != null) {
            if (!string5.equals("")) {
                string5 = string5 + "\n";
            }
            string5 = string5 + string3;
        }
        bufferedReader.close();
        string5 = string5.replaceAll(LocalString.get(" uid='") + Long.toString(l) + "'", LocalString.get(" uid='") + Long.toString(l2) + "'");
        String string6 = string4 + ".temp";
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string6));
        bufferedWriter.write(string5);
        bufferedWriter.flush();
        bufferedWriter.close();
        if (!SerialUIDChanger.isKOML(string2)) {
            SerialUIDChanger.komlToBinary(string6, string2);
        } else {
            bufferedWriter = new BufferedWriter(new FileWriter(string2));
            bufferedWriter.write(string5);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        File file = new File(string6);
        file.delete();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 4) {
            System.out.println();
            System.out.println(LocalString.get("Usage: ") + SerialUIDChanger.class.getName() + LocalString.get(" <oldUID> <newUID> <oldFilename> <newFilename>"));
            System.out.println(LocalString.get("       <oldFilename> and <newFilename> have to be different"));
            System.out.println();
        } else {
            if (stringArray[2].equals(stringArray[3])) {
                throw new Exception(LocalString.get("Filenames have to be different!"));
            }
            SerialUIDChanger.changeUID(Long.parseLong(stringArray[0]), Long.parseLong(stringArray[1]), stringArray[2], stringArray[3]);
        }
    }
}

