/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.LocalString;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.trees.REPTree;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class Bagging
extends RandomizableIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
AdditionalMeasureProducer {
    protected int m_BagSizePercent = 100;
    protected boolean m_CalcOutOfBag = false;
    protected double m_OutOfBagError;

    public String globalInfo() {
        return LocalString.get("Class for bagging a classifier to reduce variance. Can do classification ") + LocalString.get("and regression depending on the base learner. For more information, see\n\n") + LocalString.get("Leo Breiman (1996). \"Bagging predictors\". Machine ") + LocalString.get("Learning, 24(2):123-140.");
    }

    public Bagging() {
        this.m_Classifier = new REPTree();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.REPTree";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option(LocalString.get("\tSize of each bag, as a percentage of the\n") + LocalString.get("\ttraining set size. (default 100)"), "P", 1, "-P"));
        vector.addElement(new Option(LocalString.get("\tCalculate the out of bag error."), "O", 0, "-O"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setBagSizePercent(Integer.parseInt(string));
        } else {
            this.setBagSizePercent(100);
        }
        this.setCalcOutOfBag(Utils.getFlag('O', stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[stringArray.length + 3];
        int n = 0;
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.getBagSizePercent();
        if (this.getCalcOutOfBag()) {
            stringArray2[n++] = "-O";
        }
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String bagSizePercentTipText() {
        return LocalString.get("Size of each bag, as a percentage of the training set size.");
    }

    public int getBagSizePercent() {
        return this.m_BagSizePercent;
    }

    public void setBagSizePercent(int n) {
        this.m_BagSizePercent = n;
    }

    public String calcOutOfBagTipText() {
        return LocalString.get("Whether the out-of-bag error is calculated.");
    }

    public void setCalcOutOfBag(boolean bl) {
        this.m_CalcOutOfBag = bl;
    }

    public boolean getCalcOutOfBag() {
        return this.m_CalcOutOfBag;
    }

    public double measureOutOfBagError() {
        return this.m_OutOfBagError;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureOutOfBagError");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equalsIgnoreCase("measureOutOfBagError")) {
            return this.measureOutOfBagError();
        }
        throw new IllegalArgumentException(string + LocalString.get(" not supported (Bagging)"));
    }

    public final Instances resampleWithWeights(Instances instances, Random random, boolean[] blArray) {
        int n;
        double[] dArray = new double[instances.numInstances()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = instances.instance(i).weight();
        }
        Instances instances2 = new Instances(instances, instances.numInstances());
        if (instances.numInstances() == 0) {
            return instances2;
        }
        double[] dArray2 = new double[instances.numInstances()];
        double d = 0.0;
        double d2 = Utils.sum(dArray);
        for (n = 0; n < instances.numInstances(); ++n) {
            dArray2[n] = d += random.nextDouble();
        }
        Utils.normalize(dArray2, d / d2);
        dArray2[instances.numInstances() - 1] = d2;
        n = 0;
        d = 0.0;
        for (int i = 0; n < instances.numInstances() && i < instances.numInstances(); ++i) {
            if (dArray[i] < 0.0) {
                throw new IllegalArgumentException(LocalString.get("Weights have to be positive."));
            }
            d += dArray[i];
            while (n < instances.numInstances() && dArray2[n] <= d) {
                instances2.add(instances.instance(i));
                blArray[i] = true;
                instances2.instance(n).setWeight(1.0);
                ++n;
            }
        }
        return instances2;
    }

    public void buildClassifier(Instances instances) throws Exception {
        super.buildClassifier(instances);
        if (this.m_CalcOutOfBag && this.m_BagSizePercent != 100) {
            throw new IllegalArgumentException(LocalString.get("Bag size needs to be 100% if ") + LocalString.get("out-of-bag error is to be calculated!"));
        }
        double d = 0.0;
        double d2 = 0.0;
        int n = instances.numInstances() * this.m_BagSizePercent / 100;
        Random random = new Random(this.m_Seed);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            Instances instances2 = null;
            boolean[] blArray = null;
            if (this.m_CalcOutOfBag) {
                blArray = new boolean[instances.numInstances()];
                instances2 = this.resampleWithWeights(instances, random, blArray);
            } else {
                instances2 = instances.resampleWithWeights(random);
                if (n < instances.numInstances()) {
                    Instances instances3;
                    instances2.randomize(random);
                    instances2 = instances3 = new Instances(instances2, 0, n);
                }
            }
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            }
            this.m_Classifiers[i].buildClassifier(instances2);
            if (!this.m_CalcOutOfBag) continue;
            for (int j = 0; j < blArray.length; ++j) {
                if (blArray[j]) continue;
                Instance instance = instances.instance(j);
                d += instance.weight();
                if (instances.classAttribute().isNumeric()) {
                    d2 += instance.weight() * Math.abs(this.m_Classifiers[i].classifyInstance(instance) - instance.classValue());
                    continue;
                }
                if (this.m_Classifiers[i].classifyInstance(instance) == instance.classValue()) continue;
                d2 += instance.weight();
            }
        }
        this.m_OutOfBagError = d2 / d;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (instance.classAttribute().isNumeric()) {
                dArray[0] = dArray[0] + this.m_Classifiers[i].classifyInstance(instance);
                continue;
            }
            double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            dArray[0] = dArray[0] / (double)this.m_NumIterations;
            return dArray;
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return LocalString.get("Bagging: No model built yet.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("All the base classifiers: \n\n"));
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        if (this.m_CalcOutOfBag) {
            stringBuffer.append(LocalString.get("Out of bag error: ") + Utils.doubleToString(this.m_OutOfBagError, 4) + "\n\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new Bagging(), stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

