/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import java.io.Serializable;
import weka.LocalString;
import weka.classifiers.evaluation.Prediction;

public class NominalPrediction
implements Prediction,
Serializable {
    static final long serialVersionUID = -8871333992740492788L;
    private double[] m_Distribution;
    private double m_Actual = MISSING_VALUE;
    private double m_Predicted = MISSING_VALUE;
    private double m_Weight = 1.0;

    public NominalPrediction(double d, double[] dArray) {
        this(d, dArray, 1.0);
    }

    public NominalPrediction(double d, double[] dArray, double d2) {
        if (dArray == null) {
            throw new NullPointerException(LocalString.get("Null distribution in NominalPrediction."));
        }
        this.m_Actual = d;
        this.m_Distribution = dArray;
        this.m_Weight = d2;
        this.updatePredicted();
    }

    public double[] distribution() {
        return this.m_Distribution;
    }

    public double actual() {
        return this.m_Actual;
    }

    public double predicted() {
        return this.m_Predicted;
    }

    public double weight() {
        return this.m_Weight;
    }

    public double margin() {
        if (this.m_Actual == MISSING_VALUE || this.m_Predicted == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        double d = this.m_Distribution[(int)this.m_Actual];
        double d2 = 0.0;
        for (int i = 0; i < this.m_Distribution.length; ++i) {
            if ((double)i == this.m_Actual || !(this.m_Distribution[i] > d2)) continue;
            d2 = this.m_Distribution[i];
        }
        return d - d2;
    }

    public static double[] makeDistribution(double d, int n) {
        double[] dArray = new double[n];
        if (d == MISSING_VALUE) {
            return dArray;
        }
        dArray[(int)d] = 1.0;
        return dArray;
    }

    public static double[] makeUniformDistribution(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0 / (double)n;
        }
        return dArray;
    }

    private void updatePredicted() {
        int n = -1;
        double d = 0.0;
        for (int i = 0; i < this.m_Distribution.length; ++i) {
            if (!(this.m_Distribution[i] > d)) continue;
            n = i;
            d = this.m_Distribution[i];
        }
        this.m_Predicted = n != -1 ? (double)n : MISSING_VALUE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LocalString.get("NOM: ")).append(this.actual()).append(" ").append(this.predicted());
        stringBuffer.append(' ').append(this.weight());
        double[] dArray = this.distribution();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(' ').append(dArray[i]);
        }
        return stringBuffer.toString();
    }
}

