/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import java.util.Enumeration;
import weka.LocalString;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class ComplementNaiveBayes
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    private double[][] wordWeights;
    private double smoothingParameter = 1.0;
    private boolean m_normalizeWordWeights = false;
    private int numClasses;
    private Instances header;

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector(2);
        fastVector.addElement(new Option(LocalString.get("\tNormalize the word weights for each class\n"), "N", 0, "-N"));
        fastVector.addElement(new Option(LocalString.get("\tSmoothing value to avoid zero WordGivenClass") + LocalString.get(" probabilities (default=1.0).\n"), "S", 1, "-S"));
        return fastVector.elements();
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        if (this.getNormalizeWordWeights()) {
            stringArray[n++] = "-N";
        }
        stringArray[n++] = "-S";
        stringArray[n++] = Double.toString(this.smoothingParameter);
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setNormalizeWordWeights(Utils.getFlag('N', stringArray));
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSmoothingParameter(Double.parseDouble(string));
        }
    }

    public boolean getNormalizeWordWeights() {
        return this.m_normalizeWordWeights;
    }

    public void setNormalizeWordWeights(boolean bl) {
        this.m_normalizeWordWeights = bl;
    }

    public String normalizeWordWeightsTipText() {
        return LocalString.get("Normalizes the word weights for each class.");
    }

    public double getSmoothingParameter() {
        return this.smoothingParameter;
    }

    public void setSmoothingParameter(double d) {
        this.smoothingParameter = d;
    }

    public String smoothingParameterTipText() {
        return LocalString.get("Sets the smoothing parameter to avoid zero WordGivenClass ") + LocalString.get("probabilities (default=1.0).");
    }

    public String globalInfo() {
        return LocalString.get("Class for building and using a Complement class Naive Bayes ") + LocalString.get("classifier. For more information see, \n") + LocalString.get("ICML-2003 \"Tackling the poor assumptions of Naive Bayes ") + LocalString.get("Text Classifiers\" \n") + LocalString.get("P.S.: TF, IDF and length normalization transforms, as ") + LocalString.get("described in the paper, can be performed through ") + "weka.filters.unsupervised.StringToWordVector.";
    }

    public void buildClassifier(Instances instances) throws Exception {
        double d;
        int n;
        this.numClasses = instances.numClasses();
        int n2 = instances.numAttributes();
        for (int i = 0; i < this.numClasses; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (instances.classIndex() == j) {
                    if (instances.attribute(j).isNominal()) continue;
                    throw new Exception(LocalString.get("ComplementNaiveBayes cannot ") + LocalString.get("handle non-nominal class attribute"));
                }
                if (instances.attribute(j).isNumeric()) continue;
                throw new Exception(LocalString.get("Attribute ") + instances.attribute(j).name() + LocalString.get(" is not numeric! ") + LocalString.get("ComplementNaiveBayes requires ") + LocalString.get("that all attributes (except the ") + LocalString.get("class attribute) are numeric."));
            }
        }
        this.header = new Instances(instances, 0);
        double[][] dArray = new double[this.numClasses][n2];
        this.wordWeights = new double[this.numClasses][n2];
        double[] dArray2 = new double[this.numClasses];
        double d2 = 0.0;
        double d3 = (double)(n2 - 1) * this.smoothingParameter;
        int n3 = instances.instance(0).classIndex();
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            int n4 = (int)instance.value(n3);
            for (n = 0; n < instance.numValues(); ++n) {
                if (instance.index(n) == instance.classIndex() || instance.isMissing(n)) continue;
                double d4 = instance.valueSparse(n) * instance.weight();
                if (d4 < 0.0) {
                    throw new Exception(LocalString.get("Numeric attribute") + LocalString.get(" values must all be greater") + LocalString.get(" or equal to zero."));
                }
                d2 += d4;
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + d4;
                double[] dArray3 = dArray[n4];
                int n6 = instance.index(n);
                dArray3[n6] = dArray3[n6] + d4;
                double[] dArray4 = this.wordWeights[0];
                int n7 = instance.index(n);
                dArray4[n7] = dArray4[n7] + d4;
            }
        }
        for (n = 1; n < this.numClasses; ++n) {
            d = d2 - dArray2[n];
            for (int i = 0; i < n2; ++i) {
                if (i == n3) continue;
                double d5 = this.wordWeights[0][i] - dArray[n][i];
                this.wordWeights[n][i] = Math.log((d5 + this.smoothingParameter) / (d + d3));
            }
        }
        for (n = 0; n < n2; ++n) {
            if (n == n3) continue;
            d = this.wordWeights[0][n] - dArray[0][n];
            double d6 = d2 - dArray2[0];
            this.wordWeights[0][n] = Math.log((d + this.smoothingParameter) / (d6 + d3));
        }
        if (this.m_normalizeWordWeights) {
            for (n = 0; n < this.numClasses; ++n) {
                int n8;
                d = 0.0;
                for (n8 = 0; n8 < n2; ++n8) {
                    if (n8 == n3) continue;
                    d += Math.abs(this.wordWeights[n][n8]);
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    if (n8 == n3) continue;
                    this.wordWeights[n][n8] = this.wordWeights[n][n8] / d;
                }
            }
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        int n;
        if (this.wordWeights == null) {
            throw new Exception(LocalString.get("Error. The classifier has not been built ") + "properly.");
        }
        double[] dArray = new double[this.numClasses];
        double d = 0.0;
        for (n = 0; n < this.numClasses; ++n) {
            double d2 = 0.0;
            for (int i = 0; i < instance.numValues(); ++i) {
                if (instance.index(i) == instance.classIndex()) continue;
                double d3 = instance.valueSparse(i);
                d2 += d3 * this.wordWeights[n][instance.index(i)];
            }
            dArray[n] = d2;
            d += dArray[n];
        }
        n = 0;
        for (int i = 0; i < this.numClasses; ++i) {
            if (!(dArray[i] < dArray[n])) continue;
            n = i;
        }
        return n;
    }

    public String toString() {
        int n;
        if (this.wordWeights == null) {
            return LocalString.get("The classifier hasn't been built yet.");
        }
        int n2 = this.header.numAttributes();
        StringBuffer stringBuffer = new StringBuffer(LocalString.get("The word weights for each class are: \n") + "------------------------------------\n\t");
        for (n = 0; n < this.numClasses; ++n) {
            stringBuffer.append(this.header.classAttribute().value(n)).append("\t");
        }
        stringBuffer.append("\n");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.header.attribute(n).name()).append("\t");
            for (int i = 0; i < this.numClasses; ++i) {
                stringBuffer.append(Double.toString(this.wordWeights[i][n])).append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new ComplementNaiveBayes(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

