/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y;
            if ((this.style & 0x400) != 0) {
                rECT.bottom = rectangle.y + rectangle.height - this.tabsHeight;
            } else {
                rECT.top += this.tabsHeight;
                rECT.bottom = rectangle.y + rectangle.height;
            }
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground(n, gC.handle, nArray[0], nArray[1], rECT, null);
            OS.CloseThemeData(n);
            if (this.tabsArea != null) {
                this.tabsArea.x = rectangle.x;
                this.tabsArea.y = rectangle.y;
                this.tabsArea.width = rectangle.width;
                this.tabsArea.height = this.tabsHeight;
                if ((this.style & 0x400) != 0) {
                    this.tabsArea.y += rectangle.height - this.tabsHeight;
                }
            }
        }
    }

    @Override
    char[] getClassId() {
        return TAB;
    }

    @Override
    int[] getPartId(int n) {
        int n2 = this.state[n];
        int n3 = 9;
        int n4 = 1;
        if ((n2 & 0x20) != 0) {
            n4 = 4;
        } else {
            if ((n2 & 0x40) != 0) {
                n4 = 2;
            }
            if ((n2 & 2) != 0) {
                n4 = 3;
            }
        }
        return new int[]{n3, n4};
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        return 0;
    }
}

