// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package pdb;

/**
  Secondary structure information written in pdb files.
  Available secondary structure names are listed in `SecondaryType.hx`.
**/

class PdbSecondary {
  /**
    read HELIX record from text and parse it.
  **/
  static public function readHelixFromText( text:String ):PdbSecondary {
    var i:Int = Std.parseInt( text.substr( 21, 4 ) );
    var l:Int = Std.parseInt( text.substr( 33, 4 ) );
    var c:String = text.substr( 19, 1 );
    return( new PdbSecondary( i, l, c, SecondaryType.HELIX_ALPHA ) );
  }

  /**
    read SHEET record from text and parse it.
  **/
  static public function readStrandFromText( text:String ):PdbSecondary {
    var i:Int = Std.parseInt( text.substr( 22, 4 ) );
    var l:Int = Std.parseInt( text.substr( 33, 4 ) );
    var c:String = text.substr( 21, 1 );
    return( new PdbSecondary( i, l, c, SecondaryType.STRAND ) );
  }

  // #####################################################################
  /**
    first index of this secondary structure
  **/
  @:isVar public var init( get, set ):Int;
    /**
      getter of `init`
    **/
    public function get_init():Int { return( init ); }
    /**
      setter of `init`
    **/
    public function set_init( i:Int ):Int { init = i; return( init ); }
  /**
    last index of this secondary structure
  **/
  @:isVar public var last( get, set ):Int;
    /**
      getter of `last`
    **/
    public function get_last():Int { return( last ); }
    /**
      setter of `last`
    **/
    public function set_last( l:Int ):Int { last = l; return( last ); }
  /**
    secondary structure type. See `SecondaryType.hx` for details.
  **/
  @:isVar public var sectype( get, set ):Int;
    /**
      getter of `sectype`
    **/
    public function get_sectype():Int { return( sectype ); }
    /**
      setter of `sectype`
    **/
    public function set_sectype( t:Int ):Int {
      sectype = t;
      return( sectype );
    }
  /**
    chain id of this secondary structure
  **/
  @:isVar public var chainid( get, set ):String;
    /**
      getter of `chainid`
    **/
    public function get_chainid():String { return( chainid ); }
    /**
      setter of `chainid`
    **/
    public function set_chainid( i:String ):String { chainid = i; return( chainid ); }

  // ########################################################################

  /**
    Constructor.

    - i: first residue index of this secondary structure
    - l: last residue index of this secondary structure
    - c: chain id of this secondary structure
    - st: secondary structure type
  **/
  public function new( ?i:Int,
                       ?l:Int,
                       ?c:String,
                       ?st:Int ) {
    if ( i != null ) init = i;
    if ( l != null ) last = l;
    if ( c != null ) chainid = c;
    if ( st != null ) sectype = st;
  }
}
