// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2014, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.events.TimerEvent;
import flash.utils.Timer;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.system.Worker;

class Main {
  /**
    minimum flash player major version required for wm3d.
    Value for current wm3d version is 11. (wm3d requires version >= 11.0)
  **/
  static public var minimum_major:Int = 11;
  /**
    minimum flash player minor version required for wm3d.
    Value for current wm3d version is 0. (wm3d requires version >= 11.0)
  **/
  static public var minimum_minor:Int = 0;
  //static public var minimum_minor:Int = 2;

  static public var _this:Main;
  private var _timer:Timer;
  public var wm:Watermelon;

  static function main() {
    _this = new Main();
  }

  /**
    check whether flash player version is equal or newer than
    given version: `version_major`.`version_minor`.
  **/
  static public function checkVersion( version_major:Int,
                                       version_minor:Int ):Bool {
    var platform_version:Array< String > = flash.system.Capabilities.version.split( " " );
    // assume platform_version must have two elements
    // otherwise, assume it's OK
    if ( platform_version.length >= 2 ) {
      var version:Array< String > = platform_version[1].split(",");
      if ( version.length >= 2 ) {
        var major:Int = Std.parseInt( version[0] );
        var minor:Int = Std.parseInt( version[1] );
        if ( major <= version_major && minor < version_minor ) {
          return( false );
        }
      }
    }
    return( true );
  }

  //// some common specific versions checker
  // is right click available? ( 11.2 or later )
  /**
    check if version >= 11.2
  **/
  static public function checkVersionRightClick():Bool {
    return( Main.checkVersion( 11, 2 ) );
  }

  // is worker available version? ( 11.4 or later )
  /**
    check if version >= 11.4
  **/
  static public function checkVersionWorker():Bool {
    //return( false );
    if ( Main.checkVersion( 11, 4 ) ) {
      if ( Worker.isSupported ) return( true );
    }
    return( false );
  }

  /**
    show "please update player" message on the stage
  **/
  static function pleaseUpdatePlayer( major:Int,
                                      minor:Int ) {
    var ret:TextField = new TextField();
    ret.width = flash.Lib.current.stage.stageWidth;
    ret.text = "Please update flash player to\n version " +
               Std.string( minimum_major ) + "." + Std.string( minimum_minor ) +
               " or later.\n\n" +
               "Version of this player is " +
               Std.string( major ) + "." + Std.string( minor ) + ".";
    ret.selectable = false;
    ret.autoSize = flash.text.TextFieldAutoSize.CENTER;
    ret.setTextFormat( new TextFormat( "Arial", 12, 0x000000, true, null, null, null, flash.text.TextFormatAlign.CENTER ) );
    ret.y = flash.Lib.current.stage.stageHeight / 2.0;
    flash.Lib.current.stage.addChild( ret );
  }

  // ######################################################################33
  private function new() {
    _timer = new Timer( 40 );
    _timer.addEventListener( TimerEvent.TIMER, isReady );
    _timer.start();
  }

  private function isReady( ?e:TimerEvent = null ):Void {
    if ( flash.Lib.current.stage != null ) {
      if ( Std.is( flash.Lib.current.stage.stageWidth, Int ) &&
           Std.is( flash.Lib.current.stage.stageHeight, Int ) ) {
        _timer.stop();
        if ( Main.checkVersion( minimum_major, minimum_minor ) ) {
          wm = new Watermelon();
        } else {
          Main.pleaseUpdatePlayer( minimum_major, minimum_minor );
        }
      }
    }
  }
}
