// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib.shaders;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

/**
  Phong Shader with depth cueing
**/

class PhongShaderDC extends hxsl.Shader {
  static public var id:String = "PhongShader";
  static var SRC = {
    include( 'tinylib/shaders/srcNoUV.hxsl' );
    var position:Float3;
    var normal:Float3;
    include( 'tinylib/shaders/vertexPhong.hxsl' );
    function fragment( light:Float3,
                       cpos:Float3,
                       ambient:Float,
                       diffuse:Float,
                       specular:Float,
                       gloss:Float,
                       col:Float3,
                       alpha:Float,
                       dc:Float,
                       dclength:Float ) {
      var tnorm = normalize( normal );
      var lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      // specular using half vector
      var view = normalize( sub( cpos, position ) );
      var half_tnorm = dot( tnorm, normalize( add( light, view ) ) );
      var spow = ( half_tnorm >= 0.0 ) * specular * pow( max( 0, half_tnorm ), gloss );
      var x = spow + col.x * lpow;
      var y = spow + col.y * lpow;
      var z = spow + col.z * lpow;
      var dccoeff = saturate( exp( -dc * ( position.z - dclength ) ) );
      out = [ x * dccoeff, y * dccoeff, z * dccoeff, alpha ];
    }
  };
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      vo:Vector3D,
                                      lt:Vector3D,
                                      cp:Vector3D,
                                      am:Float,
                                      df:Float,
                                      sp:Float,
                                      gl:Float,
                                      cl:Vector3D,
                                      a:Float,
                                      d:Float,
                                      dl:Float ) {
    this.mpos = mp;
    this.mproj = mpro;
    this.offset = vo;
    this.light = lt;
    this.cpos = cp;
    this.ambient = am;
    this.diffuse = df;
    this.specular = sp;
    this.gloss = gl;
    this.col = cl;
    this.alpha = a;
    this.dc = d;
    this.dclength = dl;
  }
}
