// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package pdb;

/**
  Container for static variables for backbone hydrogen bond.
  Some of them come from STRIDE
**/

class HBParams {
  /**
    distance between N and H; used when generating position of H
  **/
  static public var NH_dist( default, null ) = 1.10;

  /**
    hydrogen bond length (between N and O) in angstrom
  **/
  static public var HB_dist( default, null ) = 3.0;

  /**
    hydrogen bond reference energy in kcal/mol
  **/
  static public var HB_ene( default, null ) = -2.8;

  /**
    threshold of alpha-helix; smaller values mean strict threshold
  **/
  static public var threshold_hA( default, null ) = -1.8;
  /**
    threshold of 3-10 helix; smaller values mean strict threshold
  **/
  static public var threshold_h3( default, null ) = -1.6;
  /**
    threshold of pi helix; smaller values mean strict threshold
  **/
  static public var threshold_hP( default, null ) = -1.4;
  /**
    threshold of beta strand; smaller values mean strict threshold
  **/
  static public var threshold_s( default, null ) = -1.8;
}
