// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.geom.Vector3D;
import flash.geom.Matrix3D;
import flash.display3D.textures.Texture;

class Shader2DUV extends hxsl.Shader {
  static public var id:String = "2DShaderUV";
  static var SRC = {
    var input : {
      pos:Float3,
      uv:Float2,
    }
    var tuv:Float2;
    function vertex( mpos:M44,
                     mproj:M44,
                     origin:Float4 ) {
      var p4:Float4 = [ input.pos.x, input.pos.y, input.pos.z, 0.0 ];
      out = origin.xyzw * mpos * mproj + p4;
      tuv = input.uv;
    }
    function fragment( tex:Texture ) {
      out = tex.get( tuv );
    }
  }
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      vo:Vector3D,
                                      texture:Texture ) {
    this.mpos = mp; 
    this.mproj = mpro;
    this.origin = vo;
    this.tex = texture;
  }
}
