// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

class UVCoord {
  static public function getMiddle( uv0:UVCoord,
                                    uv1:UVCoord ):UVCoord {
    var ret:UVCoord = new UVCoord();
    ret.u = 0.5 * ( uv0.u + uv1.u );
    ret.v = 0.5 * ( uv0.v + uv1.u );
    return( ret );
  }

  // ########################################################

  @:isVar public var u( get, set ):Float;
    public function get_u():Float { return( u ); }
    public function set_u( f:Float ):Float {
      u = validValue( f );
      return( u );
    }
  @:isVar public var v( get, set ):Float;
    public function get_v():Float { return( v ); }
    public function set_v( f:Float ):Float {
      v = validValue( f );
      return( v );
    }

  // ########################################################

  public function new( ?x:Float = 0.0,
                       ?y:Float = 0.0 ) {
    u = x;
    v = y;
  }

  public function clear() {
    u = v = 0.0;
  }

  public function clone():UVCoord {
    return( new UVCoord( u, v ) );
  }

  // limit range of value to 0.0-1.0
  private function validValue( f:Float ):Float {
    var ret:Float = Math.min( 1.0, f );
    ret = Math.max( 0.0, ret );
    return( ret );
  }

  public function toString():String {
    return( "[ " + u + " " + v + " ]" );
  }
}
