// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// common data of a residue (amino acids, water, lipids, ions, ...)

class ResidueBase {
  @:isVar public var index( get, set ):Int;
    public function get_index():Int { return( index ); }
    public function set_index( i:Int ):Int {
      index = i;
      return( index );
    }
  @:isVar public var isNterm( get, set ):Bool;
    public function get_isNterm():Bool { return( isNterm ); }
    public function set_isNterm( b:Bool ):Bool {
      isNterm = b;
      return( isNterm );
    }
  @:isVar public var isCterm( get, set ):Bool;
    public function get_isCterm():Bool { return( isCterm ); }
    public function set_isCterm( b:Bool ):Bool {
      isCterm = b;
      return( isCterm );
    }
  @:isVar public var name( get, set ):String;
    public function get_name():String { return( name ); }
    public function set_name( s:String ):String {
      name = s;
      return( name );
    }

  //-------------------------------------------------------------------------

  public function new( ?n:String = "",
                       ?i:Int = -1,
                       ?isnt:Bool = false,
                       ?isct:Bool = false ) {
    name = n;
    index = i;
    isNterm = isnt;
    isCterm = isct;
  }
}
