// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.display.Sprite;
import flash.display.Stage;

import flash.text.TextField;
import flash.text.TextFormat;

import flash.events.Event;
import flash.events.MouseEvent;

class WMEdit extends Sprite {
  private var wm:Watermelon;

  // background
  @:isVar public var bgColor( get, set ):Int;
    public function get_bgColor():Int { return( bgColor ); }
    public function set_bgColor( c:Int ):Int {
      bgColor = c;
      return( bgColor );
    }

  @:isVar public var bgAlpha( get, set ):Float;
    public function get_bgAlpha():Float { return( bgAlpha ); }
    public function set_bgAlpha( a:Float ):Float {
      bgAlpha = a;
      return( bgAlpha );
    }

  // font
  @:isVar public var fontname( get, set ):String;
    public function get_fontname():String { return( fontname ); }
    public function set_fontname( f:String ):String {
      fontname = f;
      return( fontname );
    }

  @:isVar public var fontsizemain( get, set ):Float;
    public function get_fontsizemain():Float { return( fontsizemain ); }
    public function set_fontsizemain( s:Float ):Float {
      fontsizemain = s;
      return( fontsizemain );
    }

  @:isVar public var fontsizebutton( get, set ):Float;
    public function get_fontsizebutton():Float { return( fontsizebutton ); }
    public function set_fontsizebutton( s:Float ):Float {
      fontsizebutton = s;
      return( fontsizebutton );
    }

  @:isVar public var fontcolormain( get, set ):Int;
    public function get_fontcolormain():Int { return( fontcolormain ); }
    public function set_fontcolormain( c:Int ):Int {
      fontcolormain = c;
      return( fontcolormain );
    }

  @:isVar public var fontcolorbutton( get, set ):Int;
    public function get_fontcolorbutton():Int { return( fontcolorbutton ); }
    public function set_fontcolorbutton( c:Int ):Int {
      fontcolorbutton = c;
      return( fontcolorbutton );
    }

  // textfield window size
  @:isVar public var ratio_windowsize_x( get, set ):Float;
    public function get_ratio_windowsize_x():Float { return( ratio_windowsize_x ); }
    public function set_ratio_windowsize_x( r:Float ):Float {
      ratio_windowsize_x = r;
      return( ratio_windowsize_x );
    }

  @:isVar public var ratio_windowsize_y( get, set ):Float;
    public function get_ratio_windowsize_y():Float { return( ratio_windowsize_y ); }
    public function set_ratio_windowsize_y( r:Float ):Float {
      ratio_windowsize_y = r;
      return( ratio_windowsize_y );
    }

  @:isVar public var ratio_windowpos_x( get, set ):Float;
    public function get_ratio_windowpos_x():Float { return( ratio_windowpos_x ); }
    public function set_ratio_windowpos_x( r:Float ):Float {
      ratio_windowpos_x = r;
      return( ratio_windowpos_x );
    }

  @:isVar public var ratio_windowpos_y( get, set ):Float;
    public function get_ratio_windowpos_y():Float { return( ratio_windowpos_y ); }
    public function set_ratio_windowpos_y( r:Float ):Float {
      ratio_windowpos_y = r;
      return( ratio_windowpos_y );
    }

  // button positions
  @:isVar public var ratio_ok_pos_x( get, set ):Float;
    public function get_ratio_ok_pos_x():Float { return( ratio_ok_pos_x ); }
    public function set_ratio_ok_pos_x( r:Float ):Float {
      ratio_ok_pos_x = r;
      return( ratio_ok_pos_x );
    }

  @:isVar public var ratio_ok_pos_y( get, set ):Float;
    public function get_ratio_ok_pos_y():Float { return( ratio_ok_pos_y ); }
    public function set_ratio_ok_pos_y( r:Float ):Float {
      ratio_ok_pos_y = r;
      return( ratio_ok_pos_y );
    }

  @:isVar public var ratio_cancel_pos_x( get, set ):Float;
    public function get_ratio_cancel_pos_x():Float { return( ratio_cancel_pos_x ); }
    public function set_ratio_cancel_pos_x( r:Float ):Float {
      ratio_cancel_pos_x = r;
      return( ratio_cancel_pos_x );
    }

  @:isVar public var ratio_cancel_pos_y( get, set ):Float;
    public function get_ratio_cancel_pos_y():Float { return( ratio_cancel_pos_y ); }
    public function set_ratio_cancel_pos_y( r:Float ):Float {
      ratio_cancel_pos_y = r;
      return( ratio_cancel_pos_y );
    }

  // ####################################################################

  public function new( melon:Watermelon ) {
    super();
    wm = melon;

    // default values
    bgColor = 0x00FF00;
    bgAlpha = 0.5;
    fontname = "Arial";
    fontsizemain = 12;
    fontsizebutton = 16;
    fontcolormain = 0x000000;
    fontcolorbutton = 0x000000;
    ratio_windowsize_x = 0.7;
    ratio_windowsize_y = 0.7;
    ratio_windowpos_x = 0.1;
    ratio_windowpos_y = 0.1;
    ratio_ok_pos_x = 0.6;
    ratio_ok_pos_y = 0.85;
    ratio_cancel_pos_x = 0.7;
    ratio_cancel_pos_y = 0.85;
  }

  // draw
  public function draw() {
    this.graphics.clear();
    this.removeChildren();

    fillBackground();
    createTextField();
    createOKButton();
    createCancelButton();

    return( this );
  }

  private function fillBackground():Void {
    this.graphics.beginFill( bgColor, bgAlpha );
    this.graphics.drawRect( 0, 0, wm.stage.stageWidth, wm.stage.stageHeight );
    this.graphics.endFill();
  }

  private function createTextField():Void {
    var tf:TextFieldWithScrollBar =
        new TextFieldWithScrollBar( this,
            new TextFormat( fontname, fontsizemain, fontcolormain ),
            ratio_windowsize_x * wm.stage.stageWidth,
            ratio_windowsize_y * wm.stage.stageHeight,
            12, wm.myString );
    tf.name = "EDIT_WINDOW";
    tf.x = ratio_windowpos_x * wm.stage.stageWidth;
    tf.y = ratio_windowpos_y * wm.stage.stageHeight;
    this.addChild( tf );
  }

  private function createOKButton():Void {
    var ok:TextField = new TextField();
    ok.border = true;
    ok.background = true;
    ok.text = "OK";
    ok.setTextFormat( new TextFormat( fontname, fontsizebutton ) );
    ok.selectable = false;
    ok.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var okbutton:Sprite = new Sprite();
    okbutton.addChild( ok );
    this.addChild( okbutton );
    okbutton.x = ratio_ok_pos_x * wm.stage.stageWidth;
    okbutton.y = ratio_ok_pos_y * wm.stage.stageHeight;
    var ref = this;
    okbutton.addEventListener( MouseEvent.CLICK,
                               function( e:Event ) {
                                 var d:Dynamic = ref.getChildByName( "EDIT_WINDOW" );
                                 var s:String = d.getText();
                                 ref.wm.states.busyNow = false;
                                 ref.wm.stage.removeChild( ref );
                                 ref.wm.visualize( s );
                               } );
  }

  private function createCancelButton():Void {
    var cancel:TextField = new TextField();
    cancel.border = true;
    cancel.background = true;
    cancel.text = "Cancel";
    cancel.setTextFormat( new TextFormat( fontname, fontsizebutton ) );
    cancel.selectable = false;
    cancel.autoSize = flash.text.TextFieldAutoSize.CENTER;
    var cancelbutton:Sprite = new Sprite();
    cancelbutton.addChild( cancel );
    this.addChild( cancelbutton );
    cancelbutton.x = ratio_cancel_pos_x * wm.stage.stageWidth;
    cancelbutton.y = ratio_cancel_pos_y * wm.stage.stageHeight;
    var ref = this;
    cancelbutton.addEventListener( MouseEvent.CLICK,
                                   function( e:Event ) {
                                     ref.wm.states.busyNow = false;
                                     ref.wm.stage.removeChild( ref );
                                   } );
  }
}
