// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// container for default values for each <SCENE>
class WMDefaults {
  // global default
  static public var gl_Atom:WMBase =
           new WMBase( 4.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.35, 0.6,
                       0.3, 30, "Phong" );
  static public var gl_Bond:WMBase =
           new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 2, 0.4, 0.5,
                       0.2, 30, "Phong" );
  static public var gl_BondRound:Bool = true;
  static public var gl_BondExclude:Bool = false;
  static public var gl_BondDashed:Int = 0;
  static public var gl_Coil:WMBase =
          new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.6,
                      0.3, 30, "Phong" );
  static public var gl_Ribbon:WMBase =
          new WMBase( 8.0, 0xFF0000, 0xFF0000, 1.0, 0.0, 0, 0.3, 0.6,
                      0.3, 30, "Phong" );
  static public var gl_RibbonThickness:Float = 0.0;
  static public var gl_RibbonSmoothing:Bool = false;
  static public var gl_Label:WMBase =
         new WMBase( 130.0, 0xFFFFFF, 0xFFFFFF, 1.0, 0.0, 0, 0.0, 0.0,
                     0.0, 30, "2DUV" );
  static public var gl_LabelFont:String = "Arial";
  static public var gl_LabelSize:Float = 32.0;
  static public var gl_Shape:WMBase =
         new WMBase( 0.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.4, 0.5,
                     0.2, 30, "Phong" );
  static public var gl_Object3D:WMBase =
         new WMBase( 1.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.4, 0.5,
                     0.2, 30, "Phong" );
  static public var gl_Object3DType:String = "cone";

  // ########################################################################

  // <SCENE> local default
  @:isVar public var Atom( get, set ):WMBase;
    public function get_Atom():WMBase { return( Atom ); }
    public function set_Atom( a:WMBase ):WMBase {
      if ( Atom == null ) Atom = new WMBase();
      Atom.copyFrom( a );
      return( Atom );
    }

  @:isVar public var Bond( get, set ):WMBase;
    public function get_Bond():WMBase { return( Bond ); }
    public function set_Bond( b:WMBase ):WMBase {
      if ( Bond == null ) Bond = new WMBase();
      Bond.copyFrom( b );
      return( Bond );
    }
  @:isVar public var BondRound( get, set ):Bool;
    public function get_BondRound():Bool { return( BondRound ); }
    public function set_BondRound( f:Bool ):Bool {
      BondRound = f;
      return( BondRound );
    }
  @:isVar public var BondExclude( get, set ):Bool;
    public function get_BondExclude():Bool { return( BondExclude ); }
    public function set_BondExclude( f:Bool ):Bool {
      BondExclude = f;
      return( BondExclude );
    }
  @:isVar public var BondDashed( get, set ):Int;
    public function get_BondDashed():Int { return( BondDashed ); }
    public function set_BondDashed( d:Int ):Int {
      BondDashed = d;
      return( BondDashed );
    }

  @:isVar public var Coil( get, set ):WMBase;
    public function get_Coil():WMBase { return( Coil ); }
    public function set_Coil( c:WMBase ):WMBase {
      if ( Coil == null ) Coil = new WMBase();
      Coil.copyFrom( c );
      return( Coil );
    }

  @:isVar public var Ribbon( get, set ):WMBase;
    public function get_Ribbon():WMBase { return( Ribbon ); }
    public function set_Ribbon( r:WMBase ):WMBase {
      if ( Ribbon == null ) Ribbon = new WMBase();
      Ribbon.copyFrom( r );
      return( Ribbon );
    }
  @:isVar public var RibbonThickness( get, set ):Float;
    public function get_RibbonThickness():Float { return( RibbonThickness ); }
    public function set_RibbonThickness( t:Float ):Float {
      RibbonThickness = t;
      return( RibbonThickness );
    }
  @:isVar public var RibbonSmoothing( get, set ):Bool;
    public function get_RibbonSmoothing():Bool { return( RibbonSmoothing ); }
    public function set_RibbonSmoothing( b:Bool ):Bool {
      RibbonSmoothing = b;
      return( RibbonSmoothing );
    }

  @:isVar public var Label( get, set ):WMBase;
    public function get_Label():WMBase { return( Label ); }
    public function set_Label( l:WMBase ):WMBase {
      if ( Label == null ) Label = new WMBase();
      Label.copyFrom( l );
      return( Label );
    }
  @:isVar public var LabelFont( get, set ):String;
    public function get_LabelFont():String { return( LabelFont ); }
    public function set_LabelFont( f:String ):String {
      LabelFont = f;
      return( LabelFont );
    }
  @:isVar public var LabelSize( get, set ):Float;
    public function get_LabelSize():Float { return( LabelSize ); }
    public function set_LabelSize( s:Float ):Float {
      LabelSize = s;
      return( LabelSize );
    }

  @:isVar public var Shape( get, set ):WMBase;
    public function get_Shape():WMBase { return( Shape ); }
    public function set_Shape( s:WMBase ):WMBase {
      if ( Shape == null ) Shape = new WMBase();
      Shape.copyFrom( s );
      return( Shape );
    }

  @:isVar public var Object3D( get, set ):WMBase;
    public function get_Object3D():WMBase { return( Object3D ); }
    public function set_Object3D( o:WMBase ):WMBase {
      if ( Object3D == null ) Object3D = new WMBase();
      Object3D.copyFrom( o );
        return( Object3D );
    }
  @:isVar public var Object3DType( get, set ):String;
    public function get_Object3DType():String { return( Object3DType ); }
    public function set_Object3DType( t:String ):String {
      Object3DType = t;
      return( Object3DType );
    }

  // ########################################################################

  public function new() {
    Atom = new WMBase();
    Atom.copyFrom( gl_Atom );
    Bond = new WMBase();
    Bond.copyFrom( gl_Bond );
    BondRound = gl_BondRound;
    BondExclude = gl_BondExclude;
    BondDashed = gl_BondDashed;
    Ribbon = new WMBase();
    Ribbon.copyFrom( gl_Ribbon );
    RibbonThickness = gl_RibbonThickness;
    RibbonSmoothing = gl_RibbonSmoothing;
    Coil = new WMBase();
    Coil.copyFrom( gl_Coil );
    Label = new WMBase();
    Label.copyFrom( gl_Label );
    LabelFont = gl_LabelFont;
    LabelSize = gl_LabelSize;
    Shape = new WMBase();
    Shape.copyFrom( gl_Shape );
    Object3D = new WMBase();
    Object3D.copyFrom( gl_Object3D );
    Object3DType = gl_Object3DType;
  }
}
