// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMAtom extends WMObjBase {
  // variables and their getter/header
  @:isVar public var pos( get, set ):Point3D;
    public function get_pos():Point3D { return( pos ); }
    public function set_pos( p:Point3D ):Point3D {
      if ( p != null ) {
        pos = p.clone();
      }
      return( pos );
    }
  @:isVar public var opos( get, set ):Point3D;
    public function get_opos():Point3D { return( opos ); }
    public function set_opos( p:Point3D ):Point3D {
      if ( p != null ) opos = p.clone();
      return( opos );
    }

  // #######################################################################

  public function new( ?r:Float = 1.0,
                       ?c0:Int = 0x00FF00,
                       ?c1:Int = 0x00FF00,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 3,
                       ?ag:Float = 0.35,
                       ?d:Float = 0.6,
                       ?sp:Float = 0.3,
                       ?gl:Float = 30.0,
                       ?sh:String = "Phong" ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
    pos = null;
    opos = null;
    _polygon = null;
  }

  public function clone():WMAtom {
    var ret:WMAtom = new WMAtom( radius, color0, color1, alpha, offset, quality, ambient, diffuse, specular, gloss, shader );
    return( ret );
  }

  public override function clear( ?def:WMDefaults = null ):Void {
    if ( def != null ) {
      copyFrom( def.Atom );
    } else {
      radius = 1.0;
      color0 = 0x00FF00;
      color1 = 0x00FF00;
      alpha = 1.0;
      offset = 0.0;
      quality = 3;
      ambient = 0.35;
      diffuse = 0.6;
      specular = 0.3;
      gloss = 30.0;
      shader = "Phong";
    }
    pos = null;
    opos = null;
    _polygon = null;
  }

  public override function loadFromXml( x:Xml,
                                        ?def:WMDefaults = null ):Void {
    clear( def );
    loadFromXmlWOClear( x );
  }

  public function loadFromXmlOverwrite( x:Xml ):Void {
    super.loadFromXml( x );
  }

  public function loadFromXmlWOClear( x:Xml ):Void {
    loadFromXmlOverwrite( x );
    if ( !x.exists( "pos" ) ) {
      trace( "pos attribute is required for an ATOM" );
      return;
    }
    pos = Point3D.fromStringInverted( x.get( "pos" ) );
    opos = pos;
  }

  public function gen( c:Context3D,
                       ?is_dc_active:Bool = false ):Void {
    pregen();
    gen2( c, is_dc_active );
  }

  public function pregen():Void {
    _polygon = new Sphere3D( WMBase.getRelative( radius ), quality );
    _polygon.translate( pos.x, pos.y, pos.z );
    setShaderParams();
  }

  public function gen2( c:Context3D,
                        ?is_dc_active:Bool = false ):Void {
    _polygon.allocate( c, is_dc_active, shader, color0, alpha );
  }

  public function num():Int { return(1); }
  public function sumPos():Point3D { return( pos ); }
  public function translate( p:Point3D ):Void { pos.add( p ); }
  public function absmax():Point3D {
    var ret:Point3D = new Point3D( 0, 0, 0 );
    ret.x = Math.abs( pos.x );
    ret.y = Math.abs( pos.y );
    ret.z = Math.abs( pos.z );
    return( ret );
  }
  public function scaleCoord( scale:Float ):Void {
    pos.multiply( scale );
  }
  public override function getDataSize():Int { return( 10 ); }
}
