// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

class WMAlias {
  @:isVar public var name( get, set ):String;
    public function get_name():String { return( name ); }
    public function set_name( n:String ):String {
      name = n;
      return( name );
    }
  @:isVar public var elem( get, set ):String;
    public function get_elem():String { return( elem ); }
    public function set_elem( e:String ):String {
      elem = e;
      return( elem );
    }
  @:isVar public var mybase( get, null ):Dynamic;
    public function get_mybase():Dynamic { return( mybase ); }

  // ####################################################################

  public function new() {
    name = "";
    elem = "";
    mybase = null;
  }

  public function register( t:String,
                            x:Xml ):Void {
    name = t;
    elem = x.get( "elem" ).toUpperCase();
    switch( elem ) {
      case "ATOM":
        mybase = new WMAtom();
        mybase.copyFrom( WMDefaults.gl_Atom );
      case "BOND":
        mybase = new WMBond();
        mybase.copyFrom( WMDefaults.gl_Bond );
        mybase.rounded = WMDefaults.gl_BondRound;
        mybase.exclude = WMDefaults.gl_BondExclude;
        mybase.dashed = WMDefaults.gl_BondDashed;
      case "COIL":
        mybase = new WMRibbon( false );
        mybase.copyFrom( WMDefaults.gl_Coil );
      case "RIBBON":
        mybase = new WMRibbon( true );
        mybase.copyFrom( WMDefaults.gl_Ribbon );
        mybase.thickness = WMDefaults.gl_RibbonThickness;
        mybase.smoothing = WMDefaults.gl_RibbonSmoothing;
      case "LABEL":
        mybase = new WMLabel();
        mybase.copyFrom( WMDefaults.gl_Label );
        mybase.font = WMDefaults.gl_LabelFont;
        mybase.fontsize = WMDefaults.gl_LabelSize;
      case "SHAPE":
        mybase = new WMShape();
        mybase.copyFrom( WMDefaults.gl_Shape );
      case "OBJ3D":
        mybase = new WMObject3D();
        mybase.copyFrom( WMDefaults.gl_Object3D );
        mybase.type = WMDefaults.gl_Object3DType;
    }
    mybase.loadFromXmlOverwrite( x );
  }
}
