// container class for a vertex
class Vertex {
  public var pos( __getPos, __setPos ):Point3D;
  public var normal( __getNormal, __setNormal ):Point3D;

  public function new( ?p:Point3D,
                       ?n:Point3D ) {
    if ( p != null ) pos = p.clone();
    if ( n != null ) normal = n.clone();
  }

  public function clone():Vertex {
    return( new Vertex( pos, normal ) );
  }

  public function clear():Void {
    pos = null;
    normal = null;
  }

  // a vertex must have position (normal vector is an optional attribute)
  public function isEmpty():Bool {
    if ( pos == null ) return( true );
    return( false );
  }

  public function __getPos():Point3D { return( pos ); }
  public function __getNormal():Point3D { return( normal ); }

  public function __setPos( p:Point3D ):Point3D {
    pos = p.clone();
    return( pos );
  }
  public function __setNormal( n:Point3D ):Point3D {
    normal = n.clone();
    return( normal );
  }

  public function addNormal( n:Point3D ):Void {
    if ( normal == null ) {
      normal = n.clone();
    } else {
      normal.add( n );
    }
  }

  public function toString():String {
    if ( normal == null ) return( pos.toString() );
    return( pos + "\n" + normal );
  }
}
