// simple container for a control point in chain
//
// this class contains: 
//   * position of the control/interpolated point
//   * original position of control point
//   * direction of the face

class WMCPoint {
  public var pos( __getPos, __setPos ):Point3D;
  public var opos( __getOrgPos, __setOrgPos ):Point3D;
  public var facedir( __getFaceDirection, __setFaceDirection ):Point3D;

  public function new( ?p:Point3D = null,
                       ?f:Point3D = null ) {
    if ( p != null ) __setPos( p );
    if ( f != null ) __setFaceDirection( f );
  }

  public function clone():WMCPoint {
    return( new WMCPoint( pos, facedir ) );
  }

  public function __getPos():Point3D { return( pos ); }
  public function __getOrgPos():Point3D { return( opos ); }
  public function __getFaceDirection():Point3D { return( facedir ); }
  public function __setPos( p:Point3D ):Point3D {
    pos = p.clone();
    __setOrgPos( p );
    return( pos );
  }
  public function __setOrgPos( p:Point3D ):Point3D {
    opos = p.clone();
    return( opos );
  }
  public function __setFaceDirection( f:Point3D ):Point3D {
    facedir = f.clone();
    return( facedir );
  }
}
