;;;
;;; Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

(require "rk.scm")
(require "generic-key.scm")
;;

(define generic-use-candidate-window? #t)
(define generic-candidate-op-count 1)
(define generic-nr-candidate-max 10)

(define generic-context-rk-context
  (lambda (pc)
    (car (nthcdr 0 pc))))
(define generic-context-set-rk-context!
  (lambda (pc rkc)
    (set-car! (nthcdr 0 pc) rkc)))
(define generic-context-rk-nth
  (lambda (pc)
    (car (nthcdr 1 pc))))
(define generic-context-set-rk-nth!
  (lambda (pc n)
    (set-car! (nthcdr 1 pc) n)))
(define generic-context-on
  (lambda (pc)
    (car (nthcdr 2 pc))))
(define generic-context-set-on!
  (lambda (pc n)
    (set-car! (nthcdr 2 pc) n)))
(define generic-context-candidate-op-count
  (lambda (pc)
    (car (nthcdr 3 pc))))
(define generic-context-set-candidate-op-count!
  (lambda (pc n)
    (set-car! (nthcdr 3 pc) n)))
(define generic-context-raw-commit
  (lambda (pc)
    (car (nthcdr 4 pc))))
(define generic-context-set-raw-commit!
  (lambda (pc n)
    (set-car! (nthcdr 4 pc) n)))

(define generic-update-preedit
  (lambda (id pc)
    (if (generic-context-raw-commit pc)
	(generic-context-set-raw-commit! pc #f)
	(let* ((rkc (generic-context-rk-context pc))
	       (cs (rk-current-seq rkc))
	       (n (generic-context-rk-nth pc)))
	  (im-clear-preedit id)
	  (im-pushback-preedit
	   id preedit-reverse
	   (if cs
	       (nth n (cadr cs))
	       (rk-pending rkc)))
	  (im-update-preedit id)))))

;; (context nth)
(define generic-context-new
  (lambda (rule back)
    (let ((c (copy-list '(() 0 () 0 #f))))
      (generic-context-set-rk-context!
       c (rk-context-new rule #f back))
      (generic-context-set-rk-nth! c 0)
      (generic-context-set-on! c #f)
      c)))

(define generic-commit-raw
  (lambda (pc id)
    (im-commit-raw id)
    (generic-context-set-raw-commit! pc #t)))

(define generic-proc-on-mode
  (lambda (id pc key state)
    (let* ((rkc (generic-context-rk-context pc))
	   (n (generic-context-rk-nth pc))
	   (cs (cadr (rk-current-seq rkc)))
	   (res))
      (and
       (if (generic-off-key? key state)
	   (begin
	     (rk-flush rkc)
	     (generic-context-set-on! pc #f)
	     (generic-update-prop-label pc id)
	     (im-update-mode id 0)
	     #f)
	   #t)
       (if (generic-prev-candidate-key? key state)
	   (if (> (length (cadr cs)) 0)
	       (begin
		 (set! n (- n 1))
		 (generic-context-set-rk-nth! pc n)
		 (if (< n 0)
		     (begin
		       (generic-context-set-rk-nth! pc (- (length cs) 1))
		       (set! n (- (length cs) 1))))
		 (generic-context-set-candidate-op-count!
		  pc
		  (+ 1 (generic-context-candidate-op-count pc)))
		 (if (>= (generic-context-candidate-op-count pc)
			 generic-candidate-op-count)
		     (im-select-candidate id n))
		 #f)
	       (begin
		 (im-commit-raw id)
		 (rk-flush rkc)
		 (im-update-preedit id)
		 #f))
	   #t)
       (if (generic-next-candidate-key? key state)
	   (if (> (length (cadr cs)) 0)
	       (begin
		 (generic-context-set-rk-nth! pc (+ 1 n))
		 (if (<= (length cs) (+ n 1))
		     (generic-context-set-rk-nth! pc 0))
		 (generic-context-set-candidate-op-count!
		  pc
		  (+ 1 (generic-context-candidate-op-count pc)))
		 (if (and
		      (= (generic-context-candidate-op-count pc)
			 generic-candidate-op-count)
		      generic-use-candidate-window?)
		     (im-activate-candidate-selector id (length cs) generic-nr-candidate-max))
		 (if (>= (generic-context-candidate-op-count pc)
			 generic-candidate-op-count)
		     (begin
		       (if (>= (+ n 1) (length cs))
			   (set! n -1))
		       (im-select-candidate id (+ n 1))))
		 #f)
	       (begin
		 (im-commit-raw id)
		 (rk-flush rkc)
		 (im-update-preedit id)
		 #f))
	   #t)
       (if (and (generic-prev-page-key? key state)
		(<= generic-candidate-op-count (generic-context-candidate-op-count pc)))
	   (begin
	     (im-shift-page-candidate id #f)
	     #f)
	   #t)
       (if (and (generic-next-page-key? key state)
		(<= generic-candidate-op-count (generic-context-candidate-op-count pc)))
	   (begin
	     (im-shift-page-candidate id #t)
	     #f)
	   #t)
       (if (generic-backspace-key? key state)
	   (begin
	     (if (not (rk-backspace rkc))
		 (generic-commit-raw pc id))
	     (generic-context-set-rk-nth! pc 0)
	     (im-deactivate-candidate-selector id)
	     #f)
	   #t)
       (if (generic-commit-key? key state)
	   (let ((cs (rk-current-seq rkc)))
	     (if (> (length (cadr cs)) 0)
		 (begin
		   (im-commit id (nth (generic-context-rk-nth pc) (cadr cs)))
		   (generic-context-set-rk-nth! pc 0)
		   (generic-context-set-candidate-op-count! pc 0)
		   (rk-flush rkc)
		   (im-deactivate-candidate-selector id))
		 (begin
		   (im-commit-raw id)
		   (rk-flush rkc)
		   (im-update-preedit id)))
	     #f)
	   #t)
       (if (symbol? key)
	   (begin
	     (rk-flush rkc)
	     (generic-commit-raw pc id)
	     (generic-context-set-rk-nth! pc 0)
	     #f)
	   #t)
       (if (and (modifier-key-mask state)
		(not (shift-key-mask state)))
	   (begin
	     (generic-commit-raw pc id)
	     #f)
	   #t)
       (begin
	 (set! res
	       (rk-push-key!
		rkc
		(charcode->string key)))
	 #t))
      (if (not (rk-partial? rkc))
	  (let ((cs (rk-current-seq rkc)))
	    (if (= (length (cadr cs)) 1)
		(begin
		  (im-commit id
			     (nth (generic-context-rk-nth pc) (cadr cs)))
		  (generic-context-set-rk-nth! pc 0)
		  (generic-context-set-candidate-op-count! pc 0)
		  (im-deactivate-candidate-selector id)
		  (rk-flush rkc)))))
      (if res
	  (begin
	    (im-commit id (nth (generic-context-rk-nth pc) res))
	    (generic-context-set-rk-nth! pc 0)
	    (generic-context-set-candidate-op-count! pc 0)
	    (im-deactivate-candidate-selector id))
	  ))))

(define generic-proc-off-mode
  (lambda (id pc key state)
    (and
     (if (generic-on-key? key state)
	 (begin
	   (generic-context-set-on! pc #t)
	   (generic-update-prop-label pc id)
	   (im-update-mode id 1)
	   #f)
	 #t)
     ;;
     (generic-commit-raw pc id))))

(define generic-key-press-handler
  (lambda (id key state)
    (let* ((c (find-context id))
	   (pc (context-data c)))
      (if (control-char? key)
	  (im-commit-raw id)
	  (if (generic-context-on pc)
	      (generic-proc-on-mode id pc key state)
	      (generic-proc-off-mode id pc key state)))
      (generic-update-preedit id pc)
      ())))

(define generic-key-release-handler
  (lambda (id key state)
    (let* ((c (find-context id))
	   (pc (context-data c)))
      (if (or (control-char? key)
	      (not (generic-context-on pc)))
	  ;; don't discard key release event for apps
	  (generic-commit-raw pc id)))))

(define generic-reset-handler
  (lambda (id)
    ()))

(define generic-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (pc (context-data c))
	   (rkc (generic-context-rk-context pc)))
      (if (= mode 0)
	  (generic-context-set-on! pc #f)
	  (generic-context-set-on! pc #t))
      (rk-flush rkc)
      (generic-update-preedit id pc))))

(define generic-get-candidate-handler
  (lambda (id idx accel-enum-hint)
    (let* ((c (find-context id))
	   (pc (context-data c))
	   (rkc (generic-context-rk-context pc))
	   (cs (cadr (rk-current-seq rkc)))
	   (cand (car (nthcdr idx cs))))
      (list cand (digit->string (+ idx 1))))))

(define generic-set-candidate-index-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (pc (context-data c))
	   (rkc (generic-context-rk-context pc)))
      (generic-context-set-rk-nth! pc idx))))

(define generic-init-handler
  (lambda (id init-handler)
    (init-handler id #f)
    (im-clear-mode-list id)
    (im-pushback-mode-list id "RAW")
    (im-pushback-mode-list
     id
     (im-name (context-im (find-context id))))
    (im-update-mode-list id)
    (im-update-mode id 0)
    (generic-update-prop-list id)
))

(define generic-prop-handler
  (lambda (id message)
    (let* ((c (find-context id))
	   (pc (context-data c))
	   (rkc (generic-context-rk-context pc)))

      (rk-flush rkc)
      (generic-update-preedit id pc)
      
      (if (string=? message
			 "prop_generic_raw")
	  (begin
	    (im-update-mode id 0)
	    (generic-context-set-on! pc #f)))
      (if (string=? message
			 "prop_generic_on")
	  (begin
	    (im-update-mode id 1)
	    (generic-context-set-on! pc #t)))
      (generic-update-prop-label pc id))))

(define generic-update-prop-label
  (lambda (pc id)
    (let*  ((state (generic-context-on pc))
	    (str ""))
      (if state
	  (set! str "O\ton\n")
	  (set! str "o\toff\n"))
      (im-update-prop-label id str))))

(define generic-update-prop-list
  (lambda (id) 
    (let* ((c (find-context id))
	   (pc (context-data c))
	   (state (generic-context-on pc))
	   (name (im-name (context-im c)))
	   (str "branch\t"))
      (if state
	  (set! str "O\ton\n")
	  (set! str "o\toff\n"))
      (set! str (string-append
		 "branch\t" str
		 "leaf\tO\tOn\tRaw input mode\tprop_generic_on\n"
		 "leaf\to\t" name "\t " name " mode\t\tprop_generic_raw\n"))
      (im-update-prop-list id str)
      )))


(define generic-register-im
  (lambda (name lang code init)
    (register-im
     name lang code init generic-init-handler #f
     generic-mode-handler
     generic-key-press-handler
     generic-key-release-handler
     generic-reset-handler
     generic-get-candidate-handler
     generic-set-candidate-index-handler
     generic-prop-handler
     )))
