/*
 * Decompiled with CFR 0.152.
 */
package transex3.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import transex3.model.SdfEntity;

public class SdfString {
    private SdfEntity sourceString = null;
    private Vector languageList = new Vector();
    private String id = null;
    private String fileid = null;
    private String filename = null;
    private String modulename = null;
    private String filepath = null;

    public Vector getLanguageStrings() {
        return this.languageList;
    }

    public void setLanguageStrings(Vector vector) {
        this.languageList = vector;
    }

    public void addSourceString(SdfEntity sdfEntity) {
        if (this.id == null) {
            this.id = sdfEntity.getId();
        }
        if (this.fileid == null) {
            this.fileid = sdfEntity.getFileId();
        }
        if (this.modulename == null) {
            this.modulename = sdfEntity.getProject();
        }
        if (this.filename == null) {
            this.filename = sdfEntity.getSource_file();
        }
        if (this.filepath == null) {
            this.filepath = sdfEntity.getResourcePath();
        }
        this.setSourceString(sdfEntity);
    }

    public void addLanguageString(SdfEntity sdfEntity) {
        if (!sdfEntity.getLangid().equals("en-US")) {
            if (this.id == null) {
                this.id = sdfEntity.getId();
            }
            if (this.fileid == null) {
                this.fileid = sdfEntity.getFileId();
            }
            if (this.modulename == null) {
                this.modulename = sdfEntity.getProject();
            }
            if (this.filename == null) {
                this.filename = sdfEntity.getSource_file();
            }
            if (this.filepath == null) {
                this.filepath = sdfEntity.getResourcePath();
            }
            this.languageList.add(sdfEntity);
            this.id = sdfEntity.getId();
        }
    }

    public SdfEntity getSourceString() {
        return this.sourceString;
    }

    public void setSourceString(SdfEntity sdfEntity) {
        this.sourceString = sdfEntity;
        this.id = sdfEntity.getId();
    }

    public String getFilePath() {
        return this.filepath;
    }

    public String getId() {
        return this.sourceString.getId();
    }

    public String getFileId() {
        return this.fileid;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public String getModuleName() {
        return this.modulename;
    }

    public void setModuleName(String string) {
        this.modulename = string;
    }

    public String getRealFileName() {
        String string = this.sourceString.getFileId();
        string = string.replaceAll("\\\\", "_");
        String string2 = "/so/ws/merge/In/" + System.getProperty("WORK_STAMP") + "/" + string + ".sdf";
        return string2;
    }

    public void removeFile() {
        String string = this.getRealFileName();
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            System.out.println("Can't delete File " + string + "\nWrong access rights?\n");
        }
    }

    public void writeString() {
        String string = this.getRealFileName();
        try {
            if (this.languageList.size() > 0) {
                System.out.print("\nWrite to " + string);
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));
                bufferedWriter.write(this.sourceString + "\n");
                for (SdfEntity sdfEntity : this.languageList) {
                    bufferedWriter.write(this.sourceString.getProject() + "\t");
                    bufferedWriter.write(this.sourceString.getSource_file() + "\t");
                    bufferedWriter.write(this.sourceString.getDummy1() + "\t");
                    bufferedWriter.write(this.sourceString.getResource_type() + "\t");
                    bufferedWriter.write(this.sourceString.getGid() + "\t");
                    bufferedWriter.write(this.sourceString.getLid() + "\t");
                    bufferedWriter.write(this.sourceString.getHelpid() + "\t");
                    bufferedWriter.write(this.sourceString.getPlatform() + "\t");
                    bufferedWriter.write(this.sourceString.getDummy2() + "\t");
                    if (sdfEntity.getLangid() == null) {
                        bufferedWriter.write("\t");
                    } else {
                        bufferedWriter.write(sdfEntity.getLangid() + "\t");
                    }
                    if (sdfEntity.getText() == null) {
                        bufferedWriter.write("\t");
                    } else {
                        bufferedWriter.write(sdfEntity.getText() + "\t");
                    }
                    if (sdfEntity.getHelptext() == null) {
                        bufferedWriter.write("\t");
                    } else {
                        bufferedWriter.write(sdfEntity.getHelptext() + "\t");
                    }
                    if (sdfEntity.getQuickhelptext() == null) {
                        bufferedWriter.write("\t");
                    } else {
                        bufferedWriter.write(sdfEntity.getQuickhelptext() + "\t");
                    }
                    if (sdfEntity.getTitle() == null) {
                        bufferedWriter.write("\t");
                    } else {
                        bufferedWriter.write(sdfEntity.getTitle() + "\t");
                    }
                    bufferedWriter.write("2002-02-02 02:02:02\n");
                }
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            System.out.println("\nERROR: Can't write to file '" + string + "'\nPlease contact RE/Tooling!");
        }
    }
}

