/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipwriter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipContentItem;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public class ZipEntryOutputStream
extends OutputStream {
    private ByteArrayOutputStream outputStream;
    private DeflaterOutputStream deflaterOutputStream;
    private boolean closed;
    private ZipContentItem item;
    private CRC32 crc32;
    private long size;

    public ZipEntryOutputStream(ZipContentItem zipContentItem) {
        if (zipContentItem == null) {
            throw new NullPointerException();
        }
        this.item = zipContentItem;
        this.outputStream = new ByteArrayOutputStream();
        this.deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.outputStream, new Deflater(RepositoryUtilities.getZipLevel(zipContentItem)));
        this.crc32 = new CRC32();
        this.size = 0L;
    }

    @Override
    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(n);
        this.crc32.update(n);
        ++this.size;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(byArray, n, n2);
        this.crc32.update(byArray, n, n2);
        this.size += (long)n2;
    }

    @Override
    public void close() throws IOException {
        Object object;
        if (this.closed) {
            return;
        }
        this.deflaterOutputStream.close();
        byte[] byArray = this.outputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ZipRepository zipRepository = (ZipRepository)this.item.getRepository();
        String string = (String)this.item.getContentId();
        ZipEntry zipEntry = new ZipEntry(string);
        Object object2 = this.item.getAttribute("org.jfree.repository.zip", "comment");
        if (object2 != null) {
            zipEntry.setComment(String.valueOf(object2));
        }
        if ((object = this.item.getAttribute("org.jfree.repository", "version")) instanceof Date) {
            Date date = (Date)object;
            zipEntry.setTime(date.getTime());
        }
        int n = RepositoryUtilities.getZipMethod(this.item);
        zipEntry.setCrc(this.crc32.getValue());
        if (n == 0) {
            zipEntry.setCompressedSize(this.size);
            zipEntry.setSize(this.size);
        } else {
            zipEntry.setSize(this.size);
        }
        zipRepository.writeContent(zipEntry, inflaterInputStream, n, RepositoryUtilities.getZipLevel(this.item));
        inflaterInputStream.close();
        this.closed = true;
        this.outputStream = null;
        this.deflaterOutputStream = null;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.write(byArray);
        this.crc32.update(byArray);
        this.size += (long)byArray.length;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Already closed");
        }
        this.deflaterOutputStream.flush();
    }
}

