/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipContentLocation;

public class ZipRepository
implements Repository {
    private ZipContentLocation root;
    private MimeRegistry mimeRegistry;

    public ZipRepository() {
        this(new DefaultMimeRegistry());
    }

    public ZipRepository(MimeRegistry mimeRegistry) {
        if (mimeRegistry == null) {
            throw new NullPointerException();
        }
        this.mimeRegistry = mimeRegistry;
        this.root = new ZipContentLocation(this, null, "");
    }

    public ZipRepository(InputStream inputStream) throws IOException {
        this(inputStream, new DefaultMimeRegistry());
    }

    public ZipRepository(InputStream inputStream, MimeRegistry mimeRegistry) throws IOException {
        this(mimeRegistry);
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String[] stringArray = RepositoryUtilities.splitPath(zipEntry.getName(), "/");
            if (zipEntry.isDirectory()) {
                this.root.updateDirectoryEntry(stringArray, 0, zipEntry);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(zipEntry.getMethod()));
                IOUtils.getInstance().copyStreams((InputStream)zipInputStream, (OutputStream)deflaterOutputStream);
                deflaterOutputStream.flush();
                deflaterOutputStream.close();
                this.root.updateEntry(stringArray, 0, zipEntry, byteArrayOutputStream.toByteArray());
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    @Override
    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    @Override
    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }

    public void write(OutputStream outputStream) throws IOException, ContentIOException {
        RepositoryUtilities.writeAsZip(outputStream, this);
    }

    public void writeToZipStream(ZipOutputStream zipOutputStream, Repository repository) throws IOException, ContentIOException {
        RepositoryUtilities.writeToZipStream(zipOutputStream, repository);
    }
}

