/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipContentItem;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;

public class ZipContentLocation
implements ContentLocation {
    private static final Log logger = LogFactory.getLog(ZipContentLocation.class);
    private ZipRepository repository;
    private ZipContentLocation parent;
    private String comment;
    private String name;
    private long size;
    private long time;
    private String entryName;
    private HashMap entries;

    public ZipContentLocation(ZipRepository zipRepository, ZipContentLocation zipContentLocation, String string) {
        if (zipRepository == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.repository = zipRepository;
        this.parent = zipContentLocation;
        this.entryName = string;
        this.entries = new HashMap();
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
        this.time = System.currentTimeMillis();
    }

    public ZipContentLocation(ZipRepository zipRepository, ZipContentLocation zipContentLocation, ZipEntry zipEntry) {
        if (zipRepository == null) {
            throw new NullPointerException();
        }
        if (zipContentLocation == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        this.repository = zipRepository;
        this.parent = zipContentLocation;
        this.entryName = IOUtils.getInstance().getFileName(zipEntry.getName());
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
        this.entries = new HashMap();
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
    }

    private void updateMetaData(ZipEntry zipEntry) {
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
    }

    public void updateDirectoryEntry(String[] stringArray, int n, ZipEntry zipEntry) {
        ZipContentLocation zipContentLocation;
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        String string = stringArray[n];
        Object v = this.entries.get(string);
        if (v instanceof ContentItem) {
            logger.warn((Object)("Directory-Entry with the same name as a Content-Entry encountered: " + string));
            return;
        }
        if (v == null) {
            zipContentLocation = new ZipContentLocation(this.repository, this, string);
            this.entries.put(string, zipContentLocation);
        } else {
            zipContentLocation = (ZipContentLocation)v;
        }
        int n2 = n + 1;
        if (n2 < stringArray.length) {
            zipContentLocation.updateDirectoryEntry(stringArray, n2, zipEntry);
        } else if (n2 == stringArray.length) {
            zipContentLocation.updateMetaData(zipEntry);
        }
    }

    public void updateEntry(String[] stringArray, int n, ZipEntry zipEntry, byte[] byArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        String string = stringArray[n];
        Object v = this.entries.get(string);
        int n2 = n + 1;
        if (n2 < stringArray.length) {
            ZipContentLocation zipContentLocation;
            if (v instanceof ContentItem) {
                logger.warn((Object)("Directory-Entry with the same name as a Content-Entry encountered: " + string));
                return;
            }
            if (v == null) {
                zipContentLocation = new ZipContentLocation(this.repository, this, string);
                this.entries.put(string, zipContentLocation);
            } else {
                zipContentLocation = (ZipContentLocation)v;
            }
            if (n2 < stringArray.length) {
                zipContentLocation.updateEntry(stringArray, n2, zipEntry, byArray);
            }
        } else if (n2 == stringArray.length) {
            if (v instanceof ContentItem) {
                logger.warn((Object)("Duplicate Content-Entry encountered: " + string));
                return;
            }
            if (v != null) {
                logger.warn((Object)("Replacing Directory-Entry with the same name as a Content-Entry: " + string));
            }
            ZipContentItem zipContentItem = new ZipContentItem(this.repository, this, zipEntry, byArray);
            this.entries.put(string, zipContentItem);
        }
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    @Override
    public ContentEntity getEntry(String string) throws ContentIOException {
        return (ContentEntity)this.entries.get(string);
    }

    @Override
    public boolean exists(String string) {
        return this.entries.containsKey(string);
    }

    @Override
    public ContentItem createItem(String string) throws ContentCreationException {
        if (this.entries.containsKey(string)) {
            throw new ContentCreationException("An entry with name '" + string + "' already exists.");
        }
        if (string.indexOf(47) != -1) {
            throw new ContentCreationException("The entry-name '" + string + "' is invalid.");
        }
        if ("".equals(string) || ".".equals(string) || "..".equals(string)) {
            throw new ContentCreationException("The entry-name '" + string + "' is invalid.");
        }
        ZipContentItem zipContentItem = new ZipContentItem(this.repository, this, string);
        this.entries.put(string, zipContentItem);
        return zipContentItem;
    }

    @Override
    public ContentLocation createLocation(String string) throws ContentCreationException {
        if (this.entries.containsKey(string)) {
            throw new ContentCreationException("An entry with name '" + string + "' already exists.");
        }
        if (this.entries.containsKey(string)) {
            throw new ContentCreationException("An entry with name '" + string + "' already exists.");
        }
        if (string.indexOf(47) != -1) {
            throw new ContentCreationException("The entry-name '" + string + "' is invalid.");
        }
        if ("".equals(string) || ".".equals(string) || "..".equals(string)) {
            throw new ContentCreationException("The entry-name '" + string + "' is invalid.");
        }
        ZipContentLocation zipContentLocation = new ZipContentLocation(this.repository, this, string);
        this.entries.put(string, zipContentLocation);
        return zipContentLocation;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Object getContentId() {
        return this.name;
    }

    @Override
    public Object getAttribute(String string, String string2) {
        if ("org.jfree.repository".equals(string)) {
            if ("size".equals(string2)) {
                return new Long(this.size);
            }
            if ("version".equals(string2)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(string) && "comment".equals(string2)) {
            return this.comment;
        }
        return null;
    }

    @Override
    public boolean setAttribute(String string, String string2, Object object) {
        if ("org.jfree.repository".equals(string)) {
            if ("version".equals(string2)) {
                if (object instanceof Date) {
                    Date date = (Date)object;
                    this.time = date.getTime();
                    return true;
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.time = number.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(string) && "comment".equals(string2)) {
            if (object != null) {
                this.comment = String.valueOf(object);
                return true;
            }
            this.comment = null;
            return true;
        }
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.removeEntity(this);
    }

    public boolean removeEntity(ContentEntity contentEntity) {
        return this.entries.remove(contentEntity.getName()) != null;
    }
}

