/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.LibRepositoryBoot;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipContentLocation;
import org.pentaho.reporting.libraries.repository.zip.ZipEntryOutputStream;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;

public class ZipContentItem
implements ContentItem {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private String comment;
    private String name;
    private long size;
    private long time;
    private ZipRepository repository;
    private byte[] rawData;
    private ZipContentLocation parent;
    private String entryName;
    private Integer method;
    private int compression;
    private long crc32;

    public ZipContentItem(ZipRepository zipRepository, ZipContentLocation zipContentLocation, ZipEntry zipEntry, byte[] byArray) {
        if (zipRepository == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (zipContentLocation == null) {
            throw new NullPointerException();
        }
        this.parent = zipContentLocation;
        this.repository = zipRepository;
        this.comment = zipEntry.getComment();
        this.name = RepositoryUtilities.buildName(this, "/");
        this.entryName = IOUtils.getInstance().getFileName(this.name);
        this.size = zipEntry.getSize();
        this.crc32 = zipEntry.getCrc();
        this.time = zipEntry.getTime();
        this.rawData = byArray;
        int n = zipEntry.getMethod();
        this.method = n == 0 || n == 8 ? new Integer(n) : new Integer(8);
        this.compression = -1;
    }

    public ZipContentItem(ZipRepository zipRepository, ZipContentLocation zipContentLocation, String string) {
        if (zipRepository == null) {
            throw new NullPointerException();
        }
        if (zipContentLocation == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.repository = zipRepository;
        this.parent = zipContentLocation;
        this.entryName = string;
        this.name = RepositoryUtilities.buildName(this, "/");
        this.time = System.currentTimeMillis();
        this.comment = null;
        this.size = 0L;
        this.rawData = EMPTY_BYTES;
        this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
        this.compression = -1;
    }

    public void setRawData(byte[] byArray, long l, long l2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.rawData = byArray;
        this.size = l;
        this.crc32 = l2;
        this.time = System.currentTimeMillis();
    }

    @Override
    public String getMimeType() throws ContentIOException {
        return this.repository.getMimeRegistry().getMimeType(this);
    }

    @Override
    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return new ZipEntryOutputStream(this);
    }

    @Override
    public InputStream getInputStream() throws ContentIOException, IOException {
        return new InflaterInputStream(new ByteArrayInputStream(this.rawData));
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Object getContentId() {
        return this.name;
    }

    @Override
    public Object getAttribute(String string, String string2) {
        if ("org.jfree.repository".equals(string)) {
            if ("size".equals(string2)) {
                return new Long(this.size);
            }
            if ("version".equals(string2)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(string)) {
            if ("comment".equals(string2)) {
                return this.comment;
            }
            if ("crc32".equals(string2)) {
                return new Long(this.crc32);
            }
            if ("method".equals(string2)) {
                return this.method;
            }
            if ("compression".equals(string2)) {
                return new Integer(this.compression);
            }
        }
        return null;
    }

    @Override
    public boolean setAttribute(String string, String string2, Object object) {
        if ("org.jfree.repository".equals(string)) {
            if ("version".equals(string2)) {
                if (object instanceof Date) {
                    Date date = (Date)object;
                    this.time = date.getTime();
                    return true;
                }
                if (object instanceof Number) {
                    Number number = (Number)object;
                    this.time = number.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(string)) {
            Integer n;
            int n2;
            if ("comment".equals(string2)) {
                if (object != null) {
                    this.comment = String.valueOf(object);
                    return true;
                }
                this.comment = null;
                return true;
            }
            if ("method".equals(string2)) {
                if (LibRepositoryBoot.ZIP_METHOD_STORED.equals(object)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_STORED;
                    return true;
                }
                if (LibRepositoryBoot.ZIP_METHOD_DEFLATED.equals(object)) {
                    this.method = LibRepositoryBoot.ZIP_METHOD_DEFLATED;
                    return true;
                }
            }
            if ("compression".equals(string2) && object instanceof Integer && (n2 = (n = (Integer)object).intValue()) >= 0 && n2 <= 9) {
                this.compression = n2;
                return true;
            }
        }
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return this.parent.removeEntity(this);
    }
}

