/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.IOException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.file.FileContentEntity;
import org.pentaho.reporting.libraries.repository.file.FileContentItem;

public class FileContentLocation
extends FileContentEntity
implements ContentLocation {
    private static final long serialVersionUID = -5452372293937107734L;

    public FileContentLocation(ContentLocation contentLocation, File file) throws ContentIOException {
        super(contentLocation, file);
        if (!file.exists() || !file.isDirectory()) {
            throw new ContentIOException("The given backend-file is not a directory.");
        }
    }

    public FileContentLocation(Repository repository, File file) throws ContentIOException {
        super(repository, file);
        if (!file.exists() || !file.isDirectory()) {
            throw new ContentIOException("The given backend-file is not a directory.");
        }
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        File file = this.getBackend();
        File[] fileArray = file.listFiles();
        ContentEntity[] contentEntityArray = new ContentEntity[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (RepositoryUtilities.isInvalidPathName(file2.getName())) continue;
            if (file2.isDirectory()) {
                contentEntityArray[i] = new FileContentLocation(this, file2);
                continue;
            }
            if (!file2.isFile()) continue;
            contentEntityArray[i] = new FileContentLocation(this, file2);
        }
        return contentEntityArray;
    }

    @Override
    public ContentEntity getEntry(String string) throws ContentIOException {
        if (RepositoryUtilities.isInvalidPathName(string)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        File file = this.getBackend();
        File file2 = new File(file, string);
        if (!file2.exists()) {
            throw new ContentIOException("Not found:" + file2);
        }
        try {
            if (!IOUtils.getInstance().isSubDirectory(file, file2)) {
                throw new ContentIOException("The given entry does not point to a sub-directory of this content-location");
            }
        }
        catch (IOException iOException) {
            throw new ContentIOException("IO Error.", iOException);
        }
        if (file2.isDirectory()) {
            return new FileContentLocation(this, file2);
        }
        if (file2.isFile()) {
            return new FileContentItem(this, file2);
        }
        throw new ContentIOException("Not File nor directory.");
    }

    @Override
    public ContentItem createItem(String string) throws ContentCreationException {
        if (RepositoryUtilities.isInvalidPathName(string)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        File file = this.getBackend();
        File file2 = new File(file, string);
        if (file2.exists()) {
            throw new ContentCreationException("File already exists: " + file2);
        }
        try {
            if (!file2.createNewFile()) {
                throw new ContentCreationException("Unable to create the file.");
            }
            return new FileContentItem(this, file2);
        }
        catch (IOException iOException) {
            throw new ContentCreationException("IOError while create", iOException);
        }
    }

    @Override
    public ContentLocation createLocation(String string) throws ContentCreationException {
        if (RepositoryUtilities.isInvalidPathName(string)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        File file = this.getBackend();
        File file2 = new File(file, string);
        if (file2.exists()) {
            throw new ContentCreationException("File already exists.");
        }
        if (!file2.mkdir()) {
            throw new ContentCreationException("Unable to create the directory");
        }
        try {
            return new FileContentLocation(this, file2);
        }
        catch (ContentIOException contentIOException) {
            throw new ContentCreationException("Failed to create the content-location", (Exception)((Object)contentIOException));
        }
    }

    @Override
    public boolean exists(String string) {
        if (RepositoryUtilities.isInvalidPathName(string)) {
            return false;
        }
        File file = this.getBackend();
        File file2 = new File(file, string);
        return file2.exists();
    }
}

