/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;

public abstract class FileContentEntity
implements ContentEntity,
Serializable {
    private File backend;
    private ContentLocation parent;
    private Repository repository;
    private static final long serialVersionUID = 3962114134995757847L;

    protected FileContentEntity(ContentLocation contentLocation, File file) {
        if (file == null) {
            throw new NullPointerException("Backend file must be given.");
        }
        if (contentLocation == null) {
            throw new NullPointerException("Parent file must be given.");
        }
        this.repository = contentLocation.getRepository();
        this.parent = contentLocation;
        this.backend = file;
    }

    protected FileContentEntity(Repository repository, File file) {
        if (file == null) {
            throw new NullPointerException("Backend file must be given.");
        }
        if (repository == null) {
            throw new NullPointerException("Repository file must be given.");
        }
        this.repository = repository;
        this.backend = file;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public String getName() {
        return this.backend.getName();
    }

    protected File getBackend() {
        return this.backend;
    }

    @Override
    public Object getContentId() {
        return this.backend;
    }

    @Override
    public Object getAttribute(String string, String string2) {
        if ("org.jfree.repository".equals(string)) {
            if ("size".equals(string2)) {
                return new Long(this.backend.length());
            }
            if ("version".equals(string2)) {
                return new Date(this.backend.lastModified());
            }
        }
        return null;
    }

    @Override
    public boolean setAttribute(String string, String string2, Object object) {
        if ("org.jfree.repository".equals(string) && "version".equals(string2)) {
            if (object instanceof Date) {
                Date date = (Date)object;
                return this.backend.setLastModified(date.getTime());
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                return this.backend.setLastModified(number.longValue());
            }
        }
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public boolean delete() {
        return this.backend.delete();
    }
}

