/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.dummy;

import java.io.Serializable;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.dummy.DummyContentItem;

public class DummyContentLocation
implements ContentLocation,
Serializable {
    private String name;
    private ContentLocation parent;
    private Repository repository;
    private static final ContentEntity[] EMPTY_CONTENT_ENTITY = new ContentEntity[0];

    public DummyContentLocation(ContentLocation contentLocation, String string) {
        if (contentLocation == null) {
            throw new NullPointerException("Parent must not be null");
        }
        this.repository = contentLocation.getRepository();
        this.parent = contentLocation;
        this.name = string;
    }

    public DummyContentLocation(Repository repository, String string) {
        this.repository = repository;
        this.name = string;
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return EMPTY_CONTENT_ENTITY;
    }

    @Override
    public ContentEntity getEntry(String string) throws ContentIOException {
        throw new ContentIOException();
    }

    @Override
    public ContentItem createItem(String string) throws ContentCreationException {
        return new DummyContentItem(this, string);
    }

    @Override
    public ContentLocation createLocation(String string) throws ContentCreationException {
        return new DummyContentLocation(this, string);
    }

    @Override
    public boolean exists(String string) {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getContentId() {
        return RepositoryUtilities.buildName(this, "/");
    }

    @Override
    public Object getAttribute(String string, String string2) {
        return null;
    }

    @Override
    public boolean setAttribute(String string, String string2, Object object) {
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        return false;
    }
}

