/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.converter.DataHandler;
import com.sun.star.tooling.converter.DataWriter;
import com.sun.star.tooling.converter.ExtMap;
import com.sun.star.tooling.converter.OutputHandler;
import com.sun.star.tooling.languageResolver.LanguageResolver;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XLIFFReader
extends DefaultHandler {
    private final String[] dataNames = new String[]{"BlockNr", "Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "SourceLanguageID", "SourceText", "SourceHText", "SourceQText", "SourceTitle", "TargetLanguageID", "TargetText", "TargetHText", "TargetQText", "TargetTitle", "TimeStamp"};
    static int index = 0;
    private Map moveData = new ExtMap();
    private Hashtable DataStore = new Hashtable();
    private String name = new String("");
    private Attributes attrs;
    private boolean printThis = false;
    private boolean storeIt = false;
    private String[] data = new String[26];
    private final DataHandler handler;
    private final DataWriter target;
    private int dotCount;
    private int transUnitCounter;
    private String sourceLanguage;
    private String targetLanguage;
    private boolean isFirst = true;
    private static final String EMPTY = new String("");
    private int oldindex;
    private static final int BLOCKNR_IDX = 0;
    private static final int PROJECT_IDX = 1;
    private static final int SOURCEFILE_IDX = 2;
    private static final int DUMMY_IDX = 3;
    private static final int GID_IDX = 4;
    private static final int LID_IDX = 5;
    private static final int HID_IDX = 6;
    private static final int PLATFORM_IDX = 7;
    private static final int WIDTH_IDX = 8;
    private static final int SOURCE_LANGUAGE_ID_IDX = 10;
    private static final int SOURCE_TEXT_IDX = 11;
    private static final int SOURCE_HELPTEXT_IDX = 12;
    private static final int SOURCE_QUICK_HELPTEXT_IDX = 13;
    private static final int SOURCE_TITLETEXT_IDX = 14;
    private static final int TIMESTAMP_IDX = 15;
    private static final int RESTYPE_IDX = 16;
    private static final int TARGET_LANGUAGE_ID_IDX = 20;
    private static final int TARGET_TEXT_IDX = 21;
    private static final int TARGET_HELP_TEXT_IDX = 22;
    private static final int TARGET_QUICKHELP_TEXT_IDX = 23;
    private static final int TARGET_TITLE_TEXT_IDX = 24;
    private static final int FOUND_PARTS_COUNTER_IDX = 18;
    LanguageResolver languageResolver = new LanguageResolver();
    private boolean doBlockCompleteCheck = true;

    public XLIFFReader(DataHandler dataHandler, DataWriter dataWriter) throws IOException {
        this.handler = dataHandler;
        this.target = dataWriter;
    }

    public XLIFFReader(DataHandler dataHandler, DataWriter dataWriter, boolean bl) throws IOException {
        this(dataHandler, dataWriter);
        this.languageResolver = new LanguageResolver();
        this.doBlockCompleteCheck = bl;
    }

    public void initData() {
        int n;
        for (n = 0; n < 10; ++n) {
            this.data[n] = "";
        }
        for (n = 11; n < 15; ++n) {
            this.data[n] = "";
        }
        for (n = 16; n < 20; ++n) {
            this.data[n] = "";
        }
        for (n = 21; n < 26; ++n) {
            this.data[n] = "";
        }
        this.data[3] = "0";
        this.data[18] = "1";
    }

    @Override
    public void startDocument() {
        this.initData();
    }

    @Override
    public void endDocument() {
        try {
            this.showStatistic();
        }
        catch (IOException iOException) {
            OutputHandler.log(iOException.getMessage());
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        this.name = new String(string3);
        this.attrs = new AttributesImpl(attributes);
        String string5 = new String("");
        String string6 = new String("");
        String string7 = new String("");
        if (string3.equals("bpt") || string3.equals("ept") || string3.equals("sub") || string3.equals("ex")) {
            this.storeIt = true;
            return;
        }
        if (string3.equals("target") && (string4 = this.data[16]) != null) {
            if ("res".equals(string4)) {
                index = 21;
                this.storeIt = true;
                return;
            }
            if ("res-QuickHelp".equals(string4)) {
                index = 23;
                this.storeIt = true;
                return;
            }
            if ("res-Title".equals(string4)) {
                index = 24;
                this.storeIt = true;
                return;
            }
        }
        if (string3.equals("source") && (string4 = this.data[16]) != null) {
            if ("res".equals(string4)) {
                index = 11;
                this.storeIt = true;
                return;
            }
            if ("res-QuickHelp".equals(string4)) {
                index = 13;
                this.storeIt = true;
                return;
            }
            if ("res-Title".equals(string4)) {
                index = 14;
                this.storeIt = true;
                return;
            }
        }
        if (string3.equals("file")) {
            this.data[15] = attributes.getValue("date");
            try {
                this.data[10] = this.languageResolver.getISOFromRFC(attributes.getValue("source-language"));
                if (this.languageResolver.getISOFromRFC(attributes.getValue("target-language")) != null) {
                    this.data[20] = this.languageResolver.getISOFromRFC(attributes.getValue("target-language"));
                }
            }
            catch (Exception exception) {
                OutputHandler.log(exception.getMessage());
            }
            return;
        }
        if (string3.equals("trans-unit")) {
            String string8 = attributes.getValue("id");
            if (this.DataStore.get(string8) != null) {
                System.arraycopy((String[])this.DataStore.get(string8), 0, this.data, 0, this.data.length);
                int n = new Integer(this.data[18]);
                this.data[18] = new Integer(++n).toString();
                this.DataStore.remove(attributes.getValue("id"));
            } else {
                this.data[0] = attributes.getValue("id");
            }
            this.data[16] = attributes.getValue("restype");
            return;
        }
        if (string3.equals("context")) {
            String string9 = attributes.getValue("context-type");
            if ("SourceHelpText".equals(string9)) {
                index = 12;
                this.storeIt = true;
                return;
            }
            if ("TargetHelpText".equals(string9)) {
                index = 22;
                this.storeIt = true;
                return;
            }
            if ("DBType".equals(string9)) {
                return;
            }
            if ("Project".equals(string9)) {
                index = 1;
                this.storeIt = true;
                return;
            }
            if ("Filename".equals(string9)) {
                index = 2;
                this.storeIt = true;
                return;
            }
            if ("Type".equals(string9)) {
                index = 16;
                this.storeIt = true;
                return;
            }
            if ("GID".equals(string9)) {
                index = 4;
                this.storeIt = true;
                return;
            }
            if ("LID".equals(string9)) {
                index = 5;
                this.storeIt = true;
                return;
            }
            if ("HID".equals(string9)) {
                index = 6;
                this.storeIt = true;
                return;
            }
            if ("Platform".equals(string9)) {
                index = 7;
                this.storeIt = true;
                return;
            }
            if ("Width".equals(string9)) {
                index = 8;
                this.storeIt = true;
                return;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!(string3.equals("bpt") || string3.equals("ept") || string3.equals("sub") || string3.equals("ex"))) {
            this.storeIt = false;
        }
        if (string3.equals("trans-unit")) {
            this.showData();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2);
        if (this.storeIt) {
            String string2 = new String(cArray, n, n2);
            if (index == this.oldindex) {
                int n3 = index;
                this.data[n3] = this.data[n3] + string2;
            } else {
                this.data[XLIFFReader.index] = string2;
            }
        }
        this.oldindex = index;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        OutputHandler.log(sAXParseException.getMessage());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
        OutputHandler.log("PARSE ERROR in line " + sAXParseException.getLineNumber() + ", " + sAXParseException.getMessage());
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        OutputHandler.log(sAXParseException.getMessage());
    }

    public void showData() throws SAXException {
        ++this.transUnitCounter;
        this.makeDot();
        if (this.isComplete()) {
            try {
                this.moveData();
                if (this.isFirst) {
                    this.sourceLanguage = (String)this.moveData.get("SourceLanguageID");
                    this.targetLanguage = (String)this.moveData.get("TargetLanguageID");
                    OutputHandler.out(EMPTY);
                    OutputHandler.out("Source Language is: " + this.sourceLanguage);
                    OutputHandler.out("Target Language is: " + this.targetLanguage);
                    OutputHandler.out(EMPTY);
                    OutputHandler.out("Start");
                    OutputHandler.out(EMPTY);
                    this.isFirst = false;
                }
                this.target.getDataFrom(this.handler);
                this.target.writeData();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        } else {
            this.DataStore.put(this.data[0], this.data.clone());
            this.initData();
        }
        this.initData();
    }

    public final void moveData() {
        this.moveData.put("BlockNr", this.data[0]);
        this.moveData.put("Project", this.data[1]);
        this.moveData.put("SourceFile", this.data[2]);
        this.moveData.put("Dummy", "0");
        this.moveData.put("ResType", this.data[16]);
        this.moveData.put("GID", this.data[4]);
        this.moveData.put("LID", this.data[5]);
        this.moveData.put("HID", this.data[6]);
        this.moveData.put("Platform", this.data[7]);
        if (EMPTY.equals(this.data[8])) {
            this.data[8] = "0";
        }
        this.moveData.put("Width", this.data[8]);
        this.moveData.put("SourceLanguageID", this.data[10]);
        this.moveData.put("SourceText", this.data[11]);
        this.moveData.put("SourceHText", this.data[12]);
        this.moveData.put("SourceQText", this.data[13]);
        this.moveData.put("SourceTitle", this.data[14]);
        this.moveData.put("TargetLanguageID", this.data[20]);
        this.moveData.put("TargetText", this.data[21]);
        this.moveData.put("TargetHText", this.data[22]);
        this.moveData.put("TargetQText", this.data[23]);
        this.moveData.put("TargetTitle", this.data[24]);
        this.moveData.put("TimeStamp", this.data[15]);
        this.handler.fillDataWith(this.moveData);
    }

    public final boolean isComplete() {
        String string;
        String string2;
        if (!this.doBlockCompleteCheck) {
            return true;
        }
        if (this.data[18] == EMPTY) {
            this.data[18] = "1";
        }
        return (string2 = this.data[18]).equals(string = this.data[0].substring(this.data[0].lastIndexOf(":") + 1));
    }

    private void makeDot() {
        int n = 0;
        n = this.transUnitCounter / 1000;
        if (n > this.dotCount) {
            this.dotCount = n;
            OutputHandler.printDot();
        }
    }

    final void showStatistic() throws IOException {
        OutputHandler.out(EMPTY);
        OutputHandler.out("TransUnits found:  " + this.transUnitCounter);
        OutputHandler.dbg("TransUnits skip :  " + this.DataStore.size());
    }
}

