/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.converter.ConverterException;
import com.sun.star.tooling.converter.DataReader;
import com.sun.star.tooling.converter.ExtMap;
import com.sun.star.tooling.converter.LineErrorException;
import com.sun.star.tooling.converter.OutputHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class SDFReader
extends DataReader {
    static final String[] fieldnames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "LanguageID", "Text", "HText", "QText", "Title", "TimeStamp"};
    static final String[] sourceLineNames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "SourceLanguageID", "SourceText", "SourceHText", "SourceQText", "SourceTitle", "TimeStamp"};
    static final String[] targetLineNames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "TargetLanguageID", "TargetText", "TargetHText", "TargetQText", "TargetTitle", "TimeStamp"};
    static final String EMPTY = new String("");
    private int dotCount = 0;
    private Map sourceMap;
    private Map targetMap;
    private Map SDFMap;
    private Map[] data = new Map[]{this.sourceMap, this.targetMap};
    private String CurrentBlockId;
    private File sourceFile;
    protected String sourceLanguage;
    protected String targetLanguage;
    private long blockNr = 0L;
    private int skippedLines = 0;
    private boolean endIt = false;
    private boolean foundTarget = false;
    private boolean foundSource = false;
    private int langMiss;
    private boolean useBuffer = false;
    private String lineBuffer;
    private String[] splittedLineBuffer;
    private int skippedBlocks;
    private int targetLangMiss;
    private int sourceLangMiss;
    private int targetLangCreate;
    DecimalFormat blockNrFormatter = new DecimalFormat("000000");
    private int CurrentBlockHash;
    private boolean skip;

    public SDFReader(File file, String string, String string2, String string3) throws IOException {
        super(new InputStreamReader((InputStream)new FileInputStream(file), string3));
        this.sourceFile = file;
        this.sourceLanguage = string;
        this.targetLanguage = string2;
        this.mark(16000);
        String string4 = this.readLine();
        if (string4 != null) {
            String[] stringArray = this.split(string4);
            if (stringArray != null) {
                this.CurrentBlockId = this.getSDFBlockId(stringArray);
                this.CurrentBlockHash = this.CurrentBlockId.hashCode();
                ++this.blockNr;
            }
            this.splittedLineBuffer = stringArray;
        }
        this.reset();
    }

    @Override
    public Map getData() throws IOException {
        HashMap hashMap = new HashMap();
        this.skip = false;
        Map[] mapArray = this.readBlock();
        if (mapArray == null || mapArray[1] == null || mapArray[0] == null) {
            return null;
        }
        hashMap.putAll(mapArray[1]);
        hashMap.putAll(mapArray[0]);
        return hashMap;
    }

    public Map[] readBlock() throws IOException {
        String string = EMPTY;
        String string2 = EMPTY;
        String[] stringArray = null;
        this.data[0] = new ExtMap();
        this.data[1] = new ExtMap();
        Object var5_4 = null;
        while (this.useBuffer || (string = this.readLine()) != null) {
            try {
                if (this.useBuffer) {
                    string = this.lineBuffer;
                    stringArray = this.splittedLineBuffer;
                    this.SDFMap = new ExtMap(fieldnames, stringArray);
                    try {
                        this.checkLanguage(stringArray);
                        continue;
                    }
                    catch (ConverterException converterException) {
                        throw converterException;
                    }
                    finally {
                        this.useBuffer = false;
                        continue;
                    }
                }
                if (this.check(string).length() < string.length()) {
                    throw new LineErrorException(this.getLineNumber() + " : Line contains wrong character " + " \n" + string);
                }
                stringArray = this.split(string);
                if (stringArray == null) {
                    throw new LineErrorException(super.getLineNumber() + " : Line has wrong column number \n" + string);
                }
                this.makeDot();
                string2 = this.getSDFBlockId(stringArray);
                if (string2.equals(this.CurrentBlockId)) {
                    this.SDFMap = new ExtMap(fieldnames, stringArray);
                    this.checkLanguage(stringArray);
                    continue;
                }
                if (!this.foundTarget) {
                    this.createTargetLine();
                }
                ++this.blockNr;
                this.splittedLineBuffer = stringArray;
                this.lineBuffer = string;
                this.useBuffer = true;
                this.CurrentBlockId = string2;
                this.CurrentBlockHash = this.CurrentBlockId.hashCode();
                if (this.foundSource) break;
                OutputHandler.log("Error in Line:" + this.getLineNumber() + "Source Language is missing maybe " + "previous block has an error.\nBlock " + (this.blockNr - 1L) + " is skipped. before line: \n" + string);
                this.foundTarget = false;
                ++this.skippedBlocks;
                ++this.skippedLines;
                ++this.sourceLangMiss;
            }
            catch (LineErrorException lineErrorException) {
                OutputHandler.log(lineErrorException.getMessage());
                ++this.skippedLines;
            }
            catch (ConverterException converterException) {
                OutputHandler.log(converterException.getMessage());
            }
        }
        if (null != string) {
            this.foundSource = false;
            this.foundTarget = false;
            return this.data;
        }
        if (!this.endIt) {
            this.endIt = true;
            if (!this.foundTarget) {
                this.createTargetLine();
            }
            return this.data;
        }
        this.showStat();
        return null;
    }

    private void createTargetLine() {
        ++this.targetLangMiss;
        this.data[1] = new ExtMap(targetLineNames, this.splittedLineBuffer);
        this.data[1].put("TargetLanguageID", this.targetLanguage);
        if ((String)this.data[1].get("TargetText") != EMPTY) {
            this.data[1].put("TargetText", EMPTY);
        }
        if ((String)this.data[1].get("TargetHText") != EMPTY) {
            this.data[1].put("TargetHText", EMPTY);
        }
        if ((String)this.data[1].get("TargetQText") != EMPTY) {
            this.data[1].put("TargetQText", EMPTY);
        }
        if ((String)this.data[1].get("TargetTitle") != EMPTY) {
            this.data[1].put("TargetTitle", EMPTY);
        }
        this.data[1].put("BlockNr", this.blockNrFormatter.format(this.blockNr) + '-' + Integer.toString(this.CurrentBlockHash));
        ++this.targetLangCreate;
    }

    private void showStat() throws IOException {
        OutputHandler.out(EMPTY);
        OutputHandler.out(EMPTY);
        OutputHandler.out("Blocks found:           " + this.blockNr + " ");
        OutputHandler.out(EMPTY);
        OutputHandler.out("Lines read:             " + this.getLineNumber() + " ");
        OutputHandler.dbg("Lines created           " + this.targetLangCreate + " ");
        OutputHandler.dbg("                        -------");
        OutputHandler.dbg("Lines total:            " + (this.getLineNumber() + this.targetLangCreate) + " ");
        OutputHandler.dbg("Lines skipped:          " + this.skippedLines + " ");
        OutputHandler.dbg("Source Language misses: " + this.sourceLangMiss + " ");
        OutputHandler.dbg("Target Language misses: " + this.targetLangMiss + " ");
        OutputHandler.dbg("Blocks found:           " + this.blockNr + " ");
        OutputHandler.dbg("Blocks skipped:         " + this.skippedBlocks + " ");
        if (this.sourceLangMiss + this.skippedBlocks + this.skippedLines > 0) {
            OutputHandler.out("\n---! Errors found !--- view Logfile.\n\nTo enable logfile use -l option at command line.\nFor help type 'convert -h {Enter}'.\n");
        }
    }

    private final void checkLanguage(String[] stringArray) throws ConverterException, IOException {
        String string = (String)this.SDFMap.get("LanguageID");
        if (!this.foundSource && this.sourceLanguage.equals(string)) {
            this.data[0] = new ExtMap(sourceLineNames, stringArray);
            this.data[0].put("BlockNr", this.blockNrFormatter.format(this.blockNr) + '-' + Integer.toHexString(this.CurrentBlockHash));
            this.foundSource = true;
            return;
        }
        if (!this.foundTarget) {
            if (this.targetLanguage.equals(EMPTY)) {
                if (!string.equals(this.sourceLanguage)) {
                    this.targetLanguage = string;
                    OutputHandler.out("Source Language is: " + this.sourceLanguage + " ");
                    OutputHandler.out("Target Language is: " + this.targetLanguage + " ");
                    OutputHandler.out(EMPTY);
                    System.out.println("Start");
                } else {
                    throw new ConverterException("(" + this.getLineNumber() + ") No target language found: " + this.targetLanguage);
                }
            }
            if (this.targetLanguage.equals(string)) {
                this.data[1] = new ExtMap(targetLineNames, stringArray);
                this.data[1].put("BlockNr", this.blockNrFormatter.format(this.blockNr) + '-' + Integer.toHexString(this.CurrentBlockHash));
                this.foundTarget = true;
                return;
            }
        }
        throw new ConverterException("found not needed language '" + this.SDFMap.get("LanguageID") + "' in Line: " + this.getLineNumber());
    }

    private void makeDot() {
        int n = 0;
        n = super.getLineNumber() / 1000;
        if (n > this.dotCount) {
            this.dotCount = n;
            OutputHandler.printDot();
        }
    }

    private String[] split(String string) throws IOException {
        this.check(string);
        String[] stringArray = string.split("\t");
        if (stringArray.length == 15) {
            return stringArray;
        }
        return null;
    }

    private String getSDFBlockId(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String check(String string) throws IOException {
        char c = ' ';
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= 30 || c == 9) continue;
            return new Character(c).toString();
        }
        return string;
    }
}

