/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.converter.Converter;
import com.sun.star.tooling.converter.DataHandler;
import com.sun.star.tooling.converter.DataWriter;
import com.sun.star.tooling.converter.ExtMap;
import com.sun.star.tooling.converter.OutputHandler;
import com.sun.star.tooling.converter.ResTypeResolver;
import com.sun.star.tooling.languageResolver.LanguageResolver;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class GSIWriter
extends DataWriter {
    final String seperator = new String("($$)");
    static final String[] sourceLineNames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "SourceLanguageID", "SourceText", "SourceHText", "SourceQText", "SourceTitle", "TimeStamp"};
    static final String[] targetLineNames = new String[]{"Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "TargetLanguageID", "TargetText", "TargetHText", "TargetQText", "TargetTitle", "TimeStamp"};
    static final String[] outLineNames = new String[]{"BlockNr", "Project", "SourceFile", "Dummy", "ResType", "GID", "LID", "HID", "Platform", "Width", "SourceLanguageID", "SourceText", "SourceHText", "SourceQText", "SourceTitle", "TargetLanguageID", "TargetText", "TargetHText", "TargetQText", "TargetTitle", "TimeStamp"};
    private ExtMap sourceLine = new ExtMap(sourceLineNames, null);
    private ExtMap targetLine = new ExtMap(targetLineNames, null);
    private ExtMap outData = new ExtMap(outLineNames, null);
    private static final String EMPTY = new String("");
    private String sourceLanguage;
    private String targetLanguage;
    private static final String lineEnd = "!\r\n";
    private String blockNr;

    public GSIWriter(BufferedOutputStream bufferedOutputStream, String string) throws UnsupportedEncodingException {
        super(bufferedOutputStream, string);
    }

    @Override
    public final void writeData() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.sourceLanguage == null && this.targetLanguage == null) {
            LanguageResolver languageResolver = new LanguageResolver();
            try {
                this.sourceLanguage = languageResolver.getNrFromISO((String)this.outData.get("SourceLanguageID"));
                this.targetLanguage = languageResolver.getNrFromISO((String)this.outData.get("TargetLanguageID"));
            }
            catch (LanguageResolver.LanguageResolvingException languageResolvingException) {
                OutputHandler.out(languageResolvingException.getMessage());
                System.exit(0);
            }
        }
        this.blockNr = (String)this.outData.get("BlockNr");
        stringBuffer.append(this.getSourceLine("Text"));
        stringBuffer.append(this.getSourceLine("HText"));
        stringBuffer.append(this.getSourceLine("QText"));
        stringBuffer.append(this.getSourceLine("Title"));
        stringBuffer.append(this.getTargetLine("Text"));
        stringBuffer.append(this.getTargetLine("HText"));
        stringBuffer.append(this.getTargetLine("QText"));
        stringBuffer.append(this.getTargetLine("Title"));
        this.write(stringBuffer.toString());
    }

    private StringBuffer getSourceLine(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string2 = "Source" + string;
        if (EMPTY.equals((String)this.outData.get(string2)) || " ".equals(this.outData.get(string2))) {
            return new StringBuffer(EMPTY);
        }
        stringBuffer.append(this.blockNr);
        stringBuffer.append(this.seperator);
        stringBuffer.append(ResTypeResolver.getExternKey(string));
        stringBuffer.append(this.seperator);
        stringBuffer.append(this.sourceLanguage);
        stringBuffer.append(this.seperator);
        stringBuffer.append("int");
        stringBuffer.append(this.seperator);
        stringBuffer.append(this.outData.get(string2));
        stringBuffer.append(lineEnd);
        Converter.countLine();
        return stringBuffer;
    }

    private StringBuffer getTargetLine(String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        String string2 = "Target" + string;
        if (EMPTY.equals((String)this.outData.get(string2)) || " ".equals(this.outData.get(string2))) {
            return new StringBuffer(EMPTY);
        }
        stringBuffer.append(this.blockNr);
        stringBuffer.append(this.seperator);
        stringBuffer.append(ResTypeResolver.getExternKey(string));
        stringBuffer.append(this.seperator);
        stringBuffer.append(this.targetLanguage);
        stringBuffer.append(this.seperator);
        stringBuffer.append("ext");
        stringBuffer.append(this.seperator);
        stringBuffer.append(this.outData.get(string2));
        stringBuffer.append(lineEnd);
        Converter.countLine();
        return stringBuffer;
    }

    protected void writeData(Map[] mapArray) throws IOException {
    }

    @Override
    protected void getDataFrom(DataHandler dataHandler) throws IOException {
        dataHandler.putDataTo(this.outData);
    }

    @Override
    protected void getDatafrom(DataHandler dataHandler) throws IOException {
        dataHandler.putDataTo(this.outData);
    }
}

