/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.converter.DataReader;
import com.sun.star.tooling.converter.ExtMap;
import com.sun.star.tooling.converter.OutputHandler;
import com.sun.star.tooling.converter.ResTypeResolver;
import com.sun.star.tooling.languageResolver.LanguageResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class GSIReader
extends DataReader {
    private Map EmptyGSIBlock;
    LanguageResolver languageResolver = new LanguageResolver();
    protected String sourceLanguage;
    protected String targetLanguage;
    private String oldBlockNr;
    private Map GSILineBuffer;
    private boolean useBuffer = false;
    private static final String EMPTY = new String("");
    private ExtMap EmptyLanguageMap;
    private boolean isFirst = true;
    private int lineCounter;
    private int blockCounter;
    private boolean lastLineFound = false;

    public GSIReader(File file, String string, String string2, String string3) throws IOException {
        super(new InputStreamReader((InputStream)new FileInputStream(file), string3));
        this.sourceLanguage = string;
        this.targetLanguage = string2;
        this.EmptyLanguageMap = new ExtMap(new String[0], new String[0]);
    }

    public Map getGSIData() throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(this.sourceLanguage, this.EmptyLanguageMap.clone());
        hashMap.put(this.targetLanguage, this.EmptyLanguageMap.clone());
        String string = EMPTY;
        String[] stringArray = new String[]{"BlockNr", "resType", "languageNr", "status", "content"};
        while (this.useBuffer || (string = this.readLine()) != null) {
            Map map;
            if (this.useBuffer) {
                map = this.GSILineBuffer;
                hashMap.put(this.sourceLanguage, this.EmptyLanguageMap.clone());
                hashMap.put(this.targetLanguage, this.EmptyLanguageMap.clone());
                hashMap.put("BlockNr", map.get("BlockNr"));
                this.useBuffer = false;
            } else {
                ++this.lineCounter;
                String[] stringArray2 = this.split(string);
                if (stringArray2 == null) continue;
                map = new ExtMap(stringArray, stringArray2);
                if (this.isFirst) {
                    hashMap.put("BlockNr", map.get("BlockNr"));
                    this.oldBlockNr = (String)map.get("BlockNr");
                    this.isFirst = false;
                }
            }
            if (this.oldBlockNr == null) {
                this.oldBlockNr = (String)map.get("BlockNr");
            }
            if (!this.oldBlockNr.equals((String)map.get("BlockNr"))) {
                this.GSILineBuffer = map;
                this.oldBlockNr = (String)map.get("BlockNr");
                this.useBuffer = true;
                break;
            }
            try {
                String string2 = this.languageResolver.getISOfromNr((String)map.get("languageNr"));
                if (string2.equals(this.sourceLanguage)) {
                    ((Map)hashMap.get(this.sourceLanguage)).put("Source" + ResTypeResolver.getInternKey((String)map.get("resType")), map.get("content"));
                    continue;
                }
                if (this.targetLanguage.equals(EMPTY)) {
                    this.targetLanguage = string2;
                    hashMap.put(this.targetLanguage, this.EmptyLanguageMap.clone());
                }
                if (!string2.equals(this.targetLanguage)) continue;
                ((Map)hashMap.get(this.targetLanguage)).put("Target" + ResTypeResolver.getInternKey((String)map.get("resType")), map.get("content"));
            }
            catch (LanguageResolver.LanguageResolvingException languageResolvingException) {
                OutputHandler.out("Can not resolve the language " + languageResolvingException.getMessage());
            }
        }
        if (string == null) {
            if (this.lastLineFound) {
                OutputHandler.out("\n\n");
                OutputHandler.out("GSI Blocks    :         " + this.blockCounter);
                OutputHandler.out("GSI Lines     :         " + this.lineCounter);
                return null;
            }
            this.lastLineFound = true;
            ++this.blockCounter;
            return hashMap;
        }
        ++this.blockCounter;
        return hashMap;
    }

    private String[] split(String string) {
        String[] stringArray = string.substring(0, string.length() - 1).split("\\(\\$\\$\\)");
        if (stringArray.length != 5) {
            return null;
        }
        return stringArray;
    }
}

