/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.converter;

import com.sun.star.tooling.converter.ConverterException;
import com.sun.star.tooling.converter.DataHandler;
import com.sun.star.tooling.converter.DataReader;
import com.sun.star.tooling.converter.DataWriter;
import com.sun.star.tooling.converter.FileMaker;
import com.sun.star.tooling.converter.GSIWriter;
import com.sun.star.tooling.converter.GSIandSDFMerger;
import com.sun.star.tooling.converter.OutputHandler;
import com.sun.star.tooling.converter.Resolver;
import com.sun.star.tooling.converter.SDFReader;
import com.sun.star.tooling.converter.SDFWriter;
import com.sun.star.tooling.converter.XLIFFReader;
import com.sun.star.tooling.converter.XLIFFWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class Converter {
    private static final String CHARSET = new String("UTF-8");
    private static final String EMPTY = new String("");
    private static DataHandler handler;
    private static int lineCounter;
    private static DataWriter theTargetWriter;
    private boolean overwrite = false;
    private Source reader;
    private String sourceString;
    private String sourceType;
    private String targetString;
    private String targetType;
    private Target writer;
    String sourceLanguage = "en-US";
    String targetLanguage = "";
    private String secondSourceString = EMPTY;

    public static int getLineCounter() {
        return lineCounter;
    }

    static final void countLine() {
        ++lineCounter;
    }

    public Converter(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) throws IOException, Exception {
        this.sourceType = string;
        this.sourceString = string2;
        this.sourceLanguage = string3;
        this.targetType = string4;
        this.targetString = string5;
        this.targetLanguage = string6;
        this.secondSourceString = string7;
        this.overwrite = bl;
        handler = new DataHandler();
        if ("sdf".equalsIgnoreCase(string)) {
            this.reader = new SDFSource();
        } else if ("xliff".equalsIgnoreCase(string) || "dbxliff".equalsIgnoreCase(string)) {
            this.reader = new XLIFFSource();
        } else if ("gsi".equalsIgnoreCase(string)) {
            this.reader = new GSISource();
        } else {
            throw new ConverterException("Unknown Source File Type: '" + string + "'");
        }
        if ("sdf".equalsIgnoreCase(string4)) {
            this.writer = new SDFTarget();
        } else if ("xliff".equalsIgnoreCase(string4)) {
            this.writer = new XLIFFTarget();
        } else if ("gsi".equalsIgnoreCase(string4)) {
            this.writer = new GSITarget();
        } else {
            throw new ConverterException("Unknown Target File Type: '" + string4 + "'");
        }
    }

    public final void convert() throws IOException {
        try {
            this.reader.convertTo(this.writer);
            theTargetWriter.flush();
            theTargetWriter.close();
        }
        catch (Exception exception) {
            OutputHandler.out(exception.getMessage());
        }
    }

    private class XLIFFTarget
    implements Target {
        File target;

        public XLIFFTarget() throws FileNotFoundException, IOException {
            this.target = FileMaker.newFile(Converter.this.targetString, Converter.this.overwrite);
            theTargetWriter = new XLIFFWriter(new BufferedOutputStream(new FileOutputStream(this.target)), CHARSET);
        }

        @Override
        public DataWriter getWriter() {
            return theTargetWriter;
        }
    }

    private class XLIFFSource
    implements Source {
        File source;

        public XLIFFSource() {
            this.source = new File(Converter.this.sourceString);
        }

        @Override
        public void convertTo(Target target) throws IOException {
            try {
                System.setProperty("entityExpansionLimit", "1000000");
                boolean bl = this.source.canRead();
                if (bl) {
                    XLIFFReader xLIFFReader = null;
                    xLIFFReader = "dbxliff".equalsIgnoreCase(Converter.this.sourceType) ? new XLIFFReader(handler, target.getWriter(), false) : new XLIFFReader(handler, target.getWriter());
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    sAXParserFactory.setValidating(true);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    XMLReader xMLReader = sAXParser.getXMLReader();
                    xMLReader.setErrorHandler(xLIFFReader);
                    xMLReader.setContentHandler(xLIFFReader);
                    Resolver resolver = new Resolver();
                    xMLReader.setEntityResolver(resolver);
                    xMLReader.parse(Converter.this.sourceString);
                } else {
                    System.out.println("Datei existiert nicht");
                }
            }
            catch (SAXParseException sAXParseException) {
                try {
                    theTargetWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                OutputHandler.out("PARSE ERROR Zeile " + sAXParseException.getLineNumber() + ", " + sAXParseException.getMessage());
            }
            catch (SAXException sAXException) {
                try {
                    theTargetWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                OutputHandler.out("PARSE EXCEPTION " + sAXException.getMessage());
            }
            catch (ParserConfigurationException parserConfigurationException) {
                OutputHandler.out("PARSER Configuration failed\n " + parserConfigurationException.getMessage());
            }
        }
    }

    private static interface Target {
        public static final OutputStream writer = null;

        public DataWriter getWriter();
    }

    private static interface Source {
        public static final DataReader Source = null;

        public void convertTo(Target var1) throws IOException;
    }

    private class SDFTarget
    implements Target {
        public SDFTarget() throws IOException {
            File file = FileMaker.newFile(Converter.this.targetString, Converter.this.overwrite);
            theTargetWriter = new SDFWriter(new BufferedOutputStream(new FileOutputStream(file)), CHARSET);
        }

        @Override
        public DataWriter getWriter() {
            return theTargetWriter;
        }
    }

    private final class SDFSource
    implements Source {
        DataReader Source;

        public SDFSource() throws IOException, Exception {
            this.Source = new SDFReader(new File(Converter.this.sourceString), Converter.this.sourceLanguage, Converter.this.targetLanguage, CHARSET);
        }

        @Override
        public void convertTo(Target target) {
            try {
                theTargetWriter = target.getWriter();
                while (handler.fillDataFrom(this.Source)) {
                    theTargetWriter.getDatafrom(handler);
                    theTargetWriter.writeData();
                }
            }
            catch (IOException iOException) {
                OutputHandler.out(iOException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class GSITarget
    implements Target {
        File target;

        public GSITarget() throws FileNotFoundException, IOException {
            this.target = FileMaker.newFile(Converter.this.targetString, Converter.this.overwrite);
            theTargetWriter = new GSIWriter(new BufferedOutputStream(new FileOutputStream(this.target)), CHARSET);
        }

        @Override
        public DataWriter getWriter() {
            return theTargetWriter;
        }
    }

    private class GSISource
    implements Source {
        DataReader theSourceReader;

        public GSISource() throws IOException {
            this.theSourceReader = new GSIandSDFMerger(new File(Converter.this.sourceString), new File(Converter.this.secondSourceString), Converter.this.sourceLanguage, Converter.this.targetLanguage, CHARSET);
        }

        @Override
        public void convertTo(Target target) {
            try {
                theTargetWriter = target.getWriter();
                while (handler.fillDataFrom(this.theSourceReader)) {
                    theTargetWriter.getDatafrom(handler);
                    theTargetWriter.writeData();
                }
            }
            catch (IOException iOException) {
                OutputHandler.out(iOException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

