/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tooling.DirtyTags;

import com.sun.star.tooling.DirtyTags.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class TagPair {
    private Tag startTag = Tag.EMPTYTAG;
    private Tag endTag = Tag.EMPTYTAG;
    private String startingText = "";
    private ArrayList enclosedTags = new ArrayList();
    private long id;
    private static int ElementCounter = 1;
    private String endingText = "";

    public TagPair() {
    }

    public TagPair(ArrayList arrayList) throws TagPairConstructionException {
        if (arrayList.size() == 0) {
            return;
        }
        ArrayList<Tag> arrayList2 = new ArrayList<Tag>();
        Tag tag = (Tag)arrayList.get(0);
        arrayList.remove(0);
        if ("Text".equals(tag.getTagType())) {
            if (arrayList.size() == 0) {
                this.startingText = tag.getTagString();
                return;
            }
            arrayList2.add(tag);
            this.startingText = tag.getTagString();
        } else if (!"EndTag".equals(tag.getTagType())) {
            if ("StartTag".equals(tag.getTagType())) {
                this.startTag = tag;
                Iterator iterator = arrayList.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    tag = (Tag)iterator.next();
                    if (tag.getTagName().equals('/' + this.startTag.getTagName()) && n == 0) {
                        this.id = ElementCounter++;
                        this.endTag = tag;
                        arrayList.removeAll(arrayList2);
                        arrayList.remove(tag);
                        break;
                    }
                    if (tag.getTagName().equals(this.startTag.getTagName()) && tag.getTagType().equals("StartTag")) {
                        ++n;
                    }
                    if (tag.getTagName().equals("/" + this.startTag.getTagName()) && tag.getTagType().equals("EndTag")) {
                        --n;
                    }
                    arrayList2.add(tag);
                }
                if (this.endTag.getTagType() == "") {
                    throw new TagPairConstructionException("ERROR: Missing end tag (" + this.startTag.getTagString() + ").");
                }
                if (arrayList2.size() >= 1 && ((Tag)arrayList2.get(0)).getTagType().equals("Text")) {
                    this.startingText = ((Tag)arrayList2.get(0)).getTagString();
                    arrayList2.remove(0);
                }
                if (arrayList2.size() >= 1 && ((Tag)arrayList2.get(arrayList2.size() - 1)).getTagType().equals("Text")) {
                    this.endingText = ((Tag)arrayList2.get(arrayList2.size() - 1)).getTagString();
                    arrayList2.remove(arrayList2.size() - 1);
                }
                this.createEnclosedTags(arrayList2);
            } else if ("StartAndEndTag".equals(tag.getTagType())) {
                this.startTag = tag;
                this.endTag = new Tag("EndOfStandAlone", "", "");
                this.createEnclosedTags(arrayList2);
            }
        }
    }

    private void createEnclosedTags(ArrayList arrayList) throws TagPairConstructionException {
        while (arrayList.size() > 0) {
            this.enclosedTags.add(new TagPair(arrayList));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.startTag.toString());
        TagPair tagPair = new TagPair();
        Iterator iterator = this.enclosedTags.iterator();
        stringBuffer.append(this.startingText);
        while (iterator.hasNext()) {
            tagPair = (TagPair)iterator.next();
            if (tagPair == null) continue;
            stringBuffer.append(tagPair.toString());
        }
        stringBuffer.append(this.endingText);
        stringBuffer.append(this.endTag.toString());
        return new String(stringBuffer);
    }

    public String getWrapped() throws IOException {
        Iterator iterator = this.enclosedTags.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.wrap(this.startTag) + this.xmlString(this.startingText));
        while (iterator.hasNext()) {
            stringBuffer.append(((TagPair)iterator.next()).getWrapped());
        }
        stringBuffer.append(this.xmlString(this.endingText) + this.wrap(this.endTag));
        return new String(stringBuffer);
    }

    private String wrap(Tag tag) throws IOException {
        String string = "";
        if (tag.getTagType().startsWith("Start")) {
            return new String("<bpt id='" + this.id + "'>" + tag.getWrappedTagString() + "</bpt>");
        }
        if (tag.getTagType().startsWith("End")) {
            string = tag.getWrappedTagString();
            return new String("<ept id='" + this.id + "'>" + string + "</ept>");
        }
        return this.xmlString(tag.getTagString());
    }

    private final String xmlString(String string) throws IOException {
        if (string == null) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) == '&') {
                string2 = string2.substring(0, i) + "&amp;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) == '<') {
                string2 = string2.substring(0, i) + "&lt;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) == '>') {
                string2 = string2.substring(0, i) + "&gt;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) == '\"') {
                string2 = string2.substring(0, i) + "&quot;" + string2.substring(i + 1);
                continue;
            }
            if (string2.charAt(i) != '\'') continue;
            string2 = string2.substring(0, i) + "&apos;" + string2.substring(i + 1);
        }
        return string2;
    }

    public static void resetCounter() {
        ElementCounter = 1;
    }

    public class TagPairConstructionException
    extends Exception {
        public TagPairConstructionException(String string) {
        }
    }
}

